/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextByGraphNameRequest;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextByGraphNameResponse;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextsRequest;
import org.janusgraph.graphdb.grpc.GetJanusGraphContextsResponse;
import org.janusgraph.graphdb.grpc.GetVersionRequest;
import org.janusgraph.graphdb.grpc.GetVersionResponse;
import org.janusgraph.graphdb.grpc.JanusGraphManagerServiceGrpc;
import org.janusgraph.graphdb.grpc.types.JanusGraphContext;

public class JanusGraphManagerClient {
    private final JanusGraphManagerServiceGrpc.JanusGraphManagerServiceBlockingStub blockingStub;

    public JanusGraphManagerClient(Channel channel) {
        this.blockingStub = JanusGraphManagerServiceGrpc.newBlockingStub(channel);
    }

    public JanusGraphManagerClient(String target) {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
        this.blockingStub = JanusGraphManagerServiceGrpc.newBlockingStub((Channel)channel);
    }

    public JanusGraphContext getContextByGraphName(String name) {
        GetJanusGraphContextByGraphNameRequest request = GetJanusGraphContextByGraphNameRequest.newBuilder().setGraphName(name).build();
        GetJanusGraphContextByGraphNameResponse response = this.blockingStub.getJanusGraphContextByGraphName(request);
        return response.getContext();
    }

    public List<JanusGraphContext> getContexts() {
        GetJanusGraphContextsRequest request = GetJanusGraphContextsRequest.newBuilder().build();
        GetJanusGraphContextsResponse janusGraphContexts = this.blockingStub.getJanusGraphContexts(request);
        return janusGraphContexts.getContextsList();
    }

    public String getTinkerPopVersion() {
        GetVersionRequest request = GetVersionRequest.newBuilder().build();
        GetVersionResponse response = this.blockingStub.getVersion(request);
        return response.getTinkerpopVersion();
    }

    public String getJanusGraphVersion() {
        GetVersionRequest request = GetVersionRequest.newBuilder().build();
        GetVersionResponse response = this.blockingStub.getVersion(request);
        return response.getJanusgraphVersion();
    }
}

