/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.janusgraph.diskstorage.es.ElasticSearchMutation;
import org.janusgraph.diskstorage.es.rest.RestBulkResponse;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class RestClientBulkRequestsTest {
    @Mock
    private RestClient restClientMock;
    @Mock
    private Response response;
    @Mock
    private StatusLine statusLine;
    @Captor
    private ArgumentCaptor<Request> requestCaptor;

    RestElasticSearchClient createClient(int bulkChunkSerializedLimitBytes) throws IOException {
        Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException()});
        RestElasticSearchClient clientUnderTest = new RestElasticSearchClient(this.restClientMock, 0, false, 0, Collections.emptySet(), 0L, 0L, bulkChunkSerializedLimitBytes);
        Mockito.reset((Object[])new RestClient[]{this.restClientMock});
        return clientUnderTest;
    }

    @Test
    public void testSplittingOfLargeBulkItems() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)200);
        RestBulkResponse singletonBulkItemResponseSuccess = new RestBulkResponse();
        singletonBulkItemResponseSuccess.setItems(Collections.singletonList(Collections.singletonMap("index", new RestBulkResponse.RestBulkItemResponse())));
        byte[] singletonBulkItemResponseSuccessBytes = mapper.writeValueAsBytes((Object)singletonBulkItemResponseSuccess);
        HttpEntity singletonBulkItemHttpEntityMock = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)singletonBulkItemHttpEntityMock.getContent()).thenReturn((Object)new ByteArrayInputStream(singletonBulkItemResponseSuccessBytes)).thenReturn((Object)new ByteArrayInputStream(singletonBulkItemResponseSuccessBytes));
        Mockito.when((Object)this.response.getEntity()).thenReturn((Object)singletonBulkItemHttpEntityMock);
        Mockito.when((Object)this.response.getStatusLine()).thenReturn((Object)this.statusLine);
        int bulkLimit = 800;
        try (RestElasticSearchClient restClientUnderTest = this.createClient(bulkLimit);){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenReturn((Object)this.response).thenReturn((Object)this.response);
            StringBuilder payloadBuilder = new StringBuilder();
            IntStream.range(0, bulkLimit - 100).forEach(value -> payloadBuilder.append("a"));
            String largePayload = payloadBuilder.toString();
            restClientUnderTest.bulkRequest(Arrays.asList(ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id1", Collections.singletonMap("someKey", largePayload)), ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id2", Collections.singletonMap("someKey", largePayload))), null);
            ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)2))).performRequest((Request)this.requestCaptor.capture());
        }
    }

    @Test
    public void testThrowingForOverlyLargeBulkItemOnlyAfterSmallerItemsAreChunked() throws IOException {
        int bulkLimit = 1000000;
        StringBuilder overlyLargePayloadBuilder = new StringBuilder();
        IntStream.range(0, bulkLimit * 10).forEach(value -> overlyLargePayloadBuilder.append("a"));
        String overlyLargePayload = overlyLargePayloadBuilder.toString();
        ElasticSearchMutation overlyLargeMutation = ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id2", Collections.singletonMap("someKey", overlyLargePayload));
        List<ElasticSearchMutation> bulkItems = Arrays.asList(ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id1", Collections.singletonMap("someKey", "small_payload1")), overlyLargeMutation, ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id3", Collections.singletonMap("someKey", "small_payload2")));
        try (RestElasticSearchClient restClientUnderTest = this.createClient(bulkLimit);){
            RestElasticSearchClient restElasticSearchClient = restClientUnderTest;
            restElasticSearchClient.getClass();
            RestElasticSearchClient.BulkRequestChunker chunkerUnderTest = new RestElasticSearchClient.BulkRequestChunker(restElasticSearchClient, bulkItems);
            RestElasticSearchClient restElasticSearchClient2 = restClientUnderTest;
            restElasticSearchClient2.getClass();
            int overlyLargeRequestExpectedSize = new RestElasticSearchClient.RequestBytes(restElasticSearchClient2, overlyLargeMutation).getSerializedSize();
            List smallItemsChunk = chunkerUnderTest.next();
            Assertions.assertEquals((int)2, (int)smallItemsChunk.size());
            Assertions.assertTrue((boolean)chunkerUnderTest.hasNext());
            IllegalArgumentException thrownException = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ((RestElasticSearchClient.BulkRequestChunker)chunkerUnderTest).next(), (String)"Should have thrown due to bulk request item being too large");
            String expectedExceptionMessage = String.format("Bulk request item(s) larger than permitted chunk limit. Limit is %s. Serialized item size(s) [%s]", bulkLimit, overlyLargeRequestExpectedSize);
            Assertions.assertEquals((Object)expectedExceptionMessage, (Object)thrownException.getMessage());
        }
    }

    @Test
    public void testThrowingIfSingleBulkItemIsLargerThanLimit() throws IOException {
        int bulkLimit = 800;
        try (RestElasticSearchClient restClientUnderTest = this.createClient(bulkLimit);){
            StringBuilder payloadBuilder = new StringBuilder();
            IntStream.range(0, bulkLimit * 10).forEach(value -> payloadBuilder.append("a"));
            Assertions.assertThrows(IllegalArgumentException.class, () -> restClientUnderTest.bulkRequest(Collections.singletonList(ElasticSearchMutation.createIndexRequest((String)"some_index", (String)"some_type", (String)"some_doc_id", Collections.singletonMap("someKey", payloadBuilder.toString()))), null), (String)"Should have thrown due to bulk request item being too large");
        }
    }
}

