/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.util.function.Consumer;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.mixed.utils.processor.CircleProcessor;
import org.janusgraph.diskstorage.mixed.utils.processor.FixedErrorDistanceCircleProcessor;

public class TestCircleProcessor
implements CircleProcessor {
    private static Consumer<Geoshape> preProcessConsumer;
    private static Consumer<Geoshape> postProcessConsumer;
    private final CircleProcessor wrappedCircleProcessor;

    public TestCircleProcessor(Configuration config) {
        this.wrappedCircleProcessor = new FixedErrorDistanceCircleProcessor(config);
    }

    public Geoshape process(Geoshape circle) {
        if (preProcessConsumer != null) {
            preProcessConsumer.accept(circle);
        }
        Geoshape transformedGeoshape = this.wrappedCircleProcessor.process(circle);
        if (postProcessConsumer != null) {
            postProcessConsumer.accept(transformedGeoshape);
        }
        return transformedGeoshape;
    }

    public static void setPreProcessConsumer(Consumer<Geoshape> preProcessConsumer) {
        TestCircleProcessor.preProcessConsumer = preProcessConsumer;
    }

    public static void setPostProcessConsumer(Consumer<Geoshape> postProcessConsumer) {
        TestCircleProcessor.postProcessConsumer = postProcessConsumer;
    }
}

