/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.time.Duration;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.diskstorage.es.TestCircleProcessor;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.mixed.utils.MixedIndexUtilsConfigOptions;
import org.janusgraph.graphdb.JanusGraphIndexTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;

public abstract class ElasticsearchJanusGraphIndexTest
extends JanusGraphIndexTest {
    @Container
    protected static JanusGraphElasticsearchContainer esr = new JanusGraphElasticsearchContainer();

    public ElasticsearchJanusGraphIndexTest() {
        super(true, true, true);
    }

    public WriteConfiguration getConfiguration() {
        String[] indexBackends = this.getIndexBackends();
        ModifiableConfiguration config = esr.setConfiguration(this.getStorageConfiguration(), indexBackends);
        for (String indexBackend : indexBackends) {
            config.set(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, (Object)3, new String[]{indexBackend});
        }
        return config.getConfiguration();
    }

    public abstract ModifiableConfiguration getStorageConfiguration();

    @Test
    public void indexShouldExistAfterCreation() throws Exception {
        PropertyKey key = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.buildIndex("verticesByName", Vertex.class).addKey(key).buildMixedIndex("search");
        this.mgmt.commit();
        String expectedIndexName = (String)GraphDatabaseConfiguration.INDEX_NAME.getDefaultValue() + "_" + "verticesByName".toLowerCase();
        Assert.assertTrue((boolean)esr.indexExists(expectedIndexName));
    }

    @Test
    public void indexShouldNotExistAfterDeletion() throws Exception {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.LOG_SEND_DELAY, (String[])new String[]{"janusgraph"}), Duration.ZERO, ElasticsearchJanusGraphIndexTest.option((ConfigOption)KCVSLog.LOG_READ_LAG_TIME, (String[])new String[]{"janusgraph"}), Duration.ofMillis(50L), ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.LOG_READ_INTERVAL, (String[])new String[]{"janusgraph"}), Duration.ofMillis(250L), ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.FORCE_INDEX_USAGE, (String[])new String[0]), true});
        String indexName = "mixed";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, new String[]{propertyName});
        this.enableIndex(indexName);
        this.disableIndex(indexName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        String expectedIndexName = GraphDatabaseConfiguration.INDEX_NAME.getName() + "_" + indexName.toLowerCase();
        Assert.assertFalse((boolean)esr.indexExists(expectedIndexName));
    }

    @Test
    public void writingAnItemLargerThanPermittedChunkLimitFails() {
        PropertyKey key = this.mgmt.makePropertyKey("some-field").dataType(Integer.class).make();
        this.mgmt.buildIndex("bulkTooLargeWriteTestIndex", Vertex.class).addKey(key).buildMixedIndex("search");
        this.mgmt.buildIndex("equalityLookupIndex", Vertex.class).addKey(key).buildCompositeIndex();
        this.mgmt.commit();
        Vertex initiallyWrittenVertex = (Vertex)this.graph.traversal().addV().property((Object)key.name(), (Object)1, new Object[0]).next();
        this.graph.tx().commit();
        Vertex initialVertexEqualityLookup = (Vertex)this.graph.traversal().V(new Object[0]).has(key.name(), P.eq((Object)1)).next();
        Vertex initialVertexRangeLookup = (Vertex)this.graph.traversal().V(new Object[0]).has(key.name(), P.gt((Object)0)).next();
        Assertions.assertEquals((Object)initiallyWrittenVertex.id(), (Object)initialVertexEqualityLookup.id(), (String)"Should have returned the same vertex");
        Assertions.assertEquals((Object)initiallyWrittenVertex.id(), (Object)initialVertexRangeLookup.id(), (String)"Should have returned the same vertex");
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)ElasticSearchIndex.BULK_CHUNK_SIZE_LIMIT_BYTES, (String[])new String[]{"search"}), 1});
        Vertex secondWriteAttemptVertex = (Vertex)this.graph.traversal().addV().property((Object)key.name(), (Object)2, new Object[0]).next();
        this.graph.tx().commit();
        Vertex secondVertexEqualityLookup = (Vertex)this.graph.traversal().V(new Object[0]).has(key.name(), P.eq((Object)2)).next();
        boolean secondVertexRangeLookup = this.graph.traversal().V(new Object[0]).has(key.name(), P.gt((Object)1)).hasNext();
        Assertions.assertEquals((Object)secondWriteAttemptVertex.id(), (Object)secondVertexEqualityLookup.id(), (String)"Should have returned the same vertex");
        Assertions.assertFalse((boolean)secondVertexRangeLookup, (String)"The lookup for the second vertex using the mixed index predicate should have failed to find it due to a silent mutation failure to the mixed index due to the chunk size limit");
    }

    @Test
    @Disabled
    public void manuallyObserveBulkWritingChunking() {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)ElasticSearchIndex.BULK_CHUNK_SIZE_LIMIT_BYTES, (String[])new String[]{"search"}), 100});
        PropertyKey key = this.mgmt.makePropertyKey("some-field").dataType(String.class).make();
        this.mgmt.buildIndex("testChunkingIndex", Vertex.class).addKey(key).buildMixedIndex("search");
        this.mgmt.commit();
        IntStream.range(0, 10).forEach(i -> this.graph.traversal().addV().property((Object)key.name(), (Object)"foobar", new Object[0]).toList());
        this.graph.tx().commit();
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public boolean supportsWildcardQuery() {
        return true;
    }

    protected boolean supportsCollections() {
        return true;
    }

    public boolean supportsGeoPointExistsQuery() {
        return true;
    }

    public boolean supportsGeoShapePrefixTreeMapping() {
        return esr.getEsMajorVersion().getValue() <= 7;
    }

    @Test
    public void testCircleBKDIndexMappingCanBeUsedWithDefaultProcessor() {
        this.clopen(new Object[0]);
        this.createIndexedBKDGeoshape();
        Assertions.assertTrue((boolean)this.addVertexWithCircleValueProperty());
    }

    @Test
    public void testCircleBKDIndexMappingCanBeUsedWithNoChangeProcessor() {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)MixedIndexUtilsConfigOptions.BKD_CIRCLE_PROCESSOR_CLASS, (String[])new String[]{"search"}), "noTransformation"});
        this.createIndexedBKDGeoshape();
        boolean vertexAddedAndFound = this.addVertexWithCircleValueProperty();
        if (esr.getVersion().startsWith("6.0")) {
            Assertions.assertTrue((boolean)vertexAddedAndFound);
        } else {
            Assertions.assertFalse((boolean)vertexAddedAndFound);
        }
    }

    @Test
    public void testCircleBKDIndexMappingCanBeUsedWithFixedProcessor() {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)MixedIndexUtilsConfigOptions.BKD_CIRCLE_PROCESSOR_CLASS, (String[])new String[]{"search"}), "fixedErrorDistance"});
        this.createIndexedBKDGeoshape();
        Assertions.assertTrue((boolean)this.addVertexWithCircleValueProperty());
    }

    @Test
    public void testCircleBKDIndexMappingCanBeUsedWithDynamicProcessor() {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)MixedIndexUtilsConfigOptions.BKD_CIRCLE_PROCESSOR_CLASS, (String[])new String[]{"search"}), "dynamicErrorDistance"});
        this.createIndexedBKDGeoshape();
        Assertions.assertTrue((boolean)this.addVertexWithCircleValueProperty());
    }

    @Test
    public void testCircleBKDIndexMappingCanBeUsedWithCustomProcessor() {
        MutableBoolean preProcessingNormalCircle = new MutableBoolean(false);
        MutableBoolean processedIntoPolygon = new MutableBoolean(false);
        TestCircleProcessor.setPreProcessConsumer(geoshape -> {
            if (Geoshape.Type.CIRCLE.equals((Object)geoshape.getType())) {
                preProcessingNormalCircle.setTrue();
            } else {
                Assertions.fail((String)"Circle had to be used");
            }
        });
        TestCircleProcessor.setPostProcessConsumer(geoshape -> {
            if (Geoshape.Type.POLYGON.equals((Object)geoshape.getType())) {
                processedIntoPolygon.setTrue();
            } else {
                Assertions.fail((String)("Expected Polygon Geoshape after process but got " + geoshape.getType().toString()));
            }
        });
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)MixedIndexUtilsConfigOptions.BKD_CIRCLE_PROCESSOR_CLASS, (String[])new String[]{"search"}), TestCircleProcessor.class.getName()});
        this.createIndexedBKDGeoshape();
        Assertions.assertTrue((boolean)this.addVertexWithCircleValueProperty());
        Assertions.assertTrue((boolean)preProcessingNormalCircle.booleanValue());
        Assertions.assertTrue((boolean)processedIntoPolygon.booleanValue());
    }

    private void createIndexedBKDGeoshape() {
        String indexName = "mixed";
        PropertyKey geoshapeProp = this.mgmt.makePropertyKey("foo").dataType(Geoshape.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(geoshapeProp, new Parameter[]{new Parameter("mapping", (Object)Mapping.BKD)}).buildMixedIndex("search");
        this.finishSchema();
    }

    private boolean addVertexWithCircleValueProperty() {
        Geoshape circle = Geoshape.circle((double)50.0, (double)50.0, (double)50.0);
        Vertex addedVertex = (Vertex)this.graph.traversal().addV().property((Object)"foo", (Object)circle, new Object[0]).next();
        this.graph.tx().commit();
        return this.graph.traversal().V(new Object[0]).has("foo", (P)Geo.geoWithin((Object)Geoshape.box((double)-90.0, (double)-180.0, (double)90.0, (double)180.0))).toList().stream().anyMatch(vertex -> addedVertex.id().equals(vertex.id()) && circle.equals(vertex.value("foo")));
    }
}

