/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.IndicesActivationType;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaInitType;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.schema.json.definition.JsonSchemaDefinition;
import org.janusgraph.core.util.JsonUtil;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.es.CustomTestSchemaInitStrategy;
import org.janusgraph.diskstorage.es.ElasticsearchJanusGraphIndexTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLElasticsearchTest
extends ElasticsearchJanusGraphIndexTest {
    @Container
    private static JanusGraphCassandraContainer cql = new JanusGraphCassandraContainer();

    @Override
    public ModifiableConfiguration getStorageConfiguration() {
        return cql.getConfiguration(CQLElasticsearchTest.class.getName());
    }

    @Disabled(value="CQL seems to not clear storage correctly")
    public void testClearStorage() {
    }

    @Test
    public void testJsonFreshSchemaImport() {
        String jsonFilePath = this.createJsonFileAndReturnPath();
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_UPDATED_ONLY.getConfigName()});
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.ENABLED);
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath});
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.ENABLED);
        String jsonFromDocFilePath = this.createJsonFileAndReturnPath("test_schema_from_doc.json");
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFromDocFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_NON_ENABLED.getConfigName()});
    }

    @Test
    public void testJsonGradualSchemaImport() {
        String jsonFilePath = this.createJsonFileAndReturnPath();
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_NON_ENABLED.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), true});
        this.createData();
        this.assertDataFetch(false, true);
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_UPDATED_ONLY.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), false});
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.ENABLED);
        this.assertDataFetch(true, true);
    }

    @Test
    public void testJsonForceSchemaImport() {
        String jsonFilePath = this.createJsonFileAndReturnPath();
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.FORCE_ENABLE_NON_ENABLED.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), true});
        this.createData();
        this.assertDataFetch(false, true);
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.FORCE_ENABLE_UPDATED_ONLY.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), false});
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.ENABLED);
        this.assertDataFetch(true, false);
    }

    @Test
    public void testJsonSchemaImportSkipIndicesActivation() {
        String jsonFilePath = this.createJsonFileAndReturnPath();
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.FORCE_ENABLE_NON_ENABLED.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), true});
        this.createData();
        this.assertDataFetch(false, true);
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.SKIP_ACTIVATION.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), false});
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.INSTALLED);
        this.assertDataFetch(false, true);
    }

    @Test
    public void testJsonGradualSchemaImportForceClosingOtherInstances() {
        String jsonFilePath = this.createJsonFileAndReturnPath();
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_NON_ENABLED.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (String[])new String[0]), "graph1"});
        this.createData();
        this.assertDataFetch(false, true);
        this.setupConfig(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), SchemaInitType.JSON.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_DROP_BEFORE_INIT, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FILE, (String[])new String[0]), jsonFilePath, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_INDICES_ACTIVATION_TYPE, (String[])new String[0]), IndicesActivationType.REINDEX_AND_ENABLE_UPDATED_ONLY.getConfigName(), CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_ELEMENTS, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_SKIP_INDICES, (String[])new String[0]), false, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_JSON_FORCE_CLOSE_OTHER_INSTANCES, (String[])new String[0]), true, CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (String[])new String[0]), "graph2"});
        StandardJanusGraph prevGraph = this.graph;
        JanusGraphManagement prevMgmt = this.mgmt;
        if (!prevMgmt.isOpen()) {
            prevMgmt = this.graph.openManagement();
        }
        this.open(this.config);
        this.assertSchemaElements();
        this.assertIndices(SchemaStatus.ENABLED);
        this.assertDataFetch(true, true);
        if (prevMgmt.isOpen()) {
            prevMgmt.rollback();
        }
        if (prevGraph.isOpen()) {
            prevGraph.close();
        }
    }

    @Test
    public void testCustomSchemaInitStrategy() {
        Assertions.assertFalse((boolean)CustomTestSchemaInitStrategy.initialized);
        this.clopen(new Object[]{CQLElasticsearchTest.option((ConfigOption)GraphDatabaseConfiguration.SCHEMA_INIT_STRATEGY, (String[])new String[0]), CustomTestSchemaInitStrategy.class.getName()});
        Assertions.assertTrue((boolean)CustomTestSchemaInitStrategy.initialized);
    }

    @Test
    public void testJsonSchemaResourceParseToObject() throws IOException {
        JsonSchemaDefinition jsonSchemaDefinition = (JsonSchemaDefinition)JsonUtil.jsonResourcePathToObject((String)"test_schema_example.json", JsonSchemaDefinition.class);
        Assertions.assertNotNull((Object)jsonSchemaDefinition);
    }

    private void assertDataFetch(boolean indicesUsed, boolean indexedDataShouldBeFound) {
        GraphTraversalSource g = this.graph.traversal();
        try {
            Callable<GraphTraversal> query = () -> g.V(new Object[0]).hasLabel("organization", new String[0]).has("name", (Object)"test_org1");
            Assertions.assertEquals((Object)indicesUsed, (Object)((TraversalMetrics)query.call().profile().next()).toString().contains("index="));
            Assertions.assertEquals((Object)indexedDataShouldBeFound, (Object)query.call().hasNext());
            query = () -> g.V(new Object[0]).hasLabel("organization", new String[0]).has("name", (Object)"test_org2");
            Assertions.assertEquals((Object)indicesUsed, (Object)((TraversalMetrics)query.call().profile().next()).toString().contains("index="));
            Assertions.assertEquals((Object)indexedDataShouldBeFound, (Object)query.call().hasNext());
            query = () -> g.V(new Object[0]).hasLabel("device", new String[0]).has("name", (Object)"test_org3");
            Assertions.assertEquals((Object)indicesUsed, (Object)((TraversalMetrics)query.call().profile().next()).toString().contains("index="));
            Assertions.assertEquals((Object)indexedDataShouldBeFound, (Object)query.call().hasNext());
            if (indexedDataShouldBeFound) {
                Vertex vertex = (Vertex)g.V(new Object[0]).hasLabel("organization", new String[0]).has("name", (Object)"test_org1").next();
                query = () -> g.V(new Object[]{vertex}).properties(new String[]{"longPropCardinalityList"}).has("time", P.lt((Object)300));
                Assertions.assertEquals((Object)indicesUsed, (Object)((TraversalMetrics)query.call().profile().next()).toString().contains("longPropCardinalityListMetaPropertyVertexCentricIndexForTime"));
                Assertions.assertTrue((boolean)query.call().hasNext());
            }
            query = () -> g.E(new Object[0]).hasLabel("connects", new String[0]).has("name", (Object)"connectsEdge1");
            Assertions.assertEquals((Object)indicesUsed, (Object)((TraversalMetrics)query.call().profile().next()).toString().contains("index="));
            Assertions.assertEquals((Object)indexedDataShouldBeFound, (Object)query.call().hasNext());
            query = () -> g.E(new Object[0]).hasLabel("viewed", new String[0]).has("name", (Object)"connectsEdge4");
            Assertions.assertFalse((boolean)((TraversalMetrics)query.call().profile().next()).toString().contains("index="));
            Assertions.assertTrue((boolean)((TraversalMetrics)query.call().profile().next()).toString().contains("fullscan=true"));
            Assertions.assertTrue((boolean)query.call().hasNext());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            g.tx().rollback();
        }
    }

    private void assertSchemaElements() {
        Assertions.assertEquals(Long.class, (Object)this.mgmt.getPropertyKey("time").dataType());
        Assertions.assertEquals(Double.class, (Object)this.mgmt.getPropertyKey("doubleProp").dataType());
        Assertions.assertEquals((Object)Cardinality.LIST, (Object)this.mgmt.getPropertyKey("longPropCardinalityList").cardinality());
        Assertions.assertEquals((Object)"organization", (Object)this.mgmt.getVertexLabel("organization").name());
        Assertions.assertEquals((Object)Multiplicity.SIMPLE, (Object)this.mgmt.getEdgeLabel("connects").multiplicity());
        Assertions.assertTrue((boolean)this.mgmt.getEdgeLabel("connects").isDirected());
        Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)this.mgmt.getEdgeLabel("viewed").multiplicity());
        Assertions.assertTrue((boolean)this.mgmt.getEdgeLabel("viewed").isUnidirected());
    }

    private void assertIndices(SchemaStatus status) {
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("nameCompositeIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("timeForOrganizationsOnlyCompositeIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("connectsOnlyEdgeCompositeIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("uniqueCompositeIndexWithLocking"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("multiKeysCompositeIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getGraphIndex("nameMixedIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType("connects"), "connectsTimeVertexCentricIndex"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType("viewed"), "vertexCentricUnidirectedEdgeIndexWithTwoProps"), (SchemaStatus)status));
        Assertions.assertTrue((boolean)ManagementUtil.isIndexHasStatus((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType("longPropCardinalityList"), "longPropCardinalityListMetaPropertyVertexCentricIndexForTime"), (SchemaStatus)status));
    }

    private String createJsonFileAndReturnPath() {
        return this.createJsonFileAndReturnPath("test_schema_example.json");
    }

    private String createJsonFileAndReturnPath(String resourcePath) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream resourceStream = loader.getResourceAsStream(resourcePath);
            String jsonSchemaExample = IOUtils.toString((InputStream)resourceStream, (Charset)StandardCharsets.UTF_8);
            File file = File.createTempFile("janusgraph", "_" + resourcePath);
            file.deleteOnExit();
            FileUtils.writeStringToFile((File)file, (String)jsonSchemaExample, (Charset)StandardCharsets.UTF_8);
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createData() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex vertex1 = (Vertex)g.addV("organization").property((Object)"time", (Object)12345L, new Object[0]).property((Object)"name", (Object)"test_org1", new Object[0]).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 321L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 213L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 231L}).next();
        Vertex vertex2 = (Vertex)g.addV("organization").property((Object)"time", (Object)54321L, new Object[0]).property((Object)"name", (Object)"test_org2", new Object[0]).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 321L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 213L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 231L}).next();
        Vertex vertex3 = (Vertex)g.addV("device").property((Object)"time", (Object)1L, new Object[0]).property((Object)"name", (Object)"test_org3", new Object[0]).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 321L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 213L}).property((Object)"longPropCardinalityList", (Object)123L, new Object[]{"time", 231L}).next();
        g.addE("connects").from(vertex1).to(vertex2).property((Object)"name", (Object)"connectsEdge1", new Object[0]).property((Object)"time", (Object)123L, new Object[0]).next();
        g.addE("connects").from(vertex1).to(vertex3).property((Object)"name", (Object)"connectsEdge2", new Object[0]).property((Object)"time", (Object)124L, new Object[0]).next();
        g.addE("connects").from(vertex3).to(vertex2).property((Object)"name", (Object)"connectsEdge3", new Object[0]).property((Object)"time", (Object)125L, new Object[0]).next();
        g.addE("viewed").from(vertex2).to(vertex3).property((Object)"name", (Object)"connectsEdge4", new Object[0]).property((Object)"time", (Object)100L, new Object[0]).next();
        g.tx().commit();
    }
}

