/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.janusgraph.diskstorage.es.ElasticSearchMutation;
import org.janusgraph.diskstorage.es.rest.RestBulkResponse;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class RestClientRetryTest {
    @Mock
    private RestClient restClientMock;
    @Mock
    private ResponseException responseException;
    @Mock
    private Response response;
    @Mock
    private StatusLine statusLine;
    @Captor
    private ArgumentCaptor<Request> requestCaptor;

    RestElasticSearchClient createClient(int retryAttemptLimit, Set<Integer> retryErrorCodes) throws IOException {
        Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException()});
        RestElasticSearchClient clientUnderTest = new RestElasticSearchClient(this.restClientMock, 0, false, retryAttemptLimit, retryErrorCodes, 0L, 0L, 100000000);
        Mockito.reset((Object[])new RestClient[]{this.restClientMock});
        return clientUnderTest;
    }

    @Test
    public void testRetryOfIndividuallyFailedBulkItems() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        int retryErrorCode = 429;
        Mockito.when((Object)this.statusLine.getStatusCode()).thenReturn((Object)200);
        RestBulkResponse.RestBulkItemResponse initialRequestFailedItem = new RestBulkResponse.RestBulkItemResponse();
        initialRequestFailedItem.setError((Object)"An Error");
        initialRequestFailedItem.setStatus(retryErrorCode);
        RestBulkResponse initialBulkResponse = new RestBulkResponse();
        initialBulkResponse.setItems(Stream.of(Collections.singletonMap("index", new RestBulkResponse.RestBulkItemResponse()), Collections.singletonMap("index", initialRequestFailedItem), Collections.singletonMap("index", new RestBulkResponse.RestBulkItemResponse())).collect(Collectors.toList()));
        HttpEntity initialHttpEntityMock = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)initialHttpEntityMock.getContent()).thenReturn((Object)new ByteArrayInputStream(mapper.writeValueAsBytes((Object)initialBulkResponse)));
        Response initialResponseMock = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)initialResponseMock.getEntity()).thenReturn((Object)initialHttpEntityMock);
        Mockito.when((Object)initialResponseMock.getStatusLine()).thenReturn((Object)this.statusLine);
        RestBulkResponse retriedBulkResponse = new RestBulkResponse();
        retriedBulkResponse.setItems(Collections.singletonList(Collections.singletonMap("index", new RestBulkResponse.RestBulkItemResponse())));
        HttpEntity retriedHttpEntityMock = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)retriedHttpEntityMock.getContent()).thenReturn((Object)new ByteArrayInputStream(mapper.writeValueAsBytes((Object)retriedBulkResponse)));
        Response retriedResponseMock = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)retriedResponseMock.getEntity()).thenReturn((Object)retriedHttpEntityMock);
        Mockito.when((Object)retriedResponseMock.getStatusLine()).thenReturn((Object)this.statusLine);
        try (RestElasticSearchClient restClientUnderTest = this.createClient(1, Sets.newHashSet((Object[])new Integer[]{retryErrorCode}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenReturn((Object)initialResponseMock).thenReturn((Object)retriedResponseMock);
            restClientUnderTest.bulkRequest(Arrays.asList(ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id1"), ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id2"), ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id3")), null);
            ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)2))).performRequest((Request)this.requestCaptor.capture());
        }
    }

    @Test
    public void testRetryOnConfiguredErrorStatus() throws IOException {
        Integer retryCode = 429;
        int expectedNumberOfRequestAttempts = 2;
        ((StatusLine)Mockito.doReturn((Object)retryCode).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        IOException expectedFinalException = new IOException("Expected");
        try (RestElasticSearchClient restClientUnderTest = this.createClient(expectedNumberOfRequestAttempts - 1, Sets.newHashSet((Object[])new Integer[]{retryCode}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.responseException}).thenThrow(new Throwable[]{expectedFinalException});
            restClientUnderTest.bulkRequest(Collections.singletonList(ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id")), null);
            Assertions.fail((String)"Should have thrown the expected exception after retry");
        }
        catch (Exception actualException) {
            Assertions.assertSame((Object)expectedFinalException, (Object)actualException);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)expectedNumberOfRequestAttempts))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testRetriesExhaustedReturnsLastRetryException() throws IOException {
        Integer retryCode = 429;
        int expectedNumberOfRequestAttempts = 2;
        ((StatusLine)Mockito.doReturn((Object)retryCode).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        ResponseException initialRetryException = (ResponseException)Mockito.mock(ResponseException.class);
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)initialRetryException)).getResponse();
        try (RestElasticSearchClient restClientUnderTest = this.createClient(expectedNumberOfRequestAttempts - 1, Sets.newHashSet((Object[])new Integer[]{retryCode}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{initialRetryException}).thenThrow(new Throwable[]{this.responseException});
            restClientUnderTest.bulkRequest(Collections.singletonList(ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id")), null);
            Assertions.fail((String)"Should have thrown the expected exception after retry");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)this.responseException, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)expectedNumberOfRequestAttempts))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testNonRetryErrorCodeException() throws IOException {
        ((StatusLine)Mockito.doReturn((Object)503).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        try (RestElasticSearchClient restClientUnderTest = this.createClient(0, Sets.newHashSet((Object[])new Integer[]{429}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.responseException});
            restClientUnderTest.bulkRequest(Collections.singletonList(ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id")), null);
            Assertions.fail((String)"Should have thrown the expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)this.responseException, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)1))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testNonResponseExceptionErrorThrown() throws IOException {
        IOException differentExceptionType = new IOException();
        Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{differentExceptionType});
        try (RestElasticSearchClient restClientUnderTest = this.createClient(0, Collections.emptySet());){
            restClientUnderTest.bulkRequest(Collections.singletonList(ElasticSearchMutation.createDeleteRequest((String)"some_index", (String)"some_type", (String)"some_doc_id")), null);
            Assertions.fail((String)"Should have thrown the expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)differentExceptionType, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)1))).performRequest((Request)this.requestCaptor.capture());
    }
}

