/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest.util;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.janusgraph.diskstorage.es.rest.util.BasicAuthHttpClientConfigCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BasicAuthHttpClientConfigCallbackTest {
    private static final String HTTP_USER = "testuser";
    private static final String HTTP_PASSWORD = "testpass";
    private static final String HTTP_REALM = "testrealm";
    @Mock
    private HttpAsyncClientBuilder httpAsyncClientBuilderMock;

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.httpAsyncClientBuilderMock.setDefaultCredentialsProvider((CredentialsProvider)Mockito.any())).thenReturn((Object)this.httpAsyncClientBuilderMock);
    }

    private CredentialsProvider basicAuthTestBase(String realm) {
        BasicAuthHttpClientConfigCallback cb = new BasicAuthHttpClientConfigCallback(realm, HTTP_USER, HTTP_PASSWORD);
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ArgumentCaptor cpCaptor = ArgumentCaptor.forClass(BasicCredentialsProvider.class);
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setDefaultCredentialsProvider((CredentialsProvider)cpCaptor.capture());
        CredentialsProvider cp = (CredentialsProvider)cpCaptor.getValue();
        Assertions.assertNotNull((Object)cp);
        return cp;
    }

    @Test
    public void testSetDefaultCredentialsProviderNoRealm() throws Exception {
        CredentialsProvider cp = this.basicAuthTestBase("");
        Credentials credentialsForRealm1 = cp.getCredentials(new AuthScope("dummyhost1", 1234, "dummyrealm1"));
        Assertions.assertEquals((Object)HTTP_USER, (Object)credentialsForRealm1.getUserPrincipal().getName());
        Assertions.assertEquals((Object)HTTP_PASSWORD, (Object)credentialsForRealm1.getPassword());
    }

    @Test
    public void testSetDefaultCredentialsProviderWithRealm() throws Exception {
        CredentialsProvider cp = this.basicAuthTestBase(HTTP_REALM);
        Credentials credentialsForRealm1 = cp.getCredentials(new AuthScope("dummyhost1", 1234, HTTP_REALM));
        Assertions.assertEquals((Object)HTTP_USER, (Object)credentialsForRealm1.getUserPrincipal().getName());
        Assertions.assertEquals((Object)HTTP_PASSWORD, (Object)credentialsForRealm1.getPassword());
        Credentials credentialsForRealm3 = cp.getCredentials(new AuthScope("dummyhost1", 1234, "Not_testrealm"));
        Assertions.assertNull((Object)credentialsForRealm3);
    }
}

