/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.rest.RestClientSetup;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.janusgraph.diskstorage.es.rest.util.HttpAuthTypes;
import org.janusgraph.diskstorage.es.rest.util.RestClientAuthenticator;
import org.janusgraph.diskstorage.es.rest.util.SSLConfigurationCallback;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class RestClientSetupTest {
    private static final String INDEX_NAME = "junit";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String ES_HOST_01 = "es-host-01";
    private static final String ES_HOST_02 = "es-host-02";
    private static final int ES_PORT = 8080;
    private static final int ES_SCROLL_KA = (Integer)ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE.getDefaultValue() * 2;
    private static final String ES_BULK_REFRESH = String.valueOf(Boolean.valueOf((String)ElasticSearchIndex.BULK_REFRESH.getDefaultValue()) == false);
    private static final Integer RETRY_ON_CONFLICT = (Integer)ElasticSearchIndex.RETRY_ON_CONFLICT.getDefaultValue();
    private static final Integer RETRY_LIMIT = (Integer)ElasticSearchIndex.RETRY_LIMIT.getDefaultValue();
    private static final Long RETRY_INITIAL_WAIT = (Long)ElasticSearchIndex.RETRY_INITIAL_WAIT.getDefaultValue();
    private static final Long RETRY_MAX_WAIT = (Long)ElasticSearchIndex.RETRY_MAX_WAIT.getDefaultValue();
    private static final AtomicInteger instanceCount = new AtomicInteger();
    @Captor
    ArgumentCaptor<HttpHost[]> hostListCaptor;
    @Captor
    ArgumentCaptor<Integer> scrollKACaptor;
    @Captor
    ArgumentCaptor<Integer> retryAttemptLimitCaptor;
    @Captor
    ArgumentCaptor<Long> retryInitialWaitCaptor;
    @Captor
    ArgumentCaptor<Long> retryMaxWaitCaptor;
    @Captor
    ArgumentCaptor<Set<Integer>> retryErrorCodesCaptor;
    @Spy
    private RestClientSetup restClientSetup = new RestClientSetup();
    @Mock
    private RestClient restClientMock;
    @Mock
    private RestElasticSearchClient restElasticSearchClientMock;
    @Mock
    private SSLContext sslContextMock;
    @Mock
    private RestClientBuilder restClientBuilderMock;

    @BeforeEach
    public void setUp() {
        ((RestClientBuilder)Mockito.doReturn((Object)this.restClientMock).when((Object)this.restClientBuilderMock)).build();
    }

    private ElasticSearchClient baseConfigTest(Map<String, String> extraConfigValues) throws Exception {
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc.set("index.junit.backend", (Object)"elasticsearch");
        cc.set("index.junit.elasticsearch.interface", (Object)"REST_CLIENT");
        for (Map.Entry<String, String> me : extraConfigValues.entrySet()) {
            cc.set(me.getKey(), (Object)me.getValue());
        }
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        ((RestClientSetup)Mockito.doReturn((Object)this.restClientBuilderMock).when((Object)this.restClientSetup)).getRestClientBuilder((HttpHost[])Mockito.any());
        ((RestClientSetup)Mockito.doReturn((Object)this.restElasticSearchClientMock).when((Object)this.restClientSetup)).getElasticSearchClient((RestClient)Mockito.any(RestClient.class), Mockito.anyInt(), Mockito.anyBoolean(), Mockito.anyInt(), ArgumentMatchers.anySet(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        return this.restClientSetup.connect(config.restrictTo(new String[]{INDEX_NAME}));
    }

    private List<HttpHost[]> baseHostsConfigTest(Map<String, String> extraConfigValues) throws Exception {
        ElasticSearchClient elasticClient = this.baseConfigTest((Map<String, String>)ImmutableMap.builder().putAll(extraConfigValues).build());
        Assertions.assertSame((Object)this.restElasticSearchClientMock, (Object)elasticClient);
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getRestClient((HttpHost[])this.hostListCaptor.capture(), (Configuration)Mockito.any(Configuration.class));
        return this.hostListCaptor.getAllValues();
    }

    @Test
    public void testConnectBasicHttpConfigurationSingleHost() throws Exception {
        List<HttpHost[]> hostsConfigured = this.baseHostsConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.hostname", (Object)ES_HOST_01).build());
        Assertions.assertNotNull(hostsConfigured);
        Assertions.assertEquals((int)1, (int)hostsConfigured.size());
        HttpHost host0 = hostsConfigured.get(0)[0];
        Assertions.assertEquals((Object)ES_HOST_01, (Object)host0.getHostName());
        Assertions.assertEquals((Object)SCHEME_HTTP, (Object)host0.getSchemeName());
        Assertions.assertEquals((int)9200, (int)host0.getPort());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getElasticSearchClient((RestClient)Mockito.same((Object)this.restClientMock), ((Integer)this.scrollKACaptor.capture()).intValue(), Mockito.anyBoolean(), Mockito.anyInt(), ArgumentMatchers.anySet(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Assertions.assertEquals((int)((Integer)ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE.getDefaultValue()), (int)((Integer)this.scrollKACaptor.getValue()));
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock, (VerificationMode)Mockito.never())).setBulkRefresh(Mockito.anyString());
    }

    @Test
    public void testConnectBasicHttpConfigurationMultiHost() throws Exception {
        List<HttpHost[]> hostsConfigured = this.baseHostsConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.hostname", (Object)"es-host-01,es-host-02").build());
        Assertions.assertNotNull(hostsConfigured);
        Assertions.assertEquals((int)1, (int)hostsConfigured.size());
        HttpHost host0 = hostsConfigured.get(0)[0];
        Assertions.assertEquals((Object)ES_HOST_01, (Object)host0.getHostName());
        Assertions.assertEquals((Object)SCHEME_HTTP, (Object)host0.getSchemeName());
        Assertions.assertEquals((int)9200, (int)host0.getPort());
        HttpHost host1 = hostsConfigured.get(0)[1];
        Assertions.assertEquals((Object)ES_HOST_02, (Object)host1.getHostName());
        Assertions.assertEquals((Object)SCHEME_HTTP, (Object)host1.getSchemeName());
        Assertions.assertEquals((int)9200, (int)host1.getPort());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getElasticSearchClient((RestClient)Mockito.same((Object)this.restClientMock), ((Integer)this.scrollKACaptor.capture()).intValue(), Mockito.anyBoolean(), ((Integer)this.retryAttemptLimitCaptor.capture()).intValue(), (Set)this.retryErrorCodesCaptor.capture(), ((Long)this.retryInitialWaitCaptor.capture()).longValue(), ((Long)this.retryMaxWaitCaptor.capture()).longValue());
        Assertions.assertEquals((int)((Integer)ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE.getDefaultValue()), (int)((Integer)this.scrollKACaptor.getValue()));
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock, (VerificationMode)Mockito.never())).setBulkRefresh(Mockito.anyString());
    }

    @Test
    public void testConnectBasicHttpConfigurationAllOptions() throws Exception {
        List<HttpHost[]> hostsConfigured = this.baseHostsConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.hostname", (Object)ES_HOST_01).put((Object)"index.junit.port", (Object)String.valueOf(8080)).put((Object)"index.junit.elasticsearch.scroll-keep-alive", (Object)String.valueOf(ES_SCROLL_KA)).put((Object)"index.junit.elasticsearch.bulk-refresh", (Object)ES_BULK_REFRESH).put((Object)"index.junit.elasticsearch.retry_on_conflict", (Object)String.valueOf(RETRY_ON_CONFLICT)).put((Object)"index.junit.elasticsearch.retry-limit", (Object)String.valueOf(RETRY_LIMIT)).put((Object)"index.junit.elasticsearch.retry-initial-wait", (Object)String.valueOf(RETRY_INITIAL_WAIT)).put((Object)"index.junit.elasticsearch.retry-max-wait", (Object)String.valueOf(RETRY_MAX_WAIT)).put((Object)"index.junit.elasticsearch.retry-error-codes", (Object)"408,429").build());
        Assertions.assertNotNull(hostsConfigured);
        Assertions.assertEquals((int)1, (int)hostsConfigured.size());
        HttpHost host0 = hostsConfigured.get(0)[0];
        Assertions.assertEquals((Object)ES_HOST_01, (Object)host0.getHostName());
        Assertions.assertEquals((Object)SCHEME_HTTP, (Object)host0.getSchemeName());
        Assertions.assertEquals((int)8080, (int)host0.getPort());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getElasticSearchClient((RestClient)Mockito.same((Object)this.restClientMock), ((Integer)this.scrollKACaptor.capture()).intValue(), Mockito.anyBoolean(), ((Integer)this.retryAttemptLimitCaptor.capture()).intValue(), (Set)this.retryErrorCodesCaptor.capture(), ((Long)this.retryInitialWaitCaptor.capture()).longValue(), ((Long)this.retryMaxWaitCaptor.capture()).longValue());
        Assertions.assertEquals((int)ES_SCROLL_KA, (int)((Integer)this.scrollKACaptor.getValue()));
        Assertions.assertEquals((Integer)RETRY_LIMIT, (int)((Integer)this.retryAttemptLimitCaptor.getValue()));
        Assertions.assertEquals(Stream.of(408, 429).collect(Collectors.toSet()), (Object)this.retryErrorCodesCaptor.getValue());
        Assertions.assertEquals((Long)RETRY_INITIAL_WAIT, (long)((Long)this.retryInitialWaitCaptor.getValue()));
        Assertions.assertEquals((Long)RETRY_MAX_WAIT, (long)((Long)this.retryMaxWaitCaptor.getValue()));
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock)).setBulkRefresh((String)Mockito.eq((Object)ES_BULK_REFRESH));
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock)).setRetryOnConflict((Integer)Mockito.eq((Object)RETRY_ON_CONFLICT));
    }

    @Test
    public void testConnectBasicHttpsConfigurationSingleHost() throws Exception {
        List<HttpHost[]> hostsConfigured = this.baseHostsConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.hostname", (Object)ES_HOST_01).put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").build());
        Assertions.assertNotNull(hostsConfigured);
        Assertions.assertEquals((int)1, (int)hostsConfigured.size());
        HttpHost host0 = hostsConfigured.get(0)[0];
        Assertions.assertEquals((Object)ES_HOST_01, (Object)host0.getHostName());
        Assertions.assertEquals((Object)SCHEME_HTTPS, (Object)host0.getSchemeName());
        Assertions.assertEquals((int)9200, (int)host0.getPort());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getElasticSearchClient((RestClient)Mockito.same((Object)this.restClientMock), ((Integer)this.scrollKACaptor.capture()).intValue(), Mockito.anyBoolean(), Mockito.anyInt(), ArgumentMatchers.anySet(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        Assertions.assertEquals((int)((Integer)ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE.getDefaultValue()), (int)((Integer)this.scrollKACaptor.getValue()));
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock, (VerificationMode)Mockito.never())).setBulkRefresh(Mockito.anyString());
        ((RestElasticSearchClient)Mockito.verify((Object)this.restElasticSearchClientMock, (VerificationMode)Mockito.times((int)1))).setRetryOnConflict(null);
    }

    private RestClientBuilder.HttpClientConfigCallback authTestBase(Map<String, String> extraConfigValues) throws Exception {
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.backend", (Object)"elasticsearch").put((Object)"index.junit.hostname", (Object)ES_HOST_01).putAll(extraConfigValues).build());
        ArgumentCaptor hcccCaptor = ArgumentCaptor.forClass(RestClientBuilder.HttpClientConfigCallback.class);
        ((RestClientBuilder)Mockito.verify((Object)this.restClientBuilderMock)).setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)hcccCaptor.capture());
        RestClientBuilder.HttpClientConfigCallback hccc = (RestClientBuilder.HttpClientConfigCallback)hcccCaptor.getValue();
        Assertions.assertNotNull((Object)hccc);
        return hccc;
    }

    private RestClientBuilder.RequestConfigCallback configCallbackTestBase(Map<String, String> extraConfigValues) throws Exception {
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.backend", (Object)"elasticsearch").put((Object)"index.junit.hostname", (Object)ES_HOST_01).putAll(extraConfigValues).build());
        ArgumentCaptor rccCaptor = ArgumentCaptor.forClass(RestClientBuilder.RequestConfigCallback.class);
        ((RestClientBuilder)Mockito.verify((Object)this.restClientBuilderMock)).setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)rccCaptor.capture());
        RestClientBuilder.RequestConfigCallback rcc = (RestClientBuilder.RequestConfigCallback)rccCaptor.getValue();
        Assertions.assertNotNull((Object)rcc);
        return rcc;
    }

    private CredentialsProvider basicAuthTestBase(Map<String, String> extraConfigValues, String realm, String username, String password) throws Exception {
        RestClientBuilder.HttpClientConfigCallback hccc = this.authTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.interface", (Object)"REST_CLIENT").put((Object)"index.junit.elasticsearch.http.auth.type", (Object)HttpAuthTypes.BASIC.toString()).put((Object)"index.junit.elasticsearch.http.auth.basic.username", (Object)username).put((Object)"index.junit.elasticsearch.http.auth.basic.password", (Object)password).put((Object)"index.junit.elasticsearch.http.auth.basic.realm", (Object)realm).putAll(extraConfigValues).build());
        HttpAsyncClientBuilder hacb = (HttpAsyncClientBuilder)Mockito.mock(HttpAsyncClientBuilder.class);
        ((HttpAsyncClientBuilder)Mockito.doReturn((Object)hacb).when((Object)hacb)).setDefaultCredentialsProvider((CredentialsProvider)Mockito.any());
        hccc.customizeHttpClient(hacb);
        ArgumentCaptor cpCaptor = ArgumentCaptor.forClass(BasicCredentialsProvider.class);
        ((HttpAsyncClientBuilder)Mockito.verify((Object)hacb)).setDefaultCredentialsProvider((CredentialsProvider)cpCaptor.capture());
        CredentialsProvider cp = (CredentialsProvider)cpCaptor.getValue();
        Assertions.assertNotNull((Object)cp);
        return cp;
    }

    @Test
    public void testHttpBasicAuthConfiguration() throws Exception {
        String testRealm = "testRealm";
        String testUser = "testUser";
        String testPassword = "testPassword";
        CredentialsProvider cp = this.basicAuthTestBase((Map<String, String>)ImmutableMap.builder().build(), "testRealm", "testUser", "testPassword");
        Credentials credentials = cp.getCredentials(new AuthScope(AuthScope.ANY_HOST, -1, "testRealm"));
        Assertions.assertNotNull((Object)credentials);
        Assertions.assertEquals((Object)"testUser", (Object)credentials.getUserPrincipal().getName());
        Assertions.assertEquals((Object)"testPassword", (Object)credentials.getPassword());
    }

    @Test
    public void testConnectAndSocketTimeout() throws Exception {
        RestClientBuilder.RequestConfigCallback rcc = this.configCallbackTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.connect-timeout", (Object)"5000").put((Object)"index.junit.elasticsearch.socket-timeout", (Object)"60000").build());
        RequestConfig.Builder rccb = (RequestConfig.Builder)Mockito.mock(RequestConfig.Builder.class);
        Mockito.when((Object)rccb.setConnectTimeout(((Integer)Mockito.any(Integer.class)).intValue())).thenReturn((Object)rccb);
        ArgumentCaptor connectArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        ArgumentCaptor socketArgumentCaptor = ArgumentCaptor.forClass(Integer.class);
        rcc.customizeRequestConfig(rccb);
        ((RequestConfig.Builder)Mockito.verify((Object)rccb)).setConnectTimeout(((Integer)connectArgumentCaptor.capture()).intValue());
        ((RequestConfig.Builder)Mockito.verify((Object)rccb)).setSocketTimeout(((Integer)socketArgumentCaptor.capture()).intValue());
        Assertions.assertEquals((int)5000, (Integer)((Integer)connectArgumentCaptor.getValue()));
        Assertions.assertEquals((int)60000, (Integer)((Integer)socketArgumentCaptor.getValue()));
    }

    @Test
    public void testCustomAuthenticator() throws Exception {
        String uniqueInstanceKey = String.valueOf(instanceCount.getAndIncrement());
        Object[] customAuthArgs = new String[]{uniqueInstanceKey, "arg1", "arg2"};
        String serializedArgList = StringUtils.join((Object[])customAuthArgs, (char)',');
        RestClientBuilder.HttpClientConfigCallback hccc = this.authTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.interface", (Object)"REST_CLIENT").put((Object)"index.junit.elasticsearch.http.auth.type", (Object)HttpAuthTypes.CUSTOM.toString()).put((Object)"index.junit.elasticsearch.http.auth.custom.authenticator-class", (Object)TestCustomAuthenticator.class.getName()).put((Object)"index.junit.elasticsearch.http.auth.custom.authenticator-args", (Object)serializedArgList).build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getCustomAuthenticator((String)Mockito.eq((Object)TestCustomAuthenticator.class.getName()), (String[])Mockito.eq((Object)customAuthArgs));
        TestCustomAuthenticator customAuth = (TestCustomAuthenticator)TestCustomAuthenticator.instanceMap.get(uniqueInstanceKey);
        Assertions.assertNotNull((Object)customAuth);
        Assertions.assertEquals((int)1, (int)customAuth.numInitCalls);
        HttpAsyncClientBuilder hacb = (HttpAsyncClientBuilder)Mockito.mock(HttpAsyncClientBuilder.class);
        hccc.customizeHttpClient(hacb);
        Assertions.assertEquals((int)1, (int)customAuth.customizeHttpClientHistory.size());
        Assertions.assertSame((Object)hacb, customAuth.customizeHttpClientHistory.get(0));
        Assertions.assertArrayEquals((Object[])customAuthArgs, (Object[])customAuth.args);
    }

    public SSLConfigurationCallback.Builder sslSettingsTestBase(Map<String, String> extraConfigValues) throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = (SSLConfigurationCallback.Builder)Mockito.mock(SSLConfigurationCallback.Builder.class);
        ((RestClientSetup)Mockito.doReturn((Object)sslConfBuilderMock).when((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        this.authTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.interface", (Object)"REST_CLIENT").put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").putAll(extraConfigValues).build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        return sslConfBuilderMock;
    }

    @Test
    public void testSSLTrustStoreSettingsOnly() throws Exception {
        String trustStoreFile = "/a/b/c/truststore.jks";
        String trustStorePassword = "averysecretpassword";
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.truststore.location", (Object)"/a/b/c/truststore.jks").put((Object)"index.junit.elasticsearch.ssl.truststore.password", (Object)"averysecretpassword").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withTrustStore((String)Mockito.eq((Object)"/a/b/c/truststore.jks"), (String)Mockito.eq((Object)"averysecretpassword"));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLKeyStoreSettingsOnly() throws Exception {
        String keyStoreFile = "/a/b/c/keystore.jks";
        String keyStorePassword = "key_store_password";
        String keyPassword = "key_password";
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.keystore.location", (Object)"/a/b/c/keystore.jks").put((Object)"index.junit.elasticsearch.ssl.keystore.storepassword", (Object)"key_store_password").put((Object)"index.junit.elasticsearch.ssl.keystore.keypassword", (Object)"key_password").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withKeyStore((String)Mockito.eq((Object)"/a/b/c/keystore.jks"), (String)Mockito.eq((Object)"key_store_password"), (String)Mockito.eq((Object)"key_password"));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLKeyStoreSettingsOnlyEmptyKeyPass() throws Exception {
        String keyStoreFile = "/a/b/c/keystore.jks";
        String keyStorePassword = "key_store_password";
        String keyPassword = "";
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.keystore.location", (Object)"/a/b/c/keystore.jks").put((Object)"index.junit.elasticsearch.ssl.keystore.storepassword", (Object)"key_store_password").put((Object)"index.junit.elasticsearch.ssl.keystore.keypassword", (Object)"").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withKeyStore((String)Mockito.eq((Object)"/a/b/c/keystore.jks"), (String)Mockito.eq((Object)"key_store_password"), (String)Mockito.eq((Object)""));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLKeyStoreSettingsOnlyNoKeyPass() throws Exception {
        String keyStoreFile = "/a/b/c/keystore.jks";
        String keyStorePassword = "key_store_password";
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.keystore.location", (Object)"/a/b/c/keystore.jks").put((Object)"index.junit.elasticsearch.ssl.keystore.storepassword", (Object)"key_store_password").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withKeyStore((String)Mockito.eq((Object)"/a/b/c/keystore.jks"), (String)Mockito.eq((Object)"key_store_password"), (String)Mockito.eq((Object)"key_store_password"));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLKeyAndTrustStoreSettingsOnly() throws Exception {
        String trustStoreFile = "/a/b/c/truststore.jks";
        String trustStorePassword = "averysecretpassword";
        String keyStoreFile = "/a/b/c/keystore.jks";
        String keyStorePassword = "key_store_password";
        String keyPassword = "key_password";
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.truststore.location", (Object)"/a/b/c/truststore.jks").put((Object)"index.junit.elasticsearch.ssl.truststore.password", (Object)"averysecretpassword").put((Object)"index.junit.elasticsearch.ssl.keystore.location", (Object)"/a/b/c/keystore.jks").put((Object)"index.junit.elasticsearch.ssl.keystore.storepassword", (Object)"key_store_password").put((Object)"index.junit.elasticsearch.ssl.keystore.keypassword", (Object)"key_password").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withTrustStore((String)Mockito.eq((Object)"/a/b/c/truststore.jks"), (String)Mockito.eq((Object)"averysecretpassword"));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).withKeyStore((String)Mockito.eq((Object)"/a/b/c/keystore.jks"), (String)Mockito.eq((Object)"key_store_password"), (String)Mockito.eq((Object)"key_password"));
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLDisableHostNameVerifier() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.disable-hostname-verification", (Object)"true").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).disableHostNameVerification();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLDisableHostNameVerifierExplicitOff() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = (SSLConfigurationCallback.Builder)Mockito.mock(SSLConfigurationCallback.Builder.class);
        ((RestClientSetup)Mockito.doReturn((Object)sslConfBuilderMock).when((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").put((Object)"index.junit.elasticsearch.ssl.disable-hostname-verification", (Object)"false").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock, (VerificationMode)Mockito.never())).disableHostNameVerification();
    }

    @Test
    public void testSSLDisableHostNameVerifierDefaultOff() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = (SSLConfigurationCallback.Builder)Mockito.mock(SSLConfigurationCallback.Builder.class);
        ((RestClientSetup)Mockito.doReturn((Object)sslConfBuilderMock).when((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock, (VerificationMode)Mockito.never())).disableHostNameVerification();
    }

    @Test
    public void testSSLAllowSelfSignedCerts() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = this.sslSettingsTestBase((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.allow-self-signed-certificates", (Object)"true").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).allowSelfSignedCertificates();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sslConfBuilderMock});
    }

    @Test
    public void testSSLAllowSelfSignedCertsExplicitOff() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = (SSLConfigurationCallback.Builder)Mockito.mock(SSLConfigurationCallback.Builder.class);
        ((RestClientSetup)Mockito.doReturn((Object)sslConfBuilderMock).when((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").put((Object)"index.junit.elasticsearch.ssl.allow-self-signed-certificates", (Object)"false").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock, (VerificationMode)Mockito.never())).allowSelfSignedCertificates();
    }

    @Test
    public void testSSLAllowSelfSignedCertsDefaultOff() throws Exception {
        SSLConfigurationCallback.Builder sslConfBuilderMock = (SSLConfigurationCallback.Builder)Mockito.mock(SSLConfigurationCallback.Builder.class);
        ((RestClientSetup)Mockito.doReturn((Object)sslConfBuilderMock).when((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        this.baseConfigTest((Map<String, String>)ImmutableMap.builder().put((Object)"index.junit.elasticsearch.ssl.enabled", (Object)"true").build());
        ((RestClientSetup)Mockito.verify((Object)this.restClientSetup)).getSSLConfigurationCallbackBuilder();
        ((SSLConfigurationCallback.Builder)Mockito.verify((Object)sslConfBuilderMock, (VerificationMode)Mockito.never())).allowSelfSignedCertificates();
    }

    public static class TestCustomAuthenticator
    implements RestClientAuthenticator {
        private static final Map<String, TestCustomAuthenticator> instanceMap = new HashMap<String, TestCustomAuthenticator>();
        private final String[] args;
        private final List<RequestConfig.Builder> customizeRequestConfigHistory = new LinkedList<RequestConfig.Builder>();
        private final List<HttpAsyncClientBuilder> customizeHttpClientHistory = new LinkedList<HttpAsyncClientBuilder>();
        private int numInitCalls = 0;

        public TestCustomAuthenticator(String[] args) {
            this.args = args;
            Preconditions.checkArgument((instanceMap.put(args[0], this) == null ? 1 : 0) != 0, (Object)"Non-unique key used");
        }

        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            this.customizeHttpClientHistory.add(httpClientBuilder);
            return httpClientBuilder;
        }

        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
            this.customizeRequestConfigHistory.add(requestConfigBuilder);
            return requestConfigBuilder;
        }

        public void init() throws IOException {
            ++this.numInitCalls;
        }
    }
}

