/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.http.StatusLine;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class RestClientRetryTest {
    @Mock
    private RestClient restClientMock;
    @Mock
    private ResponseException responseException;
    @Mock
    private Response response;
    @Mock
    private StatusLine statusLine;
    @Captor
    private ArgumentCaptor<Request> requestCaptor;

    RestElasticSearchClient createClient(int retryAttemptLimit, Set<Integer> retryErrorCodes) throws IOException {
        Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{new IOException()});
        RestElasticSearchClient clientUnderTest = new RestElasticSearchClient(this.restClientMock, 0, false, retryAttemptLimit, retryErrorCodes, 0L, 0L);
        Mockito.reset((Object[])new RestClient[]{this.restClientMock});
        return clientUnderTest;
    }

    @Test
    public void testRetryOnConfiguredErrorStatus() throws IOException {
        Integer retryCode = 429;
        int expectedNumberOfRequestAttempts = 2;
        ((StatusLine)Mockito.doReturn((Object)retryCode).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        IOException expectedFinalException = new IOException("Expected");
        try (RestElasticSearchClient restClientUnderTest = this.createClient(expectedNumberOfRequestAttempts - 1, Sets.newHashSet((Object[])new Integer[]{retryCode}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.responseException}).thenThrow(new Throwable[]{expectedFinalException});
            restClientUnderTest.bulkRequest(Collections.emptyList(), null);
            Assertions.fail((String)"Should have thrown the expected exception after retry");
        }
        catch (Exception actualException) {
            Assertions.assertSame((Object)expectedFinalException, (Object)actualException);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)expectedNumberOfRequestAttempts))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testRetriesExhaustedReturnsLastRetryException() throws IOException {
        Integer retryCode = 429;
        int expectedNumberOfRequestAttempts = 2;
        ((StatusLine)Mockito.doReturn((Object)retryCode).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        ResponseException initialRetryException = (ResponseException)Mockito.mock(ResponseException.class);
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)initialRetryException)).getResponse();
        try (RestElasticSearchClient restClientUnderTest = this.createClient(expectedNumberOfRequestAttempts - 1, Sets.newHashSet((Object[])new Integer[]{retryCode}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{initialRetryException}).thenThrow(new Throwable[]{this.responseException});
            restClientUnderTest.bulkRequest(Collections.emptyList(), null);
            Assertions.fail((String)"Should have thrown the expected exception after retry");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)this.responseException, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)expectedNumberOfRequestAttempts))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testNonRetryErrorCodeException() throws IOException {
        ((StatusLine)Mockito.doReturn((Object)503).when((Object)this.statusLine)).getStatusCode();
        ((Response)Mockito.doReturn((Object)this.statusLine).when((Object)this.response)).getStatusLine();
        ((ResponseException)Mockito.doReturn((Object)this.response).when((Object)this.responseException)).getResponse();
        try (RestElasticSearchClient restClientUnderTest = this.createClient(0, Sets.newHashSet((Object[])new Integer[]{429}));){
            Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{this.responseException});
            restClientUnderTest.bulkRequest(Collections.emptyList(), null);
            Assertions.fail((String)"Should have thrown the expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)this.responseException, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)1))).performRequest((Request)this.requestCaptor.capture());
    }

    @Test
    public void testNonResponseExceptionErrorThrown() throws IOException {
        IOException differentExceptionType = new IOException();
        Mockito.when((Object)this.restClientMock.performRequest((Request)ArgumentMatchers.any())).thenThrow(new Throwable[]{differentExceptionType});
        try (RestElasticSearchClient restClientUnderTest = this.createClient(0, Collections.emptySet());){
            restClientUnderTest.bulkRequest(Collections.emptyList(), null);
            Assertions.fail((String)"Should have thrown the expected exception");
        }
        catch (Exception e) {
            Assertions.assertSame((Object)differentExceptionType, (Object)e);
        }
        ((RestClient)Mockito.verify((Object)this.restClientMock, (VerificationMode)Mockito.times((int)1))).performRequest((Request)this.requestCaptor.capture());
    }
}

