/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.es;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.AbstractConfiguredGraphFactoryTest;
import org.janusgraph.core.ConfiguredGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.converter.ReadConfigurationConverter;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.util.system.ConfigurationUtil;
import org.janusgraph.util.system.IOUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class ElasticsearchConfiguredGraphFactoryTest
extends AbstractConfiguredGraphFactoryTest {
    private String indexBackendName = "search";
    @Container
    public static final JanusGraphElasticsearchContainer esContainer = new JanusGraphElasticsearchContainer();

    protected MapConfiguration getManagementConfig() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]);
        WriteConfiguration writeConf = esContainer.setConfiguration(config, this.indexBackendName).getConfiguration();
        return ReadConfigurationConverter.getInstance().convertToMapConfiguration((ReadConfiguration)writeConf);
    }

    protected MapConfiguration getTemplateConfig() {
        return this.getManagementConfig();
    }

    protected MapConfiguration getGraphConfig() {
        Map map = this.getTemplateConfig().getMap();
        map.put(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot(), "graph1");
        return ConfigurationUtil.loadMapConfiguration((Map)map);
    }

    private boolean indexExists(String name) throws IOException {
        HttpHost host;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute(host = new HttpHost(InetAddress.getByName(esContainer.getHostname()), esContainer.getPort().intValue()), (HttpRequest)new HttpHead(name));
        boolean exists = response.getStatusLine().getStatusCode() == 200;
        IOUtils.closeQuietly((Closeable)response);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexNameShouldContainGraphName() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assert.assertNotNull((Object)graph);
            String graphIndexName = "verticesByName";
            JanusGraphManagement mgmt = graph.openManagement();
            PropertyKey key = mgmt.makePropertyKey("name").dataType(String.class).make();
            mgmt.buildIndex(graphIndexName, Vertex.class).addKey(key).buildMixedIndex(this.indexBackendName);
            mgmt.commit();
            String expectedIndexName = graphName + "_" + graphIndexName.toLowerCase();
            Assert.assertTrue((boolean)this.indexExists(expectedIndexName));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }
}

