/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.ElasticSearchSetup;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.IOUtils;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class JanusGraphElasticsearchContainer
extends ElasticsearchContainer {
    private static final Integer ELASTIC_PORT = 9200;
    private static final String DEFAULT_VERSION = "8.10.4";
    private static final String DEFAULT_IMAGE = "docker.elastic.co/elasticsearch/elasticsearch";

    public static ElasticMajorVersion getEsMajorVersion() {
        return ElasticMajorVersion.parse((String)JanusGraphElasticsearchContainer.getVersion());
    }

    public static String getVersion() {
        String property = System.getProperty("elasticsearch.docker.version");
        if (property != null) {
            return property;
        }
        return DEFAULT_VERSION;
    }

    private static String getElasticImage() {
        String property = System.getProperty("elasticsearch.docker.image");
        if (property != null) {
            return property;
        }
        return DEFAULT_IMAGE;
    }

    public JanusGraphElasticsearchContainer() {
        this(false);
    }

    public JanusGraphElasticsearchContainer(boolean bindDefaultPort) {
        super(JanusGraphElasticsearchContainer.getElasticImage() + ":" + JanusGraphElasticsearchContainer.getVersion());
        this.withEnv("transport.host", "0.0.0.0");
        this.withEnv("xpack.security.enabled", "false");
        this.withEnv("action.destructive_requires_name", "false");
        if (JanusGraphElasticsearchContainer.getEsMajorVersion().value > 6) {
            this.withEnv("ingest.geoip.downloader.enabled", "false");
        }
        this.withEnv("ES_JAVA_OPTS", "-Xms512m -Xmx512m");
        if (JanusGraphElasticsearchContainer.getEsMajorVersion().value == 5) {
            this.withEnv("script.max_compilations_per_minute", "30");
        }
        if (bindDefaultPort) {
            this.addFixedExposedPort(ELASTIC_PORT, ELASTIC_PORT);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.createDefaultIndexTemplate();
    }

    private void createDefaultIndexTemplate() {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPut request = new HttpPut("_template/default");
            request.addHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)new StringEntity("{\"index_patterns\":[\"*\"],\"settings\":{\"number_of_shards\":1,\"number_of_replicas\":0}}"));
            client.execute(new HttpHost(this.getHostname(), this.getPort().intValue()), (HttpRequest)request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getHostname() {
        return this.getContainerIpAddress();
    }

    public Integer getPort() {
        return this.getMappedPort(ELASTIC_PORT);
    }

    public ModifiableConfiguration setConfiguration(ModifiableConfiguration config, String ... indexBackends) {
        for (String indexBackend : indexBackends) {
            config.set(ElasticSearchIndex.INTERFACE, (Object)ElasticSearchSetup.REST_CLIENT.toString(), new String[]{indexBackend});
            config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{this.getHostname()}, new String[]{indexBackend});
            config.set(GraphDatabaseConfiguration.INDEX_PORT, (Object)this.getPort(), new String[]{indexBackend});
            config.set(ElasticSearchIndex.BULK_REFRESH, (Object)"wait_for", new String[]{indexBackend});
        }
        return config;
    }

    public boolean indexExists(String name) throws IOException {
        HttpHost host;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute(host = new HttpHost(InetAddress.getByName(this.getHostname()), this.getPort().intValue()), (HttpRequest)new HttpHead(name));
        boolean exists = response.getStatusLine().getStatusCode() == 200;
        IOUtils.closeQuietly((Closeable)response);
        return exists;
    }
}

