/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.ElasticSearchSetup;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.diskstorage.es.mapping.IndexMapping;
import org.janusgraph.diskstorage.es.mapping.TypedIndexMappings;
import org.janusgraph.diskstorage.es.mapping.TypelessIndexMappings;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexProviderTest;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class ElasticsearchConfigTest {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchConfigTest.class);
    @Container
    public static JanusGraphElasticsearchContainer esr = new JanusGraphElasticsearchContainer();
    private static final String INDEX_NAME = "escfg";
    private static final String ANALYZER_KEYWORD = "keyword";
    private static final String ANALYZER_ENGLISH = "english";
    private static final String ANALYZER_STANDARD = "standard";
    private HttpHost host;
    private CloseableHttpClient httpClient;
    private ObjectMapper objectMapper;

    public static Stream<Boolean> useMappingsForES7Configuration() {
        return Stream.of(true, false);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.httpClient = HttpClients.createDefault();
        this.host = new HttpHost(InetAddress.getByName(esr.getHostname()), esr.getPort().intValue());
        this.objectMapper = new ObjectMapper();
        IOUtils.closeQuietly((Closeable)this.httpClient.execute(this.host, (HttpRequest)new HttpDelete("_template/template_1")));
    }

    @AfterEach
    public void teardown() throws Exception {
        IOUtils.closeQuietly((Closeable)this.httpClient.execute(this.host, (HttpRequest)new HttpDelete("janusgraph*")));
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    @Test
    public void testJanusGraphFactoryBuilder() {
        JanusGraphFactory.Builder builder = JanusGraphFactory.build();
        builder.set("storage.backend", (Object)"inmemory");
        builder.set("index.escfg.hostname", (Object)(esr.getHostname() + ":" + esr.getPort()));
        JanusGraph graph = builder.open();
        Assertions.assertTrue((boolean)graph.isOpen());
        graph.close();
    }

    @Test
    public void testClientThrowsExceptionIfServerNotReachable() throws BackendException, InterruptedException {
        ModifiableConfiguration config = esr.setConfiguration(GraphDatabaseConfiguration.buildGraphConfiguration(), INDEX_NAME);
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        IndexProvider idx = this.open(indexConfig);
        this.simpleWriteAndQuery(idx);
        idx.close();
        config.set(GraphDatabaseConfiguration.INDEX_HOSTS, (Object)new String[]{"localhost:" + esr.getPort() + 1}, new String[]{INDEX_NAME});
        Configuration wrongHostConfig = config.restrictTo(new String[]{INDEX_NAME});
        Assertions.assertThrows(Exception.class, () -> new ElasticSearchIndex(wrongHostConfig));
    }

    @ParameterizedTest
    @MethodSource(value={"useMappingsForES7Configuration"})
    public void testIndexCreationOptions(Boolean useMappingsForES7) throws InterruptedException, BackendException, IOException {
        int shards = 7;
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc.set("index.escfg.elasticsearch.create.ext.number_of_shards", (Object)String.valueOf(7));
        if (useMappingsForES7.booleanValue()) {
            cc.set("index.escfg.elasticsearch.use-mapping-for-es7", (Object)String.valueOf(true));
        }
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE);
        esr.setConfiguration(config, INDEX_NAME);
        Configuration indexConfig = config.restrictTo(new String[]{INDEX_NAME});
        IndexProvider idx = this.open(indexConfig);
        this.simpleWriteAndQuery(idx);
        idx.close();
        ElasticSearchClient client = ElasticSearchSetup.REST_CLIENT.connect(indexConfig).getClient();
        Assertions.assertEquals((Object)String.valueOf(7), client.getIndexSettings("janusgraph_jvmlocal_test_store").get("number_of_shards"));
        client.close();
    }

    @ParameterizedTest
    @MethodSource(value={"useMappingsForES7Configuration"})
    public void testExternalMappingsViaMapping(Boolean useMappingsForES7) throws Exception {
        Duration maxWrite = Duration.ofMillis(2000L);
        String storeName = "test_mapping";
        ModifiableConfiguration modifiableConfiguration = esr.setConfiguration(GraphDatabaseConfiguration.buildGraphConfiguration(), INDEX_NAME).set(ElasticSearchIndex.USE_EXTERNAL_MAPPINGS, (Object)true, new String[]{INDEX_NAME});
        if (useMappingsForES7.booleanValue()) {
            modifiableConfiguration.set(ElasticSearchIndex.USE_MAPPING_FOR_ES7, (Object)true, new String[]{INDEX_NAME});
        }
        Configuration indexConfig = modifiableConfiguration.restrictTo(new String[]{INDEX_NAME});
        IndexProvider idx = this.open(indexConfig);
        KeyInformation.IndexRetriever indexRetriever = IndexProviderTest.getIndexRetriever((Map)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()));
        StandardBaseTransactionConfig txConfig = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        IndexTransaction itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, maxWrite);
        try {
            idx.register("test_mapping", "date", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("date"), (BaseTransaction)itx);
            Assertions.fail((String)"should fail");
        }
        catch (PermanentBackendException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        if (this.isMappingUsed(idx)) {
            this.executeRequestWithStringEntity(idx, "janusgraph_test_mapping", this.readTypesMapping("/strict_mapping.json"));
        } else {
            this.executeRequestWithStringEntity(idx, "janusgraph_test_mapping", this.readTypelessMapping("/typeless_strict_mapping.json"));
        }
        idx.register("test_mapping", "date", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("date"), (BaseTransaction)itx);
        try {
            idx.register("test_mapping", "weight", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("weight"), (BaseTransaction)itx);
            Assertions.fail((String)"should fail");
        }
        catch (BackendException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        itx.rollback();
        idx.close();
    }

    private TypedIndexMappings readTypesMapping(String mappingFilePath) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(mappingFilePath);){
            TypedIndexMappings typedIndexMappings = (TypedIndexMappings)this.objectMapper.readValue(inputStream, (TypeReference)new TypeReference<TypedIndexMappings>(){});
            return typedIndexMappings;
        }
    }

    private TypelessIndexMappings readTypelessMapping(String mappingFilePath) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(mappingFilePath);){
            IndexMapping indexMappings;
            TypelessIndexMappings typelessIndexMappings = (TypelessIndexMappings)this.objectMapper.readValue(inputStream, (TypeReference)new TypeReference<TypelessIndexMappings>(){});
            if (JanusGraphElasticsearchContainer.getEsMajorVersion().value >= 8 && (indexMappings = typelessIndexMappings.getMappings()).getProperties().containsKey("boundary")) {
                indexMappings.getProperties().put("boundary", Collections.singletonMap("type", "geo_shape"));
            }
            TypelessIndexMappings typelessIndexMappings2 = typelessIndexMappings;
            return typelessIndexMappings2;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"useMappingsForES7Configuration"})
    public void testExternalDynamic(Boolean useMappingsForES7) throws Exception {
        this.testExternalDynamic(false, useMappingsForES7);
    }

    @ParameterizedTest
    @MethodSource(value={"useMappingsForES7Configuration"})
    public void testUpdateExternalDynamicMapping(Boolean useMappingsForES7) throws Exception {
        this.testExternalDynamic(true, useMappingsForES7);
    }

    @ParameterizedTest
    @MethodSource(value={"useMappingsForES7Configuration"})
    public void testExternalMappingsViaTemplate(Boolean useMappingsForES7) throws Exception {
        Duration maxWrite = Duration.ofMillis(2000L);
        String storeName = "test_mapping";
        ModifiableConfiguration modifiableConfiguration = esr.setConfiguration(GraphDatabaseConfiguration.buildGraphConfiguration(), INDEX_NAME).set(ElasticSearchIndex.USE_EXTERNAL_MAPPINGS, (Object)true, new String[]{INDEX_NAME});
        if (useMappingsForES7.booleanValue()) {
            modifiableConfiguration.set(ElasticSearchIndex.USE_MAPPING_FOR_ES7, (Object)true, new String[]{INDEX_NAME});
        }
        Configuration indexConfig = modifiableConfiguration.restrictTo(new String[]{INDEX_NAME});
        IndexProvider idx = this.open(indexConfig);
        HashMap<String, Object> content = new HashMap<String, Object>(2);
        content.put("index_patterns", Collections.singletonList("janusgraph_test_mapping*"));
        if (this.isMappingUsed(idx)) {
            content.put("mappings", this.readTypesMapping("/strict_mapping.json").getMappings());
        } else {
            content.put("mappings", this.readTypelessMapping("/typeless_strict_mapping.json").getMappings());
        }
        this.executeRequestWithStringEntity(idx, "_template/template_1", content);
        HttpPut newMapping = new HttpPut("janusgraph_test_mapping");
        this.executeRequest((HttpRequestBase)newMapping);
        KeyInformation.IndexRetriever indexRetriever = IndexProviderTest.getIndexRetriever((Map)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()));
        StandardBaseTransactionConfig txConfig = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        IndexTransaction itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, maxWrite);
        idx.register("test_mapping", "date", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("date"), (BaseTransaction)itx);
        try {
            idx.register("test_mapping", "weight", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("weight"), (BaseTransaction)itx);
            Assertions.fail((String)"should fail");
        }
        catch (BackendException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        itx.rollback();
        idx.close();
    }

    private void simpleWriteAndQuery(IndexProvider idx) throws BackendException, InterruptedException {
        Duration maxWrite = Duration.ofMillis(2000L);
        String storeName = "jvmlocal_test_store";
        KeyInformation.IndexRetriever indexRetriever = IndexProviderTest.getIndexRetriever((Map)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_STANDARD, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()));
        StandardBaseTransactionConfig txConfig = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        IndexTransaction itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, maxWrite);
        for (Map.Entry entry : IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).entrySet()) {
            idx.register("jvmlocal_test_store", (String)entry.getKey(), (KeyInformation)entry.getValue(), (BaseTransaction)itx);
        }
        Assertions.assertEquals((long)0L, (long)itx.queryStream(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (JanusGraphPredicate)Text.PREFIX, (Object)"ali"))).count());
        itx.add("jvmlocal_test_store", "doc", "name", (Object)"alice", false);
        itx.commit();
        Thread.sleep(1500L);
        itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, maxWrite);
        Assertions.assertEquals((long)0L, (long)itx.queryStream(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (JanusGraphPredicate)Text.PREFIX, (Object)"zed"))).count());
        Assertions.assertEquals((long)1L, (long)itx.queryStream(new IndexQuery("jvmlocal_test_store", (Condition)PredicateCondition.of((Object)"name", (JanusGraphPredicate)Text.PREFIX, (Object)"ali"))).count());
        itx.rollback();
    }

    private void executeRequest(HttpRequestBase request) throws IOException {
        request.setHeader("Content-Type", "application/json");
        try (CloseableHttpResponse res = this.httpClient.execute(this.host, (HttpRequest)request);){
            int statusCode = res.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300 || EntityUtils.toString((HttpEntity)res.getEntity()).contains("error")) {
                Assertions.fail((String)("Failed to execute a request:" + request.toString() + ". Entity: " + EntityUtils.toString((HttpEntity)res.getEntity())));
            }
        }
    }

    private IndexProvider open(Configuration indexConfig) throws BackendException {
        ElasticSearchIndex idx = new ElasticSearchIndex(indexConfig);
        idx.clearStorage();
        idx.close();
        return new ElasticSearchIndex(indexConfig);
    }

    private void testExternalDynamic(boolean withUpdateMapping, boolean useMappingsForES7) throws Exception {
        Duration maxWrite = Duration.ofMillis(2000L);
        String storeName = "test_mapping";
        Configuration indexConfig = this.buildIndexConfigurationForExternalDynamic(withUpdateMapping, useMappingsForES7);
        IndexProvider idx = this.open(indexConfig);
        KeyInformation.IndexRetriever indexRetriever = IndexProviderTest.getIndexRetriever((Map)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()));
        StandardBaseTransactionConfig txConfig = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        IndexTransaction itx = new IndexTransaction(idx, indexRetriever, (BaseTransactionConfig)txConfig, maxWrite);
        try {
            idx.register("test_mapping", "date", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("date"), (BaseTransaction)itx);
            Assertions.fail((String)"should fail");
        }
        catch (PermanentBackendException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        if (this.isMappingUsed(idx)) {
            this.executeRequestWithStringEntity(idx, "janusgraph_test_mapping", this.readTypesMapping("/dynamic_mapping.json"));
        } else {
            this.executeRequestWithStringEntity(idx, "janusgraph_test_mapping", this.readTypelessMapping("/typeless_dynamic_mapping.json"));
        }
        idx.register("test_mapping", "date", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("date"), (BaseTransaction)itx);
        idx.register("test_mapping", "weight", (KeyInformation)IndexProviderTest.getMapping((IndexFeatures)idx.getFeatures(), (String)ANALYZER_ENGLISH, (String)ANALYZER_KEYWORD, (Mapping)this.preferredGeoShapeMapping()).get("weight"), (BaseTransaction)itx);
        itx.rollback();
        idx.close();
        ElasticSearchClient client = ElasticSearchSetup.REST_CLIENT.connect(indexConfig).getClient();
        Map properties = client.getMapping("janusgraph_test_mapping", "test_mapping").getProperties();
        Assertions.assertEquals((Object)withUpdateMapping, (Object)properties.containsKey("weight"), (String)properties.toString());
    }

    private Configuration buildIndexConfigurationForExternalDynamic(boolean withUpdateMapping, boolean useMappingsForES7) {
        ModifiableConfiguration indexConfig = GraphDatabaseConfiguration.buildGraphConfiguration().set(ElasticSearchIndex.USE_EXTERNAL_MAPPINGS, (Object)true, new String[]{INDEX_NAME});
        indexConfig = indexConfig.set(GraphDatabaseConfiguration.INDEX_PORT, (Object)esr.getPort(), new String[]{INDEX_NAME});
        if (withUpdateMapping) {
            indexConfig = indexConfig.set(ElasticSearchIndex.ALLOW_MAPPING_UPDATE, (Object)true, new String[]{INDEX_NAME});
        }
        if (useMappingsForES7) {
            indexConfig.set(ElasticSearchIndex.USE_MAPPING_FOR_ES7, (Object)true, new String[]{INDEX_NAME});
        }
        return indexConfig.restrictTo(new String[]{INDEX_NAME});
    }

    private void executeRequestWithStringEntity(IndexProvider idx, String endpoint, Object content) throws URISyntaxException, IOException {
        ElasticSearchIndex elasticSearchIndex = (ElasticSearchIndex)idx;
        URIBuilder uriBuilder = new URIBuilder(endpoint);
        if (ElasticMajorVersion.SEVEN.equals((Object)elasticSearchIndex.getVersion()) && elasticSearchIndex.isUseMappingForES7()) {
            uriBuilder.setParameter("include_type_name", "true");
        }
        HttpPut newMapping = new HttpPut(uriBuilder.build());
        newMapping.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(content), StandardCharsets.UTF_8));
        this.executeRequest((HttpRequestBase)newMapping);
    }

    private boolean isMappingUsed(IndexProvider idx) {
        ElasticSearchIndex elasticSearchIndex = (ElasticSearchIndex)idx;
        return elasticSearchIndex.getVersion().getValue() < 7 || ElasticMajorVersion.SEVEN.equals((Object)elasticSearchIndex.getVersion()) && elasticSearchIndex.isUseMappingForES7();
    }

    private Mapping preferredGeoShapeMapping() {
        if (JanusGraphElasticsearchContainer.getEsMajorVersion().value <= 6) {
            return Mapping.PREFIX_TREE;
        }
        return Mapping.BKD;
    }
}

