/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest.util;

import java.io.File;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.janusgraph.diskstorage.es.rest.util.SSLConfigurationCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class SSLConfigurationCallbackTest {
    @Mock
    private SSLContextBuilder sslContextBuilderMock;
    @Mock
    private SSLContext sslContextMock;
    @Mock
    private HttpAsyncClientBuilder httpAsyncClientBuilderMock;

    @BeforeEach
    public void setUp() throws Exception {
        Mockito.when((Object)this.httpAsyncClientBuilderMock.setSSLContext((SSLContext)Mockito.any(SSLContext.class))).thenReturn((Object)this.httpAsyncClientBuilderMock);
        ((SSLContextBuilder)Mockito.doReturn((Object)this.sslContextMock).when((Object)this.sslContextBuilderMock)).build();
    }

    @Test
    public void testSSLContextInitTrustStoreOnly() throws Exception {
        String trustStoreFile = "/a/b/c/truststore.jks";
        String trustStorePassword = "trustStorePassword";
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).withTrustStore("/a/b/c/truststore.jks", "trustStorePassword").build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((File)Mockito.eq((Object)new File("/a/b/c/truststore.jks")), (char[])Mockito.eq((Object)"trustStorePassword".toCharArray()), (TrustStrategy)Mockito.same(null));
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock});
    }

    @Test
    public void testSSLContextInitKeyStoreOnly() throws Exception {
        String keyStoreFile = "/a/b/c/keystore.jks";
        String keyStorePassword = "keyStorePassword";
        String keyPassword = "keyPassword";
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).withKeyStore("/a/b/c/keystore.jks", "keyStorePassword", "keyPassword").build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadKeyMaterial((File)Mockito.eq((Object)new File("/a/b/c/keystore.jks")), (char[])Mockito.eq((Object)"keyStorePassword".toCharArray()), (char[])Mockito.eq((Object)"keyPassword".toCharArray()));
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((TrustStrategy)((org.apache.http.conn.ssl.TrustStrategy)null));
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock});
    }

    @Test
    public void testDisableHostNameVerificationDefaultOff() throws Exception {
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((TrustStrategy)((org.apache.http.conn.ssl.TrustStrategy)null));
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock, this.httpAsyncClientBuilderMock});
    }

    @Test
    public void testDisableHostNameVerification() throws Exception {
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).disableHostNameVerification().build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ArgumentCaptor hostnameVerifierCaptor = ArgumentCaptor.forClass(HostnameVerifier.class);
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLHostnameVerifier((HostnameVerifier)hostnameVerifierCaptor.capture());
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((TrustStrategy)((org.apache.http.conn.ssl.TrustStrategy)null));
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock, this.httpAsyncClientBuilderMock});
        Assertions.assertEquals((int)1, (int)hostnameVerifierCaptor.getAllValues().size());
        HostnameVerifier verifier = (HostnameVerifier)hostnameVerifierCaptor.getValue();
        Assertions.assertTrue((boolean)(verifier instanceof NoopHostnameVerifier));
    }

    @Test
    public void testAllowSelfSignedCertsDefaultOff() throws Exception {
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((TrustStrategy)((org.apache.http.conn.ssl.TrustStrategy)null));
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock, this.httpAsyncClientBuilderMock});
    }

    @Test
    public void testAllowSelfSignedCerts() throws Exception {
        SSLConfigurationCallback cb = SSLConfigurationCallback.Builder.createCustom((SSLContextBuilder)this.sslContextBuilderMock).allowSelfSignedCertificates().build();
        cb.customizeHttpClient(this.httpAsyncClientBuilderMock);
        ArgumentCaptor trustStrategyCaptor = ArgumentCaptor.forClass(org.apache.http.conn.ssl.TrustStrategy.class);
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).loadTrustMaterial((TrustStrategy)trustStrategyCaptor.capture());
        ((SSLContextBuilder)Mockito.verify((Object)this.sslContextBuilderMock)).build();
        ((HttpAsyncClientBuilder)Mockito.verify((Object)this.httpAsyncClientBuilderMock)).setSSLContext(this.sslContextMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sslContextMock, this.sslContextBuilderMock, this.httpAsyncClientBuilderMock});
        Assertions.assertEquals((int)1, (int)trustStrategyCaptor.getAllValues().size());
        org.apache.http.conn.ssl.TrustStrategy trustStrategy = (org.apache.http.conn.ssl.TrustStrategy)trustStrategyCaptor.getValue();
        Assertions.assertTrue((boolean)(trustStrategy instanceof TrustSelfSignedStrategy));
    }
}

