/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexProviderTest;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.StandardKeyInformation;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.util.system.ConfigurationUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class ElasticsearchIndexTest
extends IndexProviderTest {
    @Container
    public static JanusGraphElasticsearchContainer esr = new JanusGraphElasticsearchContainer();
    static HttpHost host;
    static CloseableHttpClient httpClient;
    static ObjectMapper objectMapper;
    private static char REPLACEMENT_CHAR;

    @BeforeAll
    public static void prepareElasticsearch() throws Exception {
        httpClient = HttpClients.createDefault();
        objectMapper = new ObjectMapper();
        host = new HttpHost(InetAddress.getByName(esr.getHostname()), esr.getPort().intValue());
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)new HttpDelete("_ingest/pipeline/pipeline_1")));
        HttpPut newPipeline = new HttpPut("_ingest/pipeline/pipeline_1");
        newPipeline.setHeader("Content-Type", "application/json");
        newPipeline.setEntity((HttpEntity)new StringEntity("{\"description\":\"Test pipeline\",\"processors\":[{\"set\":{\"field\":\"string\",\"value\":\"hello\"}}]}", StandardCharsets.UTF_8));
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)newPipeline));
    }

    @AfterAll
    public static void cleanupElasticsearch() throws IOException {
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)new HttpDelete("janusgraph*")));
        IOUtils.closeQuietly((Closeable)httpClient);
    }

    public IndexProvider openIndex() throws BackendException {
        return new ElasticSearchIndex(this.getESTestConfig());
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public String getEnglishAnalyzerName() {
        return "english";
    }

    public String getKeywordAnalyzerName() {
        return "keyword";
    }

    public Mapping preferredGeoShapeMapping() {
        if (JanusGraphElasticsearchContainer.getEsMajorVersion().value <= 6) {
            return Mapping.PREFIX_TREE;
        }
        return Mapping.BKD;
    }

    public Configuration getESTestConfig() {
        String index = "es";
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc.set("index.es.elasticsearch.ingest-pipeline.ingestvertex", (Object)"pipeline_1");
        return this.makeESTestConfig("es", cc);
    }

    public Configuration makeESTestConfig(String index, CommonsConfiguration cc) {
        return esr.setConfiguration(new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, (WriteConfiguration)cc, BasicConfiguration.Restriction.NONE), index).set(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, (Object)3, new String[]{index}).restrictTo(new String[]{index});
    }

    @Test
    public void testSupport() {
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Text.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Text.NOT_CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.CONTAINS_PREFIX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.NOT_CONTAINS_PREFIX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.CONTAINS_PHRASE));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.NOT_CONTAINS_PHRASE));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.CONTAINS_REGEX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.NOT_CONTAINS_REGEX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.CONTAINS_FUZZY));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.NOT_CONTAINS_FUZZY));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.REGEX));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.TEXT.asParameter()}), (JanusGraphPredicate)Text.NOT_REGEX));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.CONTAINS));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.NOT_CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.PREFIX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.NOT_PREFIX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.FUZZY));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.NOT_FUZZY));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.REGEX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.NOT_REGEX));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Cmp.EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(String.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Cmp.NOT_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.GREATER_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Date.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.NOT_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Boolean.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Boolean.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.NOT_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(UUID.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(UUID.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Cmp.NOT_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Geo.WITHIN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Geo.INTERSECT));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Geo.DISJOINT));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[0]), (JanusGraphPredicate)Geo.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.PREFIX_TREE.asParameter()}), (JanusGraphPredicate)Geo.WITHIN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.PREFIX_TREE.asParameter()}), (JanusGraphPredicate)Geo.INTERSECT));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.PREFIX_TREE.asParameter()}), (JanusGraphPredicate)Geo.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.PREFIX_TREE.asParameter()}), (JanusGraphPredicate)Geo.DISJOINT));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.BKD.asParameter()}), (JanusGraphPredicate)Geo.WITHIN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.BKD.asParameter()}), (JanusGraphPredicate)Geo.INTERSECT));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.BKD.asParameter()}), (JanusGraphPredicate)Geo.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)ElasticsearchIndexTest.of(Geoshape.class, (Cardinality)Cardinality.SINGLE, (Parameter[])new Parameter[]{Mapping.BKD.asParameter()}), (JanusGraphPredicate)Geo.DISJOINT));
    }

    @Test
    public void testErrorInBatch() throws Exception {
        this.initialize("vertex");
        HashMultimap doc1 = HashMultimap.create();
        doc1.put((Object)"time", (Object)"not a time");
        this.add("vertex", "failing-doc", (Multimap)doc1, true);
        this.add("vertex", "non-failing-doc", ElasticsearchIndexTest.getRandomDocument(), true);
        JanusGraphException janusGraphException = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> this.tx.commit(), (String)"Commit should not have succeeded.");
        String message = Throwables.getRootCause((Throwable)janusGraphException).getMessage();
        switch (JanusGraphElasticsearchContainer.getEsMajorVersion().value) {
            case 6: 
            case 7: 
            case 8: {
                Assertions.assertTrue((boolean)message.contains("mapper_parsing_exception"));
                break;
            }
            case 5: {
                Assertions.assertTrue((boolean)message.contains("number_format_exception"));
                break;
            }
            default: {
                Assertions.fail();
            }
        }
        this.tx = null;
    }

    @Test
    public void testUnescapedDollarInSet() throws Exception {
        this.initialize("vertex");
        HashMultimap initialDoc = HashMultimap.create();
        initialDoc.put((Object)"phone_set", (Object)"12345");
        this.add("vertex", "unescaped", (Multimap)initialDoc, true);
        this.clopen();
        HashMultimap updateDoc = HashMultimap.create();
        updateDoc.put((Object)"phone_set", (Object)"$123");
        this.add("vertex", "unescaped", (Multimap)updateDoc, false);
        this.add("vertex", "other", ElasticsearchIndexTest.getRandomDocument(), true);
        this.clopen();
        Assertions.assertEquals((Object)"unescaped", (Object)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"phone_set", (JanusGraphPredicate)Cmp.EQUAL, (Object)"$123"))).toArray()[0]);
        Assertions.assertEquals((Object)"unescaped", (Object)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"phone_set", (JanusGraphPredicate)Cmp.EQUAL, (Object)"12345"))).toArray()[0]);
    }

    @Test
    public void testUpdateAdditionWithLongString() throws Exception {
        this.initialize("vertex");
        HashMultimap initialDoc = HashMultimap.create();
        initialDoc.put((Object)"text", (Object)(RandomStringUtils.randomAlphanumeric((int)500000) + " bob " + RandomStringUtils.randomAlphanumeric((int)500000)));
        this.add("vertex", "long", (Multimap)initialDoc, true);
        this.clopen();
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text", (JanusGraphPredicate)Text.CONTAINS, (Object)"bob"))).count());
        Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text", (JanusGraphPredicate)Text.CONTAINS, (Object)"world"))).count());
        this.tx.add("vertex", "long", "text", (Object)(RandomStringUtils.randomAlphanumeric((int)500000) + " world " + RandomStringUtils.randomAlphanumeric((int)500000)), false);
        this.clopen();
        Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text", (JanusGraphPredicate)Text.CONTAINS, (Object)"bob"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text", (JanusGraphPredicate)Text.CONTAINS, (Object)"world"))).count());
    }

    @Test
    public void testIngestPipeline() throws Exception {
        this.initialize("ingestvertex");
        HashMultimap docs = HashMultimap.create();
        docs.put((Object)"text", (Object)"bob");
        this.add("ingestvertex", "pipeline", (Multimap)docs, true);
        this.clopen();
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("ingestvertex", (Condition)PredicateCondition.of((Object)"text", (JanusGraphPredicate)Text.CONTAINS, (Object)"bob"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("ingestvertex", (Condition)PredicateCondition.of((Object)"string", (JanusGraphPredicate)Cmp.EQUAL, (Object)"hello"))).count());
    }

    @Test
    public void testMapKey2Field_IllegalCharacter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.index.mapKey2Field("here is an illegal character: " + REPLACEMENT_CHAR, null));
    }

    @Test
    public void testMapKey2Field_MappingSpaces() {
        String expected = "field" + REPLACEMENT_CHAR + "name" + REPLACEMENT_CHAR + "with" + REPLACEMENT_CHAR + "spaces";
        Assertions.assertEquals((Object)expected, (Object)this.index.mapKey2Field("field name with spaces", null));
    }

    @Test
    public void testClearStorageWithAliases() throws Exception {
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)new HttpPut("test1")));
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)new HttpPut("test2")));
        HttpPost addAlias = new HttpPost("_aliases");
        addAlias.setHeader("Content-Type", "application/json");
        addAlias.setEntity((HttpEntity)new StringEntity("{\"actions\": [{\"add\": {\"indices\": [\"test1\", \"test2\"], \"alias\": \"alias1\"}}]}", StandardCharsets.UTF_8));
        IOUtils.closeQuietly((Closeable)httpClient.execute(host, (HttpRequest)addAlias));
        this.initialize("vertex");
        Assertions.assertTrue((boolean)this.indexExists((String)GraphDatabaseConfiguration.INDEX_NAME.getDefaultValue()));
        this.index.clearStorage();
        Assertions.assertFalse((boolean)this.indexExists((String)GraphDatabaseConfiguration.INDEX_NAME.getDefaultValue()));
        Assertions.assertTrue((boolean)this.indexExists("test1"));
        Assertions.assertTrue((boolean)this.indexExists("test2"));
    }

    @Test
    public void testCustomMappingProperty() throws BackendException, IOException, ParseException, URISyntaxException {
        String mappingTypeName = "vertex";
        String indexPrefix = "janusgraph";
        String parameterName = "store";
        Boolean parameterValue = true;
        String field = "field_with_custom_prop";
        StandardKeyInformation keyInfo = new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{Mapping.STRING.asParameter(), Parameter.of((String)ParameterType.customParameterName((String)parameterName), (Object)parameterValue)});
        this.index.register(mappingTypeName, field, (KeyInformation)keyInfo, (BaseTransaction)this.tx);
        String indexName = indexPrefix + "_" + mappingTypeName;
        CloseableHttpResponse response = this.getESMapping(indexName, mappingTypeName);
        if (response.getStatusLine().getStatusCode() != 200) {
            indexName = indexPrefix;
            response = this.getESMapping(indexName, mappingTypeName);
        }
        HttpEntity entity = response.getEntity();
        JSONObject json = (JSONObject)new JSONParser().parse(EntityUtils.toString((HttpEntity)entity));
        String returnedProperty = JanusGraphElasticsearchContainer.getEsMajorVersion().value < 7 ? this.retrieveValueFromJSON(json, indexName, "mappings", mappingTypeName, "properties", field, parameterName) : this.retrieveValueFromJSON(json, indexName, "mappings", "properties", field, parameterName);
        Assertions.assertEquals((Object)parameterValue.toString(), (Object)returnedProperty);
        IOUtils.closeQuietly((Closeable)response);
    }

    public static Stream<String> cardinalityTestCollectionNameParams() {
        return Stream.of("phone_set", "phone_list");
    }

    @ParameterizedTest
    @MethodSource(value={"cardinalityTestCollectionNameParams"})
    public void testCollectionCardinality(String collectionName) throws Exception {
        this.initialize("vertex");
        HashMultimap initialDoc = HashMultimap.create();
        initialDoc.put((Object)collectionName, (Object)"12345");
        this.add("vertex", "test", (Multimap)initialDoc, true);
        this.clopen();
        HashMultimap updateDoc = HashMultimap.create();
        updateDoc.put((Object)collectionName, (Object)"123456");
        this.add("vertex", "test", (Multimap)updateDoc, false);
        this.clopen();
        this.add("vertex", "test", (Multimap)initialDoc, false);
        this.clopen();
        this.tx.delete("vertex", "test", collectionName, (Object)"12345", false);
        this.clopen();
        Assertions.assertEquals((Object)"test", (Object)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)collectionName, (JanusGraphPredicate)Cmp.EQUAL, (Object)"123456"))).toArray()[0]);
        if ("phone_set".equals(collectionName)) {
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"phone_set", (JanusGraphPredicate)Cmp.EQUAL, (Object)"12345"))).count());
        } else {
            Assertions.assertEquals((Object)"test", (Object)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"phone_list", (JanusGraphPredicate)Cmp.EQUAL, (Object)"12345"))).toArray()[0]);
        }
    }

    @Test
    public void testTextStringMapping() throws Exception {
        this.initialize("vertex");
        HashMultimap firstDoc = HashMultimap.create();
        firstDoc.put((Object)"text_string", (Object)"John Doe");
        HashMultimap secondDoc = HashMultimap.create();
        secondDoc.put((Object)"text_string", (Object)"John");
        this.add("vertex", "test1", (Multimap)firstDoc, true);
        this.add("vertex", "test2", (Multimap)secondDoc, true);
        this.clopen();
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text_string", (JanusGraphPredicate)Cmp.EQUAL, (Object)"John"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text_string", (JanusGraphPredicate)Cmp.EQUAL, (Object)"John Doe"))).count());
        Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text_string", (JanusGraphPredicate)Text.CONTAINS, (Object)"John"))).count());
    }

    @Test
    public void testTextStringSort() throws Exception {
        this.initialize("vertex");
        HashMultimap firstDoc = HashMultimap.create();
        firstDoc.put((Object)"text_string", (Object)"John Doe");
        HashMultimap secondDoc = HashMultimap.create();
        secondDoc.put((Object)"text_string", (Object)"Jane Doe");
        this.add("vertex", "test1", (Multimap)firstDoc, true);
        this.add("vertex", "test2", (Multimap)secondDoc, true);
        this.clopen();
        Object[] result = this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text_string", (JanusGraphPredicate)Text.CONTAINS, (Object)"Doe"), ImmutableList.of((Object)new IndexQuery.OrderEntry("text_string", Order.ASC, String.class)))).toArray();
        Assertions.assertEquals((Object)"test2", (Object)result[0]);
        Assertions.assertEquals((Object)"test1", (Object)result[1]);
        result = this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)"text_string", (JanusGraphPredicate)Text.CONTAINS, (Object)"Doe"), ImmutableList.of((Object)new IndexQuery.OrderEntry("text_string", Order.DESC, String.class)))).toArray();
        Assertions.assertEquals((Object)"test1", (Object)result[0]);
        Assertions.assertEquals((Object)"test2", (Object)result[1]);
    }

    @Test
    public void testShouldNotShareIndexStoreNameCacheBetweenElasticSearchIndexInstances() throws BackendException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String index1 = "es1";
        String index2 = "es2";
        CommonsConfiguration cc1 = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc1.set("index.es1.elasticsearch.ingest-pipeline.ingestvertex", (Object)"pipeline_1");
        cc1.set("index.es1.elasticsearch.enable_index_names_cache", (Object)true);
        CommonsConfiguration cc2 = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc1.set("index.es2.elasticsearch.ingest-pipeline.ingestvertex", (Object)"pipeline_1");
        cc1.set("index.es2.elasticsearch.enable_index_names_cache", (Object)true);
        Configuration configuration1 = this.makeESTestConfig("es1", cc1);
        Configuration configuration2 = this.makeESTestConfig("es2", cc2);
        ElasticSearchIndex instance1 = new ElasticSearchIndex(configuration1);
        ElasticSearchIndex instance2 = new ElasticSearchIndex(configuration2);
        String indexName1 = (String)configuration1.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        String indexName2 = (String)configuration2.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        Map indexStoreNamesCache1 = (Map)FieldUtils.readField((Object)instance1, (String)"indexStoreNamesCache", (boolean)true);
        Map indexStoreNamesCache2 = (Map)FieldUtils.readField((Object)instance2, (String)"indexStoreNamesCache", (boolean)true);
        Method method1 = instance1.getClass().getDeclaredMethod("getIndexStoreName", String.class);
        method1.setAccessible(true);
        Method method2 = instance1.getClass().getDeclaredMethod("getIndexStoreName", String.class);
        method2.setAccessible(true);
        String store = "Test_store";
        method1.invoke((Object)instance1, store);
        Assertions.assertEquals((int)1, (int)indexStoreNamesCache1.size());
        Assertions.assertEquals((int)0, (int)indexStoreNamesCache2.size());
        method2.invoke((Object)instance2, store);
        Assertions.assertEquals((int)1, (int)indexStoreNamesCache1.size());
        Assertions.assertEquals((int)1, (int)indexStoreNamesCache2.size());
        Assertions.assertEquals((Object)(indexName1 + "_" + store.toLowerCase()), indexStoreNamesCache1.get(store));
        Assertions.assertEquals((Object)(indexName2 + "_" + store.toLowerCase()), indexStoreNamesCache2.get(store));
    }

    @Test
    public void testShouldNotUseIndexStoreNameCache() throws BackendException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String index = "es1";
        CommonsConfiguration cc = new CommonsConfiguration((org.apache.commons.configuration2.Configuration)ConfigurationUtil.createBaseConfiguration());
        cc.set("index.es1.elasticsearch.ingest-pipeline.ingestvertex", (Object)"pipeline_1");
        cc.set("index.es1.elasticsearch.enable_index_names_cache", (Object)false);
        ElasticSearchIndex instance = new ElasticSearchIndex(this.makeESTestConfig("es1", cc));
        Map indexStoreNamesCache = (Map)FieldUtils.readField((Object)instance, (String)"indexStoreNamesCache", (boolean)true);
        Method method = instance.getClass().getDeclaredMethod("getIndexStoreName", String.class);
        method.setAccessible(true);
        String store = "Test_store";
        method.invoke((Object)instance, store);
        Assertions.assertEquals((int)0, (int)indexStoreNamesCache.size());
    }

    private CloseableHttpResponse getESMapping(String indexName, String mappingTypeName) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = JanusGraphElasticsearchContainer.getEsMajorVersion().value < 7 ? new URIBuilder(indexName + "/_mapping/" + mappingTypeName) : new URIBuilder(indexName + "/_mapping");
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        return httpClient.execute(host, (HttpRequest)httpGet);
    }

    private String retrieveValueFromJSON(JSONObject json, String ... hierarchy) {
        for (int i = 0; i < hierarchy.length; ++i) {
            if (i + 1 == hierarchy.length) {
                return json.get((Object)hierarchy[i]).toString();
            }
            json = (JSONObject)json.get((Object)hierarchy[i]);
        }
        return null;
    }

    private boolean indexExists(String name) throws IOException {
        CloseableHttpResponse response = httpClient.execute(host, (HttpRequest)new HttpHead(name));
        boolean exists = response.getStatusLine().getStatusCode() == 200;
        IOUtils.closeQuietly((Closeable)response);
        return exists;
    }

    static {
        REPLACEMENT_CHAR = (char)8226;
    }
}

