/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import io.github.artsok.RepeatedIfExceptionsTest;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.janusgraph.BerkeleyStorageSetup;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.es.ElasticsearchJanusGraphIndexTest;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphIndexTest;
import org.janusgraph.util.system.IOUtils;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class BerkeleyElasticsearchTest
extends ElasticsearchJanusGraphIndexTest {
    @Override
    public ModifiableConfiguration getStorageConfiguration() {
        return BerkeleyStorageSetup.getBerkeleyJEConfiguration();
    }

    @Test
    public void testGraphOfTheGodsFactoryCreate() {
        File bdbtmp = new File("target/gotgfactory");
        IOUtils.deleteDirectory((File)bdbtmp, (boolean)true);
        JanusGraph gotg = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        GraphOfTheGodsFactory.load((JanusGraph)gotg);
        JanusGraphIndexTest.assertGraphOfTheGods((JanusGraph)gotg);
        gotg.close();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testIndexUpdatesWithoutReindex() throws InterruptedException, ExecutionException {
        super.testIndexUpdatesWithoutReindex();
    }
}

