/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.time.Duration;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.graphdb.JanusGraphIndexTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;

public abstract class ElasticsearchJanusGraphIndexTest
extends JanusGraphIndexTest {
    @Container
    protected static JanusGraphElasticsearchContainer esr = new JanusGraphElasticsearchContainer();

    public ElasticsearchJanusGraphIndexTest() {
        super(true, true, true);
    }

    public WriteConfiguration getConfiguration() {
        String[] indexBackends = this.getIndexBackends();
        ModifiableConfiguration config = esr.setConfiguration(this.getStorageConfiguration(), indexBackends);
        for (String indexBackend : indexBackends) {
            config.set(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, (Object)3, new String[]{indexBackend});
        }
        return config.getConfiguration();
    }

    public abstract ModifiableConfiguration getStorageConfiguration();

    @Test
    public void indexShouldExistAfterCreation() throws Exception {
        PropertyKey key = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.buildIndex("verticesByName", Vertex.class).addKey(key).buildMixedIndex("search");
        this.mgmt.commit();
        String expectedIndexName = (String)GraphDatabaseConfiguration.INDEX_NAME.getDefaultValue() + "_" + "verticesByName".toLowerCase();
        Assert.assertTrue((boolean)esr.indexExists(expectedIndexName));
    }

    @Test
    public void indexShouldNotExistAfterDeletion() throws Exception {
        this.clopen(new Object[]{ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.LOG_SEND_DELAY, (String[])new String[]{"janusgraph"}), Duration.ZERO, ElasticsearchJanusGraphIndexTest.option((ConfigOption)KCVSLog.LOG_READ_LAG_TIME, (String[])new String[]{"janusgraph"}), Duration.ofMillis(50L), ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.LOG_READ_INTERVAL, (String[])new String[]{"janusgraph"}), Duration.ofMillis(250L), ElasticsearchJanusGraphIndexTest.option((ConfigOption)GraphDatabaseConfiguration.FORCE_INDEX_USAGE, (String[])new String[0]), true});
        String indexName = "mixed";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, new String[]{propertyName});
        this.enableIndex(indexName);
        this.disableIndex(indexName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        String expectedIndexName = GraphDatabaseConfiguration.INDEX_NAME.getName() + "_" + indexName.toLowerCase();
        Assert.assertFalse((boolean)esr.indexExists(expectedIndexName));
    }

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public boolean supportsWildcardQuery() {
        return true;
    }

    protected boolean supportsCollections() {
        return true;
    }

    public boolean supportsGeoPointExistsQuery() {
        return true;
    }
}

