/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchResponse;
import org.janusgraph.diskstorage.es.ElasticSearchScroll;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ElasticSearchScrollTest {
    @Test
    public void shouldDeleteScrollIfFinishedOnInitialResponse() throws IOException {
        ElasticSearchClient client = (ElasticSearchClient)Mockito.mock(ElasticSearchClient.class);
        ElasticSearchResponse initialResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        int batchSize = 5;
        String scrollId = "testScrollId";
        List<RawQuery.Result<String>> initialResults = this.makeTestResults(batchSize - 1);
        this.setupResultMocks(initialResults, initialResponse, scrollId);
        new ElasticSearchScroll(client, initialResponse, batchSize);
        ((ElasticSearchClient)Mockito.verify((Object)client)).deleteScroll(scrollId);
    }

    @Test
    public void shouldNotDeleteScrollIfNotFinishedOnInitialResponse() throws IOException {
        ElasticSearchClient client = (ElasticSearchClient)Mockito.mock(ElasticSearchClient.class);
        ElasticSearchResponse initialResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        int batchSize = 5;
        String scrollId = "testScrollId";
        List<RawQuery.Result<String>> initialResults = this.makeTestResults(batchSize);
        this.setupResultMocks(initialResults, initialResponse, scrollId);
        new ElasticSearchScroll(client, initialResponse, batchSize);
        ((ElasticSearchClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).deleteScroll(scrollId);
    }

    @Test
    public void shouldDeleteScrollIfFinishedOnSecondResponse() throws IOException {
        ElasticSearchClient client = (ElasticSearchClient)Mockito.mock(ElasticSearchClient.class);
        ElasticSearchResponse initialResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        ElasticSearchResponse secondResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        int batchSize = 5;
        String scrollId = "testScrollId";
        List<RawQuery.Result<String>> initialResults = this.makeTestResults(batchSize);
        this.setupResultMocks(initialResults, initialResponse, scrollId);
        List<RawQuery.Result<String>> secondResults = this.makeTestResults(batchSize - 1);
        this.setupResultMocks(secondResults, secondResponse, scrollId);
        Mockito.when((Object)client.search(scrollId)).thenReturn((Object)secondResponse);
        ElasticSearchScroll scroll = new ElasticSearchScroll(client, initialResponse, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            scroll.next();
        }
        ((ElasticSearchClient)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).deleteScroll((String)Mockito.any());
        scroll.next();
        ((ElasticSearchClient)Mockito.verify((Object)client)).deleteScroll(scrollId);
    }

    @Test
    public void shouldUseTheMostRecentScrollId() throws IOException {
        int i;
        ElasticSearchClient client = (ElasticSearchClient)Mockito.mock(ElasticSearchClient.class);
        ElasticSearchResponse initialResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        String initialScrollId = "initialScrollId";
        ElasticSearchResponse secondResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        String secondScrollId = "secondScrollId";
        ElasticSearchResponse thirdResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        String thirdScrollId = "thirdScrollId";
        int batchSize = 5;
        this.setupResultMocks(this.makeTestResults(batchSize), initialResponse, initialScrollId);
        Mockito.when((Object)client.search(initialScrollId)).thenReturn((Object)secondResponse);
        this.setupResultMocks(this.makeTestResults(batchSize), secondResponse, secondScrollId);
        Mockito.when((Object)client.search(secondScrollId)).thenReturn((Object)thirdResponse);
        this.setupResultMocks(this.makeTestResults(batchSize - 1), thirdResponse, thirdScrollId);
        ElasticSearchScroll scroll = new ElasticSearchScroll(client, initialResponse, batchSize);
        for (i = 0; i < batchSize; ++i) {
            scroll.next();
        }
        scroll.next();
        ((ElasticSearchClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).search(initialScrollId);
        for (i = 0; i < batchSize - 1; ++i) {
            scroll.next();
        }
        scroll.next();
        ((ElasticSearchClient)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)1))).search(secondScrollId);
        ((ElasticSearchClient)Mockito.verify((Object)client)).deleteScroll(thirdScrollId);
        for (i = 0; i < batchSize - 2; ++i) {
            scroll.next();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((ElasticSearchScroll)scroll).next());
    }

    @Test
    public void shouldThrowNoSuchElementWhenReadingPastEnd() throws IOException {
        ElasticSearchClient client = (ElasticSearchClient)Mockito.mock(ElasticSearchClient.class);
        ElasticSearchResponse initialResponse = (ElasticSearchResponse)Mockito.mock(ElasticSearchResponse.class);
        int batchSize = 5;
        String scrollId = "testScrollId";
        List<RawQuery.Result<String>> initialResults = this.makeTestResults(batchSize - 1);
        this.setupResultMocks(initialResults, initialResponse, scrollId);
        ElasticSearchScroll scroll = new ElasticSearchScroll(client, initialResponse, batchSize);
        for (int i = 0; i < batchSize - 1; ++i) {
            scroll.next();
        }
        Assertions.assertThrows(NoSuchElementException.class, () -> ((ElasticSearchScroll)scroll).next());
    }

    private List<RawQuery.Result<String>> makeTestResults(int batchSize) {
        LinkedList<RawQuery.Result<String>> initialResults = new LinkedList<RawQuery.Result<String>>();
        for (int i = 0; i < batchSize; ++i) {
            RawQuery.Result result = new RawQuery.Result((Object)("testResult" + i), 0.9);
            initialResults.add((RawQuery.Result<String>)result);
        }
        return initialResults;
    }

    private void setupResultMocks(List<RawQuery.Result<String>> initialResults, ElasticSearchResponse initialResponse, String scrollId) {
        Mockito.when((Object)initialResponse.getScrollId()).thenReturn((Object)scrollId);
        Mockito.when((Object)initialResponse.getResults()).thenReturn(initialResults.stream());
        Mockito.when((Object)initialResponse.numResults()).thenReturn((Object)initialResults.size());
    }
}

