/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.es.JanusGraphElasticsearchContainer;
import org.janusgraph.graphdb.JanusGraphIndexTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.testcontainers.junit.jupiter.Container;

public abstract class ElasticsearchJanusGraphIndexTest
extends JanusGraphIndexTest {
    @Container
    protected static JanusGraphElasticsearchContainer esr = new JanusGraphElasticsearchContainer();

    public ElasticsearchJanusGraphIndexTest() {
        super(true, true, true);
    }

    public WriteConfiguration getConfiguration() {
        String[] indexBackends = this.getIndexBackends();
        ModifiableConfiguration config = esr.setConfiguration(this.getStorageConfiguration(), indexBackends);
        for (String indexBackend : indexBackends) {
            config.set(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, (Object)3, new String[]{indexBackend});
        }
        return config.getConfiguration();
    }

    public abstract ModifiableConfiguration getStorageConfiguration();

    public boolean supportsLuceneStyleQueries() {
        return true;
    }

    public boolean supportsWildcardQuery() {
        return true;
    }

    protected boolean supportsCollections() {
        return true;
    }

    public boolean supportsGeoPointExistsQuery() {
        return true;
    }
}

