/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;
import org.janusgraph.graphdb.database.serialize.attribute.BooleanSerializer;

public class BooleanArraySerializer
extends ArraySerializer
implements AttributeSerializer<boolean[]> {
    @Override
    public boolean[] convert(Object value) {
        return (boolean[])this.convertInternal(value, Boolean.TYPE, Boolean.class);
    }

    @Override
    protected Object getArray(int length) {
        return new boolean[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setBoolean(array, pos, (Boolean)value);
    }

    @Override
    public boolean[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        boolean[] result = new boolean[length];
        int b = 0;
        for (int i = 0; i < length; ++i) {
            int offset = i % 8;
            if (offset == 0) {
                b = 0xFF & buffer.getByte();
            }
            result[i] = BooleanSerializer.decode((byte)(b >>> 7 - offset & 1));
        }
        return result;
    }

    @Override
    public void write(WriteBuffer buffer, boolean[] attribute) {
        int i;
        this.writeLength(buffer, attribute);
        if (attribute == null) {
            return;
        }
        byte b = 0;
        for (i = 0; i < attribute.length; ++i) {
            b = (byte)(b << 1 | BooleanSerializer.encode(attribute[i]));
            if ((i + 1) % 8 != 0) continue;
            buffer.putByte(b);
            b = 0;
        }
        if (i % 8 != 0) {
            buffer.putByte((byte)(b << 8 - i % 8));
        }
    }
}

