/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonIgnoreProperties;
import org.apache.tinkerpop.shaded.jackson.core.JsonParseException;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectReader;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectWriter;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationFeature;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchMutation;
import org.janusgraph.diskstorage.es.mapping.IndexMapping;
import org.janusgraph.diskstorage.es.mapping.TypedIndexMappings;
import org.janusgraph.diskstorage.es.mapping.TypelessIndexMappings;
import org.janusgraph.diskstorage.es.rest.RestAggResponse;
import org.janusgraph.diskstorage.es.rest.RestBulkResponse;
import org.janusgraph.diskstorage.es.rest.RestCountResponse;
import org.janusgraph.diskstorage.es.rest.RestIndexSettings;
import org.janusgraph.diskstorage.es.rest.RestSearchResponse;
import org.janusgraph.diskstorage.es.script.ESScriptResponse;
import org.janusgraph.util.encoding.StringEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestElasticSearchClient
implements ElasticSearchClient {
    private static final Logger log = LoggerFactory.getLogger(RestElasticSearchClient.class);
    private static final String REQUEST_TYPE_DELETE = "DELETE";
    private static final String REQUEST_TYPE_GET = "GET";
    private static final String REQUEST_TYPE_POST = "POST";
    private static final String REQUEST_TYPE_PUT = "PUT";
    private static final String REQUEST_TYPE_HEAD = "HEAD";
    private static final String REQUEST_SEPARATOR = "/";
    private static final String REQUEST_PARAM_BEGINNING = "?";
    private static final String REQUEST_PARAM_SEPARATOR = "&";
    public static final String INCLUDE_TYPE_NAME_PARAMETER = "include_type_name";
    private static final byte[] NEW_LINE_BYTES = "\n".getBytes(StringEncoding.UTF8_CHARSET);
    private static final Request INFO_REQUEST = new Request("GET", "/");
    private static final ObjectMapper mapper;
    private static final ObjectReader mapReader;
    private static final ObjectWriter mapWriter;
    private static final ElasticMajorVersion DEFAULT_VERSION;
    private static final Function<StringBuilder, StringBuilder> APPEND_OP;
    private final RestClient delegate;
    private ElasticMajorVersion majorVersion;
    private String bulkRefresh;
    private boolean bulkRefreshEnabled = false;
    private final String scrollKeepAlive;
    private final boolean useMappingTypes;
    private final boolean esVersion7;
    private Integer retryOnConflict;
    private final String retryOnConflictKey;
    private final int retryAttemptLimit;
    private final Set<Integer> retryOnErrorCodes;
    private final long retryInitialWaitMs;
    private final long retryMaxWaitMs;

    public RestElasticSearchClient(RestClient delegate, int scrollKeepAlive, boolean useMappingTypesForES7, int retryAttemptLimit, Set<Integer> retryOnErrorCodes, long retryInitialWaitMs, long retryMaxWaitMs) {
        this.delegate = delegate;
        this.majorVersion = this.getMajorVersion();
        this.scrollKeepAlive = scrollKeepAlive + "s";
        this.esVersion7 = ElasticMajorVersion.SEVEN.equals((Object)this.majorVersion);
        this.useMappingTypes = this.majorVersion.getValue() < 7 || useMappingTypesForES7 && this.esVersion7;
        this.retryOnConflictKey = this.majorVersion.getValue() >= 7 ? "retry_on_conflict" : "_retry_on_conflict";
        this.retryAttemptLimit = retryAttemptLimit;
        this.retryOnErrorCodes = Collections.unmodifiableSet(retryOnErrorCodes);
        this.retryInitialWaitMs = retryInitialWaitMs;
        this.retryMaxWaitMs = retryMaxWaitMs;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public ElasticMajorVersion getMajorVersion() {
        if (this.majorVersion != null) {
            return this.majorVersion;
        }
        this.majorVersion = DEFAULT_VERSION;
        try {
            Response response = this.delegate.performRequest(INFO_REQUEST);
            try (InputStream inputStream = response.getEntity().getContent();){
                ClusterInfo info = (ClusterInfo)mapper.readValue(inputStream, ClusterInfo.class);
                this.majorVersion = ElasticMajorVersion.parse(info.getVersion() != null ? (String)info.getVersion().get("number") : null);
            }
        }
        catch (IOException e) {
            log.warn("Unable to determine Elasticsearch server version. Default to {}.", (Object)this.majorVersion, (Object)e);
        }
        return this.majorVersion;
    }

    @Override
    public void clusterHealthRequest(String timeout) throws IOException {
        Request clusterHealthRequest = new Request(REQUEST_TYPE_GET, "/_cluster/health");
        clusterHealthRequest.addParameter("wait_for_status", "yellow");
        clusterHealthRequest.addParameter("timeout", timeout);
        Response response = this.delegate.performRequest(clusterHealthRequest);
        try (InputStream inputStream = response.getEntity().getContent();){
            Map values = (Map)mapReader.readValue(inputStream);
            if (!values.containsKey("timed_out")) {
                throw new IOException("Unexpected response for Elasticsearch cluster health request");
            }
            if (!Objects.equals(values.get("timed_out"), false)) {
                throw new IOException("Elasticsearch timeout waiting for yellow status");
            }
        }
    }

    @Override
    public boolean indexExists(String indexName) throws IOException {
        Response response = this.delegate.performRequest(new Request(REQUEST_TYPE_HEAD, REQUEST_SEPARATOR + indexName));
        return response.getStatusLine().getStatusCode() == 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isIndex(String indexName) {
        try {
            Response response = this.delegate.performRequest(new Request(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName));
            try (InputStream inputStream = response.getEntity().getContent();){
                boolean bl = ((Map)mapper.readValue(inputStream, Map.class)).containsKey(indexName);
                return bl;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isAlias(String aliasName) {
        try {
            this.delegate.performRequest(new Request(REQUEST_TYPE_GET, "/_alias/" + aliasName));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void createStoredScript(String scriptName, Map<String, Object> script) throws IOException {
        Request request = new Request(REQUEST_TYPE_POST, "/_scripts/" + scriptName);
        this.performRequest(request, mapWriter.writeValueAsBytes(script));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ESScriptResponse getStoredScript(String scriptName) throws IOException {
        Request request = new Request(REQUEST_TYPE_GET, "/_scripts/" + scriptName);
        try {
            Response response = this.delegate.performRequest(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Error executing request: " + response.getStatusLine().getReasonPhrase());
            }
            try (InputStream inputStream = response.getEntity().getContent();){
                ESScriptResponse eSScriptResponse = (ESScriptResponse)mapper.readValue(inputStream, (TypeReference)new TypeReference<ESScriptResponse>(){});
                return eSScriptResponse;
            }
            catch (JsonParseException | JsonMappingException | ResponseException e) {
                throw new IOException("Error when we try to parse ES script: " + response.getEntity().getContent());
            }
        }
        catch (ResponseException e) {
            Response response2 = e.getResponse();
            if (e.getResponse().getStatusLine().getStatusCode() != 404) throw new IOException("Error executing request: " + response2.getStatusLine().getReasonPhrase());
            ESScriptResponse esScriptResponse = new ESScriptResponse();
            esScriptResponse.setFound(false);
            return esScriptResponse;
        }
    }

    @Override
    public void createIndex(String indexName, Map<String, Object> settings) throws IOException {
        Request request = new Request(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName);
        if (this.majorVersion.getValue() > 6) {
            if (this.useMappingTypes) {
                request.addParameter(INCLUDE_TYPE_NAME_PARAMETER, "true");
            }
            if (settings != null && settings.size() > 0) {
                HashMap<String, Object> updatedSettings = new HashMap<String, Object>();
                updatedSettings.put("settings", settings);
                settings = updatedSettings;
            }
        }
        this.performRequest(request, mapWriter.writeValueAsBytes(settings));
    }

    @Override
    public void updateIndexSettings(String indexName, Map<String, Object> settings) throws IOException {
        this.performRequest(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_settings", mapWriter.writeValueAsBytes(settings));
    }

    @Override
    public void updateClusterSettings(Map<String, Object> settings) throws IOException {
        this.performRequest(REQUEST_TYPE_PUT, "/_cluster/settings", mapWriter.writeValueAsBytes(settings));
    }

    @Override
    public void addAlias(String alias, String index) throws IOException {
        ImmutableMap actionAlias = ImmutableMap.of((Object)"actions", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"add", (Object)ImmutableMap.of((Object)"index", (Object)index, (Object)"alias", (Object)alias))));
        this.performRequest(REQUEST_TYPE_POST, "/_aliases", mapWriter.writeValueAsBytes((Object)actionAlias));
    }

    @Override
    public Map getIndexSettings(String indexName) throws IOException {
        Response response = this.performRequest(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_settings", null);
        try (InputStream inputStream = response.getEntity().getContent();){
            Map settings = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, RestIndexSettings>>(){});
            Map<String, Object> map = settings == null ? null : ((RestIndexSettings)settings.get(indexName)).getSettings().getMap();
            return map;
        }
    }

    @Override
    public void createMapping(String indexName, String typeName, Map<String, Object> mapping) throws IOException {
        Request request;
        if (this.useMappingTypes) {
            request = new Request(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping" + REQUEST_SEPARATOR + typeName);
            if (this.esVersion7) {
                request.addParameter(INCLUDE_TYPE_NAME_PARAMETER, "true");
            }
        } else {
            request = new Request(REQUEST_TYPE_PUT, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping");
        }
        this.performRequest(request, mapWriter.writeValueAsBytes(mapping));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexMapping getMapping(String indexName, String typeName) throws IOException {
        Request request;
        if (this.useMappingTypes) {
            request = new Request(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping" + REQUEST_SEPARATOR + typeName);
            if (this.esVersion7) {
                request.addParameter(INCLUDE_TYPE_NAME_PARAMETER, "true");
            }
        } else {
            request = new Request(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_mapping");
        }
        try (InputStream inputStream = this.performRequest(request, null).getEntity().getContent();){
            if (this.useMappingTypes) {
                Map settings = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, TypedIndexMappings>>(){});
                IndexMapping indexMapping2 = settings != null ? ((TypedIndexMappings)settings.get(indexName)).getMappings().get(typeName) : null;
                return indexMapping2;
            }
            Map settings = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, TypelessIndexMappings>>(){});
            IndexMapping indexMapping = settings != null ? ((TypelessIndexMappings)settings.get(indexName)).getMappings() : null;
            return indexMapping;
        }
        catch (JsonParseException | JsonMappingException | ResponseException e) {
            log.info("Error when we try to get ES mapping", e);
            return null;
        }
    }

    @Override
    public void deleteIndex(String indexName) throws IOException {
        if (this.isAlias(indexName)) {
            String path = "/_alias/" + indexName;
            Response response = this.performRequest(REQUEST_TYPE_GET, path, null);
            try (InputStream inputStream = response.getEntity().getContent();){
                Map records = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (records == null) {
                    return;
                }
                for (String index : records.keySet()) {
                    if (!this.indexExists(index)) continue;
                    this.performRequest(REQUEST_TYPE_DELETE, REQUEST_SEPARATOR + index, null);
                }
            }
        }
    }

    @Override
    public void clearStore(String indexName, String storeName) throws IOException {
        String name = indexName + "_" + storeName;
        if (this.indexExists(name)) {
            this.performRequest(REQUEST_TYPE_DELETE, REQUEST_SEPARATOR + indexName + "_" + storeName, null);
        }
    }

    @Override
    public void bulkRequest(List<ElasticSearchMutation> requests, String ingestPipeline) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (ElasticSearchMutation request : requests) {
            HashMap<String, Object> requestData = new HashMap<String, Object>();
            if (this.useMappingTypes) {
                requestData.put("_index", request.getIndex());
                requestData.put("_type", request.getType());
                requestData.put("_id", request.getId());
            } else {
                requestData.put("_index", request.getIndex());
                requestData.put("_id", request.getId());
            }
            if (this.retryOnConflict != null && request.getRequestType() == ElasticSearchMutation.RequestType.UPDATE) {
                requestData.put(this.retryOnConflictKey, this.retryOnConflict);
            }
            outputStream.write(mapWriter.writeValueAsBytes((Object)ImmutableMap.of((Object)request.getRequestType().name().toLowerCase(), requestData)));
            outputStream.write(NEW_LINE_BYTES);
            if (request.getSource() == null) continue;
            outputStream.write(mapWriter.writeValueAsBytes((Object)request.getSource()));
            outputStream.write(NEW_LINE_BYTES);
        }
        StringBuilder builder = new StringBuilder();
        if (ingestPipeline != null) {
            APPEND_OP.apply(builder).append("pipeline=").append(ingestPipeline);
        }
        if (this.bulkRefreshEnabled) {
            APPEND_OP.apply(builder).append("refresh=").append(this.bulkRefresh);
        }
        builder.insert(0, "/_bulk");
        Response response = this.performRequest(REQUEST_TYPE_POST, builder.toString(), outputStream.toByteArray());
        try (InputStream inputStream = response.getEntity().getContent();){
            RestBulkResponse bulkResponse = (RestBulkResponse)mapper.readValue(inputStream, RestBulkResponse.class);
            List<Object> errors = bulkResponse.getItems().stream().flatMap(item -> item.values().stream()).filter(item -> item.getError() != null && item.getStatus() != 404).map(RestBulkResponse.RestBulkItemResponse::getError).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                errors.forEach(error -> log.error("Failed to execute ES query: {}", error));
                throw new IOException("Failure(s) in Elasticsearch bulk request: " + errors);
            }
        }
    }

    public void setRetryOnConflict(Integer retryOnConflict) {
        this.retryOnConflict = retryOnConflict;
    }

    @Override
    public long countTotal(String indexName, Map<String, Object> requestData) throws IOException {
        Request request = new Request(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_count");
        byte[] requestDataBytes = mapper.writeValueAsBytes(requestData);
        if (log.isDebugEnabled()) {
            log.debug("Elasticsearch request: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(requestData));
        }
        Response response = this.performRequest(request, requestDataBytes);
        try (InputStream inputStream = response.getEntity().getContent();){
            long l = ((RestCountResponse)mapper.readValue(inputStream, RestCountResponse.class)).getCount();
            return l;
        }
    }

    private double executeAggs(String indexName, Map<String, Object> requestData, String agg, String fieldName) throws IOException {
        Request request = new Request(REQUEST_TYPE_GET, REQUEST_SEPARATOR + indexName + REQUEST_SEPARATOR + "_search");
        requestData.put("aggs", ImmutableMap.of((Object)"agg_result", (Object)ImmutableMap.of((Object)agg, (Object)ImmutableMap.of((Object)"field", (Object)fieldName))));
        byte[] requestDataBytes = mapper.writeValueAsBytes(requestData);
        if (log.isDebugEnabled()) {
            log.debug("Elasticsearch request: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(requestData));
        }
        Response response = this.performRequest(request, requestDataBytes);
        try (InputStream inputStream = response.getEntity().getContent();){
            double d = ((RestAggResponse)mapper.readValue(inputStream, RestAggResponse.class)).getAggregations().getAggResult().getValue();
            return d;
        }
    }

    private Number adaptNumberType(double value, Class<? extends Number> expectedType) {
        if (expectedType == null) {
            return value;
        }
        if (Byte.class.isAssignableFrom(expectedType)) {
            return (byte)value;
        }
        if (Short.class.isAssignableFrom(expectedType)) {
            return (short)value;
        }
        if (Integer.class.isAssignableFrom(expectedType)) {
            return (int)value;
        }
        if (Long.class.isAssignableFrom(expectedType)) {
            return (long)value;
        }
        if (Float.class.isAssignableFrom(expectedType)) {
            return Float.valueOf((float)value);
        }
        return value;
    }

    @Override
    public Number min(String indexName, Map<String, Object> requestData, String fieldName, Class<? extends Number> expectedType) throws IOException {
        return this.adaptNumberType(this.executeAggs(indexName, requestData, "min", fieldName), expectedType);
    }

    @Override
    public Number max(String indexName, Map<String, Object> requestData, String fieldName, Class<? extends Number> expectedType) throws IOException {
        return this.adaptNumberType(this.executeAggs(indexName, requestData, "max", fieldName), expectedType);
    }

    @Override
    public double avg(String indexName, Map<String, Object> requestData, String fieldName) throws IOException {
        return this.executeAggs(indexName, requestData, "avg", fieldName);
    }

    @Override
    public Number sum(String indexName, Map<String, Object> requestData, String fieldName, Class<? extends Number> expectedType) throws IOException {
        double sum = this.executeAggs(indexName, requestData, "sum", fieldName);
        if (Float.class.isAssignableFrom(expectedType) || Double.class.isAssignableFrom(expectedType)) {
            return sum;
        }
        return (long)sum;
    }

    @Override
    public RestSearchResponse search(String indexName, Map<String, Object> requestData, boolean useScroll) throws IOException {
        StringBuilder path = new StringBuilder(REQUEST_SEPARATOR).append(indexName);
        path.append(REQUEST_SEPARATOR).append("_search");
        if (useScroll) {
            path.append(REQUEST_PARAM_BEGINNING).append("scroll=").append(this.scrollKeepAlive);
        }
        return this.search(requestData, path.toString());
    }

    @Override
    public RestSearchResponse search(String scrollId) throws IOException {
        HashMap<String, Object> requestData = new HashMap<String, Object>();
        requestData.put("scroll", this.scrollKeepAlive);
        requestData.put("scroll_id", scrollId);
        return this.search(requestData, "/_search/scroll");
    }

    @Override
    public void deleteScroll(String scrollId) throws IOException {
        this.delegate.performRequest(new Request(REQUEST_TYPE_DELETE, "/_search/scroll/" + scrollId));
    }

    public void setBulkRefresh(String bulkRefresh) {
        this.bulkRefresh = bulkRefresh;
        this.bulkRefreshEnabled = bulkRefresh != null && !bulkRefresh.equalsIgnoreCase("false");
    }

    private RestSearchResponse search(Map<String, Object> requestData, String path) throws IOException {
        Request request = new Request(REQUEST_TYPE_POST, path);
        byte[] requestDataBytes = mapper.writeValueAsBytes(requestData);
        if (log.isDebugEnabled()) {
            log.debug("Elasticsearch request: " + mapper.writerWithDefaultPrettyPrinter().writeValueAsString(requestData));
        }
        Response response = this.performRequest(request, requestDataBytes);
        try (InputStream inputStream = response.getEntity().getContent();){
            RestSearchResponse restSearchResponse = (RestSearchResponse)mapper.readValue(inputStream, RestSearchResponse.class);
            return restSearchResponse;
        }
    }

    private Response performRequest(String method, String path, byte[] requestData) throws IOException {
        return this.performRequest(new Request(method, path), requestData);
    }

    private Response performRequestWithRetry(Request request) throws IOException {
        int retryCount = 0;
        while (true) {
            try {
                return this.delegate.performRequest(request);
            }
            catch (ResponseException e) {
                if (!this.retryOnErrorCodes.contains(e.getResponse().getStatusLine().getStatusCode()) || retryCount >= this.retryAttemptLimit) {
                    throw e;
                }
                long waitDurationMs = Math.min((long)((double)this.retryInitialWaitMs * Math.pow(10.0, retryCount)), this.retryMaxWaitMs);
                log.warn("Retrying Elasticsearch request in {} ms. Attempt {} of {}", new Object[]{waitDurationMs, retryCount, this.retryAttemptLimit});
                try {
                    Thread.sleep(waitDurationMs);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(String.format("Thread interrupted while waiting for retry attempt %d of %d", retryCount, this.retryAttemptLimit), interruptedException);
                }
                ++retryCount;
                continue;
            }
            break;
        }
    }

    private Response performRequest(Request request, byte[] requestData) throws IOException {
        ByteArrayEntity entity = requestData != null ? new ByteArrayEntity(requestData, ContentType.APPLICATION_JSON) : null;
        request.setEntity((HttpEntity)entity);
        Response response = this.performRequestWithRetry(request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new IOException("Error executing request: " + response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new Geoshape.GeoshapeGsonSerializerV2d0());
        mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapReader = mapper.readerWithView(Map.class).forType(HashMap.class);
        mapWriter = mapper.writerWithView(Map.class);
        DEFAULT_VERSION = ElasticMajorVersion.EIGHT;
        APPEND_OP = sb -> sb.append(sb.length() == 0 ? REQUEST_PARAM_BEGINNING : REQUEST_PARAM_SEPARATOR);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static final class ClusterInfo {
        private Map<String, Object> version;

        private ClusterInfo() {
        }

        public Map<String, Object> getVersion() {
            return this.version;
        }

        public void setVersion(Map<String, Object> version) {
            this.version = version;
        }
    }
}

