/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MetricsBuffer;
import org.apache.hadoop.metrics2.impl.MetricsBufferBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsConfig;
import org.apache.hadoop.metrics2.impl.MetricsConfigException;
import org.apache.hadoop.metrics2.impl.MetricsSinkAdapter;
import org.apache.hadoop.metrics2.impl.MetricsSourceAdapter;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricsSourceBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(context="metricssystem")
public class MetricsSystemImpl
extends MetricsSystem
implements MetricsSource {
    static final Logger LOG = LoggerFactory.getLogger(MetricsSystemImpl.class);
    static final String MS_NAME = "MetricsSystem";
    static final String MS_STATS_NAME = "MetricsSystem,sub=Stats";
    static final String MS_STATS_DESC = "Metrics system metrics";
    static final String MS_CONTROL_NAME = "MetricsSystem,sub=Control";
    static final String MS_INIT_MODE_KEY = "hadoop.metrics.init.mode";
    private final Map<String, MetricsSourceAdapter> sources;
    private final Map<String, MetricsSource> allSources;
    private final Map<String, MetricsSinkAdapter> sinks;
    private final Map<String, MetricsSink> allSinks;
    private final List<MetricsSystem.Callback> callbacks;
    private final Map<String, MetricsSystem.Callback> namedCallbacks;
    private final MetricsCollectorImpl collector;
    private final MetricsRegistry registry = new MetricsRegistry("MetricsSystem");
    @Metric(value={"Snapshot", "Snapshot stats"})
    MutableStat snapshotStat;
    @Metric(value={"Publish", "Publishing stats"})
    MutableStat publishStat;
    @Metric(value={"Dropped updates by all sinks"})
    MutableCounterLong droppedPubAll;
    private final List<MetricsTag> injectedTags;
    private String prefix;
    private MetricsFilter sourceFilter;
    private MetricsConfig config;
    private Map<String, MetricsConfig> sourceConfigs;
    private Map<String, MetricsConfig> sinkConfigs;
    private boolean monitoring = false;
    private Timer timer;
    private long period;
    private long logicalTime;
    private ObjectName mbeanName;
    private boolean publishSelfMetrics = true;
    private MetricsSourceAdapter sysSource;
    private int refCount = 0;

    public MetricsSystemImpl(String prefix) {
        this.prefix = prefix;
        this.allSources = Maps.newHashMap();
        this.sources = Maps.newLinkedHashMap();
        this.allSinks = Maps.newHashMap();
        this.sinks = Maps.newLinkedHashMap();
        this.sourceConfigs = Maps.newHashMap();
        this.sinkConfigs = Maps.newHashMap();
        this.callbacks = Lists.newArrayList();
        this.namedCallbacks = Maps.newHashMap();
        this.injectedTags = Lists.newArrayList();
        this.collector = new MetricsCollectorImpl();
        if (prefix != null) {
            this.initSystemMBean();
        }
    }

    public MetricsSystemImpl() {
        this(null);
    }

    @Override
    public synchronized MetricsSystem init(String prefix) {
        if (this.monitoring && !DefaultMetricsSystem.inMiniClusterMode()) {
            LOG.warn(this.prefix + " metrics system already initialized!");
            return this;
        }
        this.prefix = Preconditions.checkNotNull(prefix, "prefix");
        ++this.refCount;
        if (this.monitoring) {
            LOG.info(this.prefix + " metrics system started (again)");
            return this;
        }
        switch (this.initMode()) {
            case NORMAL: {
                try {
                    this.start();
                }
                catch (MetricsConfigException e) {
                    LOG.warn("Metrics system not started: " + e.getMessage());
                    LOG.debug("Stacktrace: ", (Throwable)e);
                }
                break;
            }
            case STANDBY: {
                LOG.info(prefix + " metrics system started in standby mode");
            }
        }
        this.initSystemMBean();
        return this;
    }

    @Override
    public synchronized void start() {
        Preconditions.checkNotNull(this.prefix, "prefix");
        if (this.monitoring) {
            LOG.warn(this.prefix + " metrics system already started!", (Throwable)new MetricsException("Illegal start"));
            return;
        }
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.preStart();
        }
        for (MetricsSystem.Callback cb : this.namedCallbacks.values()) {
            cb.preStart();
        }
        this.configure(this.prefix);
        this.startTimer();
        this.monitoring = true;
        LOG.info(this.prefix + " metrics system started");
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.postStart();
        }
        for (MetricsSystem.Callback cb : this.namedCallbacks.values()) {
            cb.postStart();
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.monitoring && !DefaultMetricsSystem.inMiniClusterMode()) {
            LOG.warn(this.prefix + " metrics system not yet started!", (Throwable)new MetricsException("Illegal stop"));
            return;
        }
        if (!this.monitoring) {
            LOG.info(this.prefix + " metrics system stopped (again)");
            return;
        }
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.preStop();
        }
        for (MetricsSystem.Callback cb : this.namedCallbacks.values()) {
            cb.preStop();
        }
        LOG.info("Stopping " + this.prefix + " metrics system...");
        this.stopTimer();
        this.stopSources();
        this.stopSinks();
        this.clearConfigs();
        this.monitoring = false;
        LOG.info(this.prefix + " metrics system stopped.");
        for (MetricsSystem.Callback cb : this.callbacks) {
            cb.postStop();
        }
        for (MetricsSystem.Callback cb : this.namedCallbacks.values()) {
            cb.postStop();
        }
    }

    @Override
    public synchronized <T> T register(String name, String desc, T source) {
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder(source);
        final MetricsSource s2 = sb.build();
        MetricsInfo si = sb.info();
        String name2 = name == null ? si.name() : name;
        final String finalDesc = desc == null ? si.description() : desc;
        final String finalName = DefaultMetricsSystem.sourceName(name2, !this.monitoring);
        this.allSources.put(finalName, s2);
        LOG.debug(finalName + ", " + finalDesc);
        if (this.monitoring) {
            this.registerSource(finalName, finalDesc, s2);
        }
        this.register(finalName, new MetricsSystem.AbstractCallback(){

            @Override
            public void postStart() {
                MetricsSystemImpl.this.registerSource(finalName, finalDesc, s2);
            }
        });
        return source;
    }

    @Override
    public synchronized void unregisterSource(String name) {
        if (this.sources.containsKey(name)) {
            this.sources.get(name).stop();
            this.sources.remove(name);
        }
        if (this.allSources.containsKey(name)) {
            this.allSources.remove(name);
        }
        if (this.namedCallbacks.containsKey(name)) {
            this.namedCallbacks.remove(name);
        }
        DefaultMetricsSystem.removeSourceName(name);
    }

    synchronized void registerSource(String name, String desc, MetricsSource source) {
        Preconditions.checkNotNull(this.config, "config");
        MetricsConfig conf = this.sourceConfigs.get(name);
        MetricsSourceAdapter sa = new MetricsSourceAdapter(this.prefix, name, desc, source, this.injectedTags, this.period, conf != null ? conf : this.config.subset("source"));
        this.sources.put(name, sa);
        sa.start();
        LOG.debug("Registered source " + name);
    }

    @Override
    public synchronized <T extends MetricsSink> T register(final String name, final String description, final T sink) {
        LOG.debug(name + ", " + description);
        if (this.allSinks.containsKey(name)) {
            if (this.sinks.get(name) == null) {
                this.registerSink(name, description, sink);
            } else {
                LOG.warn("Sink " + name + " already exists!");
            }
            return sink;
        }
        this.allSinks.put(name, sink);
        if (this.config != null) {
            this.registerSink(name, description, sink);
        }
        this.register(name, new MetricsSystem.AbstractCallback(){

            @Override
            public void postStart() {
                MetricsSystemImpl.this.register(name, description, sink);
            }
        });
        return sink;
    }

    synchronized void registerSink(String name, String desc, MetricsSink sink) {
        Preconditions.checkNotNull(this.config, "config");
        MetricsConfig conf = this.sinkConfigs.get(name);
        MetricsSinkAdapter sa = conf != null ? MetricsSystemImpl.newSink(name, desc, sink, conf) : MetricsSystemImpl.newSink(name, desc, sink, this.config.subset("sink"));
        this.sinks.put(name, sa);
        sa.start();
        LOG.info("Registered sink " + name);
    }

    @Override
    public synchronized void register(MetricsSystem.Callback callback) {
        this.callbacks.add((MetricsSystem.Callback)this.getProxyForCallback(callback));
    }

    private synchronized void register(String name, MetricsSystem.Callback callback) {
        this.namedCallbacks.put(name, (MetricsSystem.Callback)this.getProxyForCallback(callback));
    }

    private Object getProxyForCallback(final MetricsSystem.Callback callback) {
        return Proxy.newProxyInstance(callback.getClass().getClassLoader(), new Class[]{MetricsSystem.Callback.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return method.invoke((Object)callback, args);
                }
                catch (Exception e) {
                    LOG.warn("Caught exception in callback " + method.getName(), (Throwable)e);
                    return null;
                }
            }
        });
    }

    @Override
    public synchronized void startMetricsMBeans() {
        for (MetricsSourceAdapter sa : this.sources.values()) {
            sa.startMBeans();
        }
    }

    @Override
    public synchronized void stopMetricsMBeans() {
        for (MetricsSourceAdapter sa : this.sources.values()) {
            sa.stopMBeans();
        }
    }

    @Override
    public synchronized String currentConfig() {
        PropertiesConfiguration saver = new PropertiesConfiguration();
        StringWriter writer = new StringWriter();
        saver.copy(this.config);
        try {
            saver.write(writer);
        }
        catch (Exception e) {
            throw new MetricsConfigException("Error stringify config", e);
        }
        return writer.toString();
    }

    private synchronized void startTimer() {
        if (this.timer != null) {
            LOG.warn(this.prefix + " metrics system timer already started!");
            return;
        }
        this.logicalTime = 0L;
        long millis = this.period;
        this.timer = new Timer("Timer for '" + this.prefix + "' metrics system", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    MetricsSystemImpl.this.onTimerEvent();
                }
                catch (Exception e) {
                    LOG.warn("Error invoking metrics timer", (Throwable)e);
                }
            }
        }, millis, millis);
        LOG.info("Scheduled Metric snapshot period at " + this.period / 1000L + " second(s).");
    }

    synchronized void onTimerEvent() {
        this.logicalTime += this.period;
        if (this.sinks.size() > 0) {
            this.publishMetrics(this.sampleMetrics(), false);
        }
    }

    @Override
    public synchronized void publishMetricsNow() {
        if (this.sinks.size() > 0) {
            this.publishMetrics(this.sampleMetrics(), true);
        }
    }

    @VisibleForTesting
    public synchronized MetricsBuffer sampleMetrics() {
        this.collector.clear();
        MetricsBufferBuilder bufferBuilder = new MetricsBufferBuilder();
        for (Map.Entry<String, MetricsSourceAdapter> entry : this.sources.entrySet()) {
            if (this.sourceFilter != null && !this.sourceFilter.accepts(entry.getKey())) continue;
            this.snapshotMetrics(entry.getValue(), bufferBuilder);
        }
        if (this.publishSelfMetrics) {
            this.snapshotMetrics(this.sysSource, bufferBuilder);
        }
        MetricsBuffer buffer = bufferBuilder.get();
        return buffer;
    }

    private void snapshotMetrics(MetricsSourceAdapter sa, MetricsBufferBuilder bufferBuilder) {
        long startTime = Time.monotonicNow();
        bufferBuilder.add(sa.name(), sa.getMetrics(this.collector, true));
        this.collector.clear();
        this.snapshotStat.add(Time.monotonicNow() - startTime);
        LOG.debug("Snapshotted source " + sa.name());
    }

    synchronized void publishMetrics(MetricsBuffer buffer, boolean immediate) {
        int dropped = 0;
        for (MetricsSinkAdapter sa : this.sinks.values()) {
            long startTime = Time.monotonicNow();
            boolean result = immediate ? sa.putMetricsImmediate(buffer) : sa.putMetrics(buffer, this.logicalTime);
            dropped += result ? 0 : 1;
            this.publishStat.add(Time.monotonicNow() - startTime);
        }
        this.droppedPubAll.incr(dropped);
    }

    private synchronized void stopTimer() {
        if (this.timer == null) {
            LOG.warn(this.prefix + " metrics system timer already stopped!");
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    private synchronized void stopSources() {
        for (Map.Entry<String, MetricsSourceAdapter> entry : this.sources.entrySet()) {
            MetricsSourceAdapter sa = entry.getValue();
            LOG.debug("Stopping metrics source " + entry.getKey() + ": class=" + sa.source().getClass());
            sa.stop();
        }
        this.sysSource.stop();
        this.sources.clear();
    }

    private synchronized void stopSinks() {
        for (Map.Entry<String, MetricsSinkAdapter> entry : this.sinks.entrySet()) {
            MetricsSinkAdapter sa = entry.getValue();
            LOG.debug("Stopping metrics sink " + entry.getKey() + ": class=" + sa.sink().getClass());
            sa.stop();
        }
        this.sinks.clear();
    }

    private synchronized void configure(String prefix) {
        this.config = MetricsConfig.create(prefix);
        this.configureSinks();
        this.configureSources();
        this.configureSystem();
    }

    private synchronized void configureSystem() {
        this.injectedTags.add(Interns.tag(MsInfo.Hostname, MetricsSystemImpl.getHostname()));
    }

    private synchronized void configureSinks() {
        this.sinkConfigs = this.config.getInstanceConfigs("sink");
        long confPeriodMillis = 0L;
        for (Map.Entry<String, MetricsConfig> entry : this.sinkConfigs.entrySet()) {
            MetricsConfig conf = entry.getValue();
            int sinkPeriod = conf.getInt("period", 10);
            long sinkPeriodMillis = conf.getLong("periodMillis", sinkPeriod * 1000);
            confPeriodMillis = confPeriodMillis == 0L ? sinkPeriodMillis : ArithmeticUtils.gcd(confPeriodMillis, sinkPeriodMillis);
            String clsName = conf.getClassName("");
            if (clsName == null) continue;
            String sinkName = entry.getKey();
            try {
                MetricsSinkAdapter sa = MetricsSystemImpl.newSink(sinkName, conf.getString("description", sinkName), conf);
                sa.start();
                this.sinks.put(sinkName, sa);
            }
            catch (Exception e) {
                LOG.warn("Error creating sink '" + sinkName + "'", (Throwable)e);
            }
        }
        long periodSec = this.config.getInt("period", 10);
        this.period = confPeriodMillis > 0L ? confPeriodMillis : this.config.getLong("periodMillis", periodSec * 1000L);
    }

    static MetricsSinkAdapter newSink(String name, String desc, MetricsSink sink, MetricsConfig conf) {
        return new MetricsSinkAdapter(name, desc, sink, conf.getString("context"), conf.getFilter("source.filter"), conf.getFilter("record.filter"), conf.getFilter("metric.filter"), conf.getInt("period", 10) * 1000, conf.getInt("queue.capacity", 1), conf.getInt("retry.delay", 10), conf.getFloat("retry.backoff", 2.0f), conf.getInt("retry.count", 1));
    }

    static MetricsSinkAdapter newSink(String name, String desc, MetricsConfig conf) {
        return MetricsSystemImpl.newSink(name, desc, (MetricsSink)conf.getPlugin(""), conf);
    }

    private void configureSources() {
        this.sourceFilter = this.config.getFilter("*.source.filter");
        this.sourceConfigs = this.config.getInstanceConfigs("source");
        this.registerSystemSource();
    }

    private void clearConfigs() {
        this.sinkConfigs.clear();
        this.sourceConfigs.clear();
        this.injectedTags.clear();
        this.config = null;
    }

    static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Error getting localhost name. Using 'localhost'...", (Throwable)e);
            return "localhost";
        }
    }

    private void registerSystemSource() {
        MetricsConfig sysConf = this.sourceConfigs.get(MS_NAME);
        this.sysSource = new MetricsSourceAdapter(this.prefix, MS_STATS_NAME, MS_STATS_DESC, MetricsAnnotations.makeSource(this), this.injectedTags, this.period, sysConf == null ? this.config.subset("source") : sysConf);
        this.sysSource.start();
    }

    @Override
    public synchronized void getMetrics(MetricsCollector builder, boolean all) {
        MetricsRecordBuilder rb = builder.addRecord(MS_NAME).addGauge((MetricsInfo)MsInfo.NumActiveSources, this.sources.size()).addGauge((MetricsInfo)MsInfo.NumAllSources, this.allSources.size()).addGauge((MetricsInfo)MsInfo.NumActiveSinks, this.sinks.size()).addGauge((MetricsInfo)MsInfo.NumAllSinks, this.allSinks.size());
        for (MetricsSinkAdapter sa : this.sinks.values()) {
            sa.snapshot(rb, all);
        }
        this.registry.snapshot(rb, all);
    }

    private void initSystemMBean() {
        Preconditions.checkNotNull(this.prefix, "prefix should not be null here!");
        if (this.mbeanName == null) {
            this.mbeanName = MBeans.register(this.prefix, MS_CONTROL_NAME, this);
        }
    }

    @Override
    public synchronized boolean shutdown() {
        LOG.debug("refCount=" + this.refCount);
        if (this.refCount <= 0) {
            LOG.debug("Redundant shutdown", new Throwable());
            return true;
        }
        if (--this.refCount > 0) {
            return false;
        }
        if (this.monitoring) {
            try {
                this.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping the metrics system", (Throwable)e);
            }
        }
        this.allSources.clear();
        this.allSinks.clear();
        this.callbacks.clear();
        this.namedCallbacks.clear();
        if (this.mbeanName != null) {
            MBeans.unregister(this.mbeanName);
            this.mbeanName = null;
        }
        LOG.info(this.prefix + " metrics system shutdown complete.");
        return true;
    }

    @Override
    public MetricsSource getSource(String name) {
        return this.allSources.get(name);
    }

    @VisibleForTesting
    MetricsSourceAdapter getSourceAdapter(String name) {
        return this.sources.get(name);
    }

    @VisibleForTesting
    public MetricsSinkAdapter getSinkAdapter(String name) {
        return this.sinks.get(name);
    }

    private InitMode initMode() {
        LOG.debug("from system property: " + System.getProperty(MS_INIT_MODE_KEY));
        LOG.debug("from environment variable: " + System.getenv(MS_INIT_MODE_KEY));
        String m3 = System.getProperty(MS_INIT_MODE_KEY);
        String m22 = m3 == null ? System.getenv(MS_INIT_MODE_KEY) : m3;
        return InitMode.valueOf(StringUtils.toUpperCase(m22 == null ? InitMode.NORMAL.name() : m22));
    }

    static enum InitMode {
        NORMAL,
        STANDBY;

    }
}

