/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.HashKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class MurmurHash
extends Hash {
    private static MurmurHash _instance = new MurmurHash();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    public <T> int hash(HashKey<T> hashKey, int seed) {
        int m3 = 1540483477;
        int r = 24;
        int length = hashKey.length();
        int h2 = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = hashKey.get(i_4 + 3);
            k <<= 8;
            k |= hashKey.get(i_4 + 2) & 0xFF;
            k <<= 8;
            k |= hashKey.get(i_4 + 1) & 0xFF;
            k <<= 8;
            k |= hashKey.get(i_4 + 0) & 0xFF;
            k *= m3;
            k ^= k >>> r;
            h2 *= m3;
            h2 ^= (k *= m3);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        int i_m = len_m;
        if (left != 0) {
            if (left >= 3) {
                h2 ^= hashKey.get(i_m + 2) << 16;
            }
            if (left >= 2) {
                h2 ^= hashKey.get(i_m + 1) << 8;
            }
            if (left >= 1) {
                h2 ^= hashKey.get(i_m);
            }
            h2 *= m3;
        }
        h2 ^= h2 >>> 13;
        h2 *= m3;
        h2 ^= h2 >>> 15;
        return h2;
    }
}

