/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xbill.DNS;

import java.io.IOException;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.TextParseException;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Tokenizer;

public class URIRecord
extends Record {
    private static final long serialVersionUID = 7955422413971804232L;
    private int priority;
    private int weight;
    private byte[] target;

    URIRecord() {
        this.target = new byte[0];
    }

    Record getObject() {
        return new URIRecord();
    }

    public URIRecord(Name name, int dclass, long ttl, int priority, int weight, String target) {
        super(name, 256, dclass, ttl);
        this.priority = URIRecord.checkU16("priority", priority);
        this.weight = URIRecord.checkU16("weight", weight);
        try {
            this.target = URIRecord.byteArrayFromString(target);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.priority = in.readU16();
        this.weight = in.readU16();
        this.target = in.readCountedString();
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.priority = st.getUInt16();
        this.weight = st.getUInt16();
        try {
            this.target = URIRecord.byteArrayFromString(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.priority + " ");
        sb.append(this.weight + " ");
        sb.append(URIRecord.byteArrayToString(this.target, true));
        return sb.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getTarget() {
        return URIRecord.byteArrayToString(this.target, false);
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU16(this.priority);
        out.writeU16(this.weight);
        out.writeCountedString(this.target);
    }
}

