/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Options;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Rcode;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Tokenizer;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.utils.base64;

public class TSIGRecord
extends Record {
    private static final long serialVersionUID = -88820909016649306L;
    private Name alg;
    private Date timeSigned;
    private int fudge;
    private byte[] signature;
    private int originalID;
    private int error;
    private byte[] other;

    TSIGRecord() {
    }

    Record getObject() {
        return new TSIGRecord();
    }

    public TSIGRecord(Name name, int dclass, long ttl, Name alg, Date timeSigned, int fudge, byte[] signature, int originalID, int error, byte[] other) {
        super(name, 250, dclass, ttl);
        this.alg = TSIGRecord.checkName("alg", alg);
        this.timeSigned = timeSigned;
        this.fudge = TSIGRecord.checkU16("fudge", fudge);
        this.signature = signature;
        this.originalID = TSIGRecord.checkU16("originalID", originalID);
        this.error = TSIGRecord.checkU16("error", error);
        this.other = other;
    }

    void rrFromWire(DNSInput in) throws IOException {
        this.alg = new Name(in);
        long timeHigh = in.readU16();
        long timeLow = in.readU32();
        long time = (timeHigh << 32) + timeLow;
        this.timeSigned = new Date(time * 1000L);
        this.fudge = in.readU16();
        int sigLen = in.readU16();
        this.signature = in.readByteArray(sigLen);
        this.originalID = in.readU16();
        this.error = in.readU16();
        int otherLen = in.readU16();
        this.other = (byte[])(otherLen > 0 ? in.readByteArray(otherLen) : null);
    }

    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for TSIG");
    }

    String rrToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.alg);
        sb.append(" ");
        if (Options.check("multiline")) {
            sb.append("(\n\t");
        }
        sb.append(this.timeSigned.getTime() / 1000L);
        sb.append(" ");
        sb.append(this.fudge);
        sb.append(" ");
        sb.append(this.signature.length);
        if (Options.check("multiline")) {
            sb.append("\n");
            sb.append(base64.formatString(this.signature, 64, "\t", false));
        } else {
            sb.append(" ");
            sb.append(base64.toString(this.signature));
        }
        sb.append(" ");
        sb.append(Rcode.TSIGstring(this.error));
        sb.append(" ");
        if (this.other == null) {
            sb.append(0);
        } else {
            sb.append(this.other.length);
            if (Options.check("multiline")) {
                sb.append("\n\n\n\t");
            } else {
                sb.append(" ");
            }
            if (this.error == 18) {
                if (this.other.length != 6) {
                    sb.append("<invalid BADTIME other data>");
                } else {
                    long time = ((long)(this.other[0] & 0xFF) << 40) + ((long)(this.other[1] & 0xFF) << 32) + (long)((this.other[2] & 0xFF) << 24) + (long)((this.other[3] & 0xFF) << 16) + (long)((this.other[4] & 0xFF) << 8) + (long)(this.other[5] & 0xFF);
                    sb.append("<server time: ");
                    sb.append(new Date(time * 1000L));
                    sb.append(">");
                }
            } else {
                sb.append("<");
                sb.append(base64.toString(this.other));
                sb.append(">");
            }
        }
        if (Options.check("multiline")) {
            sb.append(" )");
        }
        return sb.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFudge() {
        return this.fudge;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.alg.toWire(out, null, canonical);
        long time = this.timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeU16(timeHigh);
        out.writeU32(timeLow);
        out.writeU16(this.fudge);
        out.writeU16(this.signature.length);
        out.writeByteArray(this.signature);
        out.writeU16(this.originalID);
        out.writeU16(this.error);
        if (this.other != null) {
            out.writeU16(this.other.length);
            out.writeByteArray(this.other);
        } else {
            out.writeU16(0);
        }
    }
}

