/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Flags;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Opcode;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Rcode;
import org.apache.hadoop.hbase.shaded.org.xbill.DNS.Section;

public class Header
implements Cloneable {
    private int id;
    private int flags;
    private int[] counts;
    private static Random random = new Random();
    public static final int LENGTH = 12;

    private void init() {
        this.counts = new int[4];
        this.flags = 0;
        this.id = -1;
    }

    public Header(int id) {
        this.init();
        this.setID(id);
    }

    public Header() {
        this.init();
    }

    Header(DNSInput in) throws IOException {
        this(in.readU16());
        this.flags = in.readU16();
        for (int i = 0; i < this.counts.length; ++i) {
            this.counts[i] = in.readU16();
        }
    }

    public Header(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    void toWire(DNSOutput out) {
        out.writeU16(this.getID());
        out.writeU16(this.flags);
        for (int i = 0; i < this.counts.length; ++i) {
            out.writeU16(this.counts[i]);
        }
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        return out.toByteArray();
    }

    private static boolean validFlag(int bit) {
        return bit >= 0 && bit <= 15 && Flags.isFlag(bit);
    }

    private static void checkFlag(int bit) {
        if (!Header.validFlag(bit)) {
            throw new IllegalArgumentException("invalid flag bit " + bit);
        }
    }

    static int setFlag(int flags, int bit, boolean value) {
        Header.checkFlag(bit);
        if (value) {
            return flags |= 1 << 15 - bit;
        }
        return flags &= ~(1 << 15 - bit);
    }

    public void setFlag(int bit) {
        Header.checkFlag(bit);
        this.flags = Header.setFlag(this.flags, bit, true);
    }

    public void unsetFlag(int bit) {
        Header.checkFlag(bit);
        this.flags = Header.setFlag(this.flags, bit, false);
    }

    public boolean getFlag(int bit) {
        Header.checkFlag(bit);
        return (this.flags & 1 << 15 - bit) != 0;
    }

    boolean[] getFlags() {
        boolean[] array = new boolean[16];
        for (int i = 0; i < array.length; ++i) {
            if (!Header.validFlag(i)) continue;
            array[i] = this.getFlag(i);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID() {
        if (this.id >= 0) {
            return this.id;
        }
        Header header = this;
        synchronized (header) {
            if (this.id < 0) {
                this.id = random.nextInt(65535);
            }
            return this.id;
        }
    }

    public void setID(int id) {
        if (id < 0 || id > 65535) {
            throw new IllegalArgumentException("DNS message ID " + id + " is out of range");
        }
        this.id = id;
    }

    public void setRcode(int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("DNS Rcode " + value + " is out of range");
        }
        this.flags &= 0xFFFFFFF0;
        this.flags |= value;
    }

    public int getRcode() {
        return this.flags & 0xF;
    }

    public void setOpcode(int value) {
        if (value < 0 || value > 15) {
            throw new IllegalArgumentException("DNS Opcode " + value + "is out of range");
        }
        this.flags &= 0x87FF;
        this.flags |= value << 11;
    }

    public int getOpcode() {
        return this.flags >> 11 & 0xF;
    }

    void setCount(int field, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("DNS section count " + value + " is out of range");
        }
        this.counts[field] = value;
    }

    void incCount(int field) {
        if (this.counts[field] == 65535) {
            throw new IllegalStateException("DNS section count cannot be incremented");
        }
        int n = field;
        this.counts[n] = this.counts[n] + 1;
    }

    void decCount(int field) {
        if (this.counts[field] == 0) {
            throw new IllegalStateException("DNS section count cannot be decremented");
        }
        int n = field;
        this.counts[n] = this.counts[n] - 1;
    }

    public int getCount(int field) {
        return this.counts[field];
    }

    int getFlagsByte() {
        return this.flags;
    }

    public String printFlags() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            if (!Header.validFlag(i) || !this.getFlag(i)) continue;
            sb.append(Flags.string(i));
            sb.append(" ");
        }
        return sb.toString();
    }

    String toStringWithRcode(int newrcode) {
        StringBuffer sb = new StringBuffer();
        sb.append(";; ->>HEADER<<- ");
        sb.append("opcode: " + Opcode.string(this.getOpcode()));
        sb.append(", status: " + Rcode.string(newrcode));
        sb.append(", id: " + this.getID());
        sb.append("\n");
        sb.append(";; flags: " + this.printFlags());
        sb.append("; ");
        for (int i = 0; i < 4; ++i) {
            sb.append(Section.string(i) + ": " + this.getCount(i) + " ");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    public Object clone() {
        Header h2 = new Header();
        h2.id = this.id;
        h2.flags = this.flags;
        System.arraycopy(this.counts, 0, h2.counts, 0, this.counts.length);
        return h2;
    }
}

