/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type;

import java.io.IOException;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1Item;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.hadoop.hbase.shaded.org.apache.kerby.asn1.type.Asn1Simple;

public class Asn1OctetString
extends Asn1Simple<byte[]> {
    public Asn1OctetString() {
        this((byte[])null);
    }

    public Asn1OctetString(byte[] value) {
        super(UniversalTag.OCTET_STRING, value);
    }

    @Override
    protected byte[] encodeBody() {
        return (byte[])this.getValue();
    }

    @Override
    protected int encodingBodyLength() {
        if (this.getValue() != null) {
            return ((byte[])this.getValue()).length;
        }
        return 0;
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        Asn1Item item = (Asn1Item)parseResult;
        this.setValue(item.readBodyBytes());
    }

    @Override
    public String toString() {
        String typeStr = this.tag().typeStr() + " [" + "tag=" + this.tag() + ", len=" + this.getHeaderLength() + "+" + this.getBodyLength() + "] ";
        byte[] valueBytes = (byte[])this.getValue();
        String valueStr = "<null>";
        if (valueBytes != null) {
            valueStr = "<" + valueBytes.length + " octets>";
        }
        return typeStr + valueStr;
    }
}

