/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.CreateMode;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.WatchedEvent;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeper;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.ACL;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.data.Stat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ActiveStandbyElector
implements AsyncCallback.StatCallback,
AsyncCallback.StringCallback {
    @VisibleForTesting
    protected static final String LOCK_FILENAME = "ActiveStandbyElectorLock";
    @VisibleForTesting
    protected static final String BREADCRUMB_FILENAME = "ActiveBreadCrumb";
    public static final Logger LOG = LoggerFactory.getLogger(ActiveStandbyElector.class);
    private static final int SLEEP_AFTER_FAILURE_TO_BECOME_ACTIVE = 1000;
    private State state = State.INIT;
    private int createRetryCount = 0;
    private int statRetryCount = 0;
    private ZooKeeper zkClient;
    private WatcherWithClientRef watcher;
    private ConnectionState zkConnectionState = ConnectionState.TERMINATED;
    private final ActiveStandbyElectorCallback appClient;
    private final String zkHostPort;
    private final int zkSessionTimeout;
    private final List<ACL> zkAcl;
    private final List<ZKUtil.ZKAuthInfo> zkAuthInfo;
    private byte[] appData;
    private final String zkLockFilePath;
    private final String zkBreadCrumbPath;
    private final String znodeWorkingDir;
    private final int maxRetryNum;
    private Lock sessionReestablishLockForTests = new ReentrantLock();
    private boolean wantToBeInElection;
    private boolean monitorLockNodePending = false;
    private ZooKeeper monitorLockNodeClient;

    public ActiveStandbyElector(String zookeeperHostPorts, int zookeeperSessionTimeout, String parentZnodeName, List<ACL> acl, List<ZKUtil.ZKAuthInfo> authInfo, ActiveStandbyElectorCallback app, int maxRetryNum) throws IOException, HadoopIllegalArgumentException, KeeperException {
        this(zookeeperHostPorts, zookeeperSessionTimeout, parentZnodeName, acl, authInfo, app, maxRetryNum, true);
    }

    public ActiveStandbyElector(String zookeeperHostPorts, int zookeeperSessionTimeout, String parentZnodeName, List<ACL> acl, List<ZKUtil.ZKAuthInfo> authInfo, ActiveStandbyElectorCallback app, int maxRetryNum, boolean failFast) throws IOException, HadoopIllegalArgumentException, KeeperException {
        if (app == null || acl == null || parentZnodeName == null || zookeeperHostPorts == null || zookeeperSessionTimeout <= 0) {
            throw new HadoopIllegalArgumentException("Invalid argument");
        }
        this.zkHostPort = zookeeperHostPorts;
        this.zkSessionTimeout = zookeeperSessionTimeout;
        this.zkAcl = acl;
        this.zkAuthInfo = authInfo;
        this.appClient = app;
        this.znodeWorkingDir = parentZnodeName;
        this.zkLockFilePath = this.znodeWorkingDir + "/" + LOCK_FILENAME;
        this.zkBreadCrumbPath = this.znodeWorkingDir + "/" + BREADCRUMB_FILENAME;
        this.maxRetryNum = maxRetryNum;
        if (failFast) {
            this.createConnection();
        } else {
            this.reEstablishSession();
        }
    }

    public synchronized void joinElection(byte[] data) throws HadoopIllegalArgumentException {
        if (data == null) {
            throw new HadoopIllegalArgumentException("data cannot be null");
        }
        if (this.wantToBeInElection) {
            LOG.info("Already in election. Not re-connecting.");
            return;
        }
        this.appData = new byte[data.length];
        System.arraycopy(data, 0, this.appData, 0, data.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting active election for " + this);
        }
        this.joinElectionInternal();
    }

    public synchronized boolean parentZNodeExists() throws IOException, InterruptedException {
        Preconditions.checkState(this.zkClient != null);
        try {
            return this.zkClient.exists(this.znodeWorkingDir, false) != null;
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't determine existence of znode '" + this.znodeWorkingDir + "'", e);
        }
    }

    public synchronized void ensureParentZNode() throws IOException, InterruptedException, KeeperException {
        String[] pathParts;
        Preconditions.checkState(!this.wantToBeInElection, "ensureParentZNode() may not be called while in the election");
        if (this.zkClient == null) {
            this.createConnection();
        }
        Preconditions.checkArgument((pathParts = this.znodeWorkingDir.split("/")).length >= 1 && pathParts[0].isEmpty(), "Invalid path: %s", (Object)this.znodeWorkingDir);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append("/").append(pathParts[i]);
            String prefixPath = sb.toString();
            LOG.debug("Ensuring existence of " + prefixPath);
            try {
                this.createWithRetries(prefixPath, new byte[0], this.zkAcl, CreateMode.PERSISTENT);
                continue;
            }
            catch (KeeperException e) {
                if (ActiveStandbyElector.isNodeExists(e.code())) {
                    try {
                        this.setAclsWithRetries(prefixPath);
                        continue;
                    }
                    catch (KeeperException e1) {
                        throw new IOException("Couldn't set ACLs on parent ZNode: " + prefixPath, e1);
                    }
                }
                throw new IOException("Couldn't create " + prefixPath, e);
            }
        }
        LOG.info("Successfully created " + this.znodeWorkingDir + " in ZK.");
    }

    public synchronized void clearParentZNode() throws IOException, InterruptedException {
        Preconditions.checkState(!this.wantToBeInElection, "clearParentZNode() may not be called while in the election");
        try {
            LOG.info("Recursively deleting " + this.znodeWorkingDir + " from ZK...");
            this.zkDoWithRetries(new ZKAction<Void>(){

                @Override
                public Void run() throws KeeperException, InterruptedException {
                    ZKUtil.deleteRecursive(ActiveStandbyElector.this.zkClient, ActiveStandbyElector.this.znodeWorkingDir);
                    return null;
                }
            });
        }
        catch (KeeperException e) {
            throw new IOException("Couldn't clear parent znode " + this.znodeWorkingDir, e);
        }
        LOG.info("Successfully deleted " + this.znodeWorkingDir + " from ZK.");
    }

    public synchronized void quitElection(boolean needFence) {
        LOG.info("Yielding from election");
        if (!needFence && this.state == State.ACTIVE) {
            this.tryDeleteOwnBreadCrumbNode();
        }
        this.reset();
        this.wantToBeInElection = false;
    }

    public synchronized byte[] getActiveData() throws ActiveNotFoundException, KeeperException, InterruptedException, IOException {
        try {
            if (this.zkClient == null) {
                this.createConnection();
            }
            Stat stat = new Stat();
            return this.getDataWithRetries(this.zkLockFilePath, false, stat);
        }
        catch (KeeperException e) {
            KeeperException.Code code = e.code();
            if (ActiveStandbyElector.isNodeDoesNotExist(code)) {
                throw new ActiveNotFoundException();
            }
            throw e;
        }
    }

    @Override
    public synchronized void processResult(int rc, String path, Object ctx, String name) {
        KeeperException.Code code;
        if (this.isStaleClient(ctx)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CreateNode result: " + rc + " for path: " + path + " connectionState: " + (Object)((Object)this.zkConnectionState) + "  for " + this);
        }
        if (ActiveStandbyElector.isSuccess(code = KeeperException.Code.get(rc))) {
            if (this.becomeActive()) {
                this.monitorActiveStatus();
            } else {
                this.reJoinElectionAfterFailureToBecomeActive();
            }
            return;
        }
        if (ActiveStandbyElector.isNodeExists(code)) {
            if (this.createRetryCount == 0) {
                this.becomeStandby();
            }
            this.monitorActiveStatus();
            return;
        }
        String errorMessage = "Received create error from Zookeeper. code:" + code.toString() + " for path " + path;
        LOG.debug(errorMessage);
        if (ActiveStandbyElector.shouldRetry(code)) {
            if (this.createRetryCount < this.maxRetryNum) {
                LOG.debug("Retrying createNode createRetryCount: " + this.createRetryCount);
                ++this.createRetryCount;
                this.createLockNodeAsync();
                return;
            }
            errorMessage = errorMessage + ". Not retrying further znode create connection errors.";
        } else if (ActiveStandbyElector.isSessionExpired(code)) {
            LOG.warn("Lock acquisition failed because session was lost");
            return;
        }
        this.fatalError(errorMessage);
    }

    @Override
    public synchronized void processResult(int rc, String path, Object ctx, Stat stat) {
        KeeperException.Code code;
        if (this.isStaleClient(ctx)) {
            return;
        }
        this.monitorLockNodePending = false;
        assert (this.wantToBeInElection) : "Got a StatNode result after quitting election";
        if (LOG.isDebugEnabled()) {
            LOG.debug("StatNode result: " + rc + " for path: " + path + " connectionState: " + (Object)((Object)this.zkConnectionState) + " for " + this);
        }
        if (ActiveStandbyElector.isSuccess(code = KeeperException.Code.get(rc))) {
            if (stat.getEphemeralOwner() == this.zkClient.getSessionId()) {
                if (!this.becomeActive()) {
                    this.reJoinElectionAfterFailureToBecomeActive();
                }
            } else {
                this.becomeStandby();
            }
            return;
        }
        if (ActiveStandbyElector.isNodeDoesNotExist(code)) {
            this.enterNeutralMode();
            this.joinElectionInternal();
            return;
        }
        String errorMessage = "Received stat error from Zookeeper. code:" + code.toString();
        LOG.debug(errorMessage);
        if (ActiveStandbyElector.shouldRetry(code)) {
            if (this.statRetryCount < this.maxRetryNum) {
                ++this.statRetryCount;
                this.monitorLockNodeAsync();
                return;
            }
            errorMessage = errorMessage + ". Not retrying further znode monitoring connection errors.";
        } else if (ActiveStandbyElector.isSessionExpired(code)) {
            LOG.warn("Lock monitoring failed because session was lost");
            return;
        }
        this.fatalError(errorMessage);
    }

    private void reJoinElectionAfterFailureToBecomeActive() {
        this.reJoinElection(1000);
    }

    synchronized void processWatchEvent(ZooKeeper zk, WatchedEvent event) {
        Watcher.Event.EventType eventType = event.getType();
        if (this.isStaleClient(zk)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Watcher event type: " + (Object)((Object)eventType) + " with state:" + (Object)((Object)event.getState()) + " for path:" + event.getPath() + " connectionState: " + (Object)((Object)this.zkConnectionState) + " for " + this);
        }
        if (eventType == Watcher.Event.EventType.None) {
            switch (event.getState()) {
                case SyncConnected: {
                    LOG.info("Session connected.");
                    ConnectionState prevConnectionState = this.zkConnectionState;
                    this.zkConnectionState = ConnectionState.CONNECTED;
                    if (prevConnectionState != ConnectionState.DISCONNECTED || !this.wantToBeInElection) break;
                    this.monitorActiveStatus();
                    break;
                }
                case Disconnected: {
                    LOG.info("Session disconnected. Entering neutral mode...");
                    this.zkConnectionState = ConnectionState.DISCONNECTED;
                    this.enterNeutralMode();
                    break;
                }
                case Expired: {
                    LOG.info("Session expired. Entering neutral mode and rejoining...");
                    this.enterNeutralMode();
                    this.reJoinElection(0);
                    break;
                }
                case SaslAuthenticated: {
                    LOG.info("Successfully authenticated to ZooKeeper using SASL.");
                    break;
                }
                default: {
                    this.fatalError("Unexpected Zookeeper watch event state: " + (Object)((Object)event.getState()));
                }
            }
            return;
        }
        String path = event.getPath();
        if (path != null) {
            switch (eventType) {
                case NodeDeleted: {
                    if (this.state == State.ACTIVE) {
                        this.enterNeutralMode();
                    }
                    this.joinElectionInternal();
                    break;
                }
                case NodeDataChanged: {
                    this.monitorActiveStatus();
                    break;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unexpected node event: " + (Object)((Object)eventType) + " for path: " + path);
                    }
                    this.monitorActiveStatus();
                }
            }
            return;
        }
        this.fatalError("Unexpected watch error from Zookeeper");
    }

    protected synchronized ZooKeeper connectToZooKeeper() throws IOException, KeeperException {
        this.watcher = new WatcherWithClientRef();
        ZooKeeper zk = this.createZooKeeper();
        this.watcher.setZooKeeperRef(zk);
        this.watcher.waitForZKConnectionEvent(this.zkSessionTimeout);
        for (ZKUtil.ZKAuthInfo auth : this.zkAuthInfo) {
            zk.addAuthInfo(auth.getScheme(), auth.getAuth());
        }
        return zk;
    }

    protected ZooKeeper createZooKeeper() throws IOException {
        return new ZooKeeper(this.zkHostPort, this.zkSessionTimeout, this.watcher);
    }

    private void fatalError(String errorMessage) {
        LOG.error(errorMessage);
        this.reset();
        this.appClient.notifyFatalError(errorMessage);
    }

    private void monitorActiveStatus() {
        assert (this.wantToBeInElection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Monitoring active leader for " + this);
        }
        this.statRetryCount = 0;
        this.monitorLockNodeAsync();
    }

    private void joinElectionInternal() {
        Preconditions.checkState(this.appData != null, "trying to join election without any app data");
        if (this.zkClient == null && !this.reEstablishSession()) {
            this.fatalError("Failed to reEstablish connection with ZooKeeper");
            return;
        }
        this.createRetryCount = 0;
        this.wantToBeInElection = true;
        this.createLockNodeAsync();
    }

    private void reJoinElection(int sleepTime) {
        LOG.info("Trying to re-establish ZK session");
        this.sessionReestablishLockForTests.lock();
        try {
            this.terminateConnection();
            this.sleepFor(sleepTime);
            if (this.appData != null) {
                this.joinElectionInternal();
            } else {
                LOG.info("Not joining election since service has not yet been reported as healthy.");
            }
        }
        finally {
            this.sessionReestablishLockForTests.unlock();
        }
    }

    @VisibleForTesting
    protected void sleepFor(int sleepMs) {
        if (sleepMs > 0) {
            try {
                Thread.sleep(sleepMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    void preventSessionReestablishmentForTests() {
        this.sessionReestablishLockForTests.lock();
    }

    @VisibleForTesting
    void allowSessionReestablishmentForTests() {
        this.sessionReestablishLockForTests.unlock();
    }

    @VisibleForTesting
    synchronized long getZKSessionIdForTests() {
        if (this.zkClient != null) {
            return this.zkClient.getSessionId();
        }
        return -1L;
    }

    @VisibleForTesting
    synchronized State getStateForTests() {
        return this.state;
    }

    @VisibleForTesting
    synchronized boolean isMonitorLockNodePending() {
        return this.monitorLockNodePending;
    }

    private boolean reEstablishSession() {
        boolean success = false;
        for (int connectionRetryCount = 0; !success && connectionRetryCount < this.maxRetryNum; ++connectionRetryCount) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Establishing zookeeper connection for " + this);
            }
            try {
                this.createConnection();
                success = true;
                continue;
            }
            catch (IOException e) {
                LOG.warn(e.toString());
                this.sleepFor(5000);
                continue;
            }
            catch (KeeperException e) {
                LOG.warn(e.toString());
                this.sleepFor(5000);
            }
        }
        return success;
    }

    private void createConnection() throws IOException, KeeperException {
        if (this.zkClient != null) {
            try {
                this.zkClient.close();
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing ZK", e);
            }
            this.zkClient = null;
            this.watcher = null;
        }
        this.zkClient = this.connectToZooKeeper();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new connection for " + this);
        }
    }

    @InterfaceAudience.Private
    public synchronized void terminateConnection() {
        if (this.zkClient == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating ZK connection for " + this);
        }
        ZooKeeper tempZk = this.zkClient;
        this.zkClient = null;
        this.watcher = null;
        try {
            tempZk.close();
        }
        catch (InterruptedException e) {
            LOG.warn(e.toString());
        }
        this.zkConnectionState = ConnectionState.TERMINATED;
        this.wantToBeInElection = false;
    }

    private void reset() {
        this.state = State.INIT;
        this.terminateConnection();
    }

    private boolean becomeActive() {
        assert (this.wantToBeInElection);
        if (this.state == State.ACTIVE) {
            return true;
        }
        try {
            Stat oldBreadcrumbStat = this.fenceOldActive();
            this.writeBreadCrumbNode(oldBreadcrumbStat);
            LOG.debug("Becoming active for {}", (Object)this);
            this.appClient.becomeActive();
            this.state = State.ACTIVE;
            return true;
        }
        catch (Exception e) {
            LOG.warn("Exception handling the winning of election", (Throwable)e);
            return false;
        }
    }

    private void writeBreadCrumbNode(Stat oldBreadcrumbStat) throws KeeperException, InterruptedException {
        Preconditions.checkState(this.appData != null, "no appdata");
        LOG.info("Writing znode {} to indicate that the local node is the most recent active...", (Object)this.zkBreadCrumbPath);
        if (oldBreadcrumbStat == null) {
            this.createWithRetries(this.zkBreadCrumbPath, this.appData, this.zkAcl, CreateMode.PERSISTENT);
        } else {
            this.setDataWithRetries(this.zkBreadCrumbPath, this.appData, oldBreadcrumbStat.getVersion());
        }
    }

    private void tryDeleteOwnBreadCrumbNode() {
        assert (this.state == State.ACTIVE);
        LOG.info("Deleting bread-crumb of active node...");
        Stat stat = new Stat();
        byte[] data = null;
        try {
            data = this.zkClient.getData(this.zkBreadCrumbPath, false, stat);
            if (!Arrays.equals(data, this.appData)) {
                throw new IllegalStateException("We thought we were active, but in fact the active znode had the wrong data: " + StringUtils.byteToHexString(data) + " (stat=" + stat + ")");
            }
            this.deleteWithRetries(this.zkBreadCrumbPath, stat.getVersion());
        }
        catch (Exception e) {
            LOG.warn("Unable to delete our own bread-crumb of being active at {}.. Expecting to be fenced by the next active.", (Object)this.zkBreadCrumbPath, (Object)e);
        }
    }

    private Stat fenceOldActive() throws InterruptedException, KeeperException {
        byte[] data;
        final Stat stat = new Stat();
        LOG.info("Checking for any old active which needs to be fenced...");
        try {
            data = this.zkDoWithRetries(new ZKAction<byte[]>(){

                @Override
                public byte[] run() throws KeeperException, InterruptedException {
                    return ActiveStandbyElector.this.zkClient.getData(ActiveStandbyElector.this.zkBreadCrumbPath, false, stat);
                }
            });
        }
        catch (KeeperException ke) {
            if (ActiveStandbyElector.isNodeDoesNotExist(ke.code())) {
                LOG.info("No old node to fence");
                return null;
            }
            throw ke;
        }
        LOG.info("Old node exists: {}", (Object)StringUtils.byteToHexString(data));
        if (Arrays.equals(data, this.appData)) {
            LOG.info("But old node has our own data, so don't need to fence it.");
        } else {
            this.appClient.fenceOldActive(data);
        }
        return stat;
    }

    private void becomeStandby() {
        if (this.state != State.STANDBY) {
            LOG.debug("Becoming standby for {}", (Object)this);
            this.state = State.STANDBY;
            this.appClient.becomeStandby();
        }
    }

    private void enterNeutralMode() {
        if (this.state != State.NEUTRAL) {
            LOG.debug("Entering neutral mode for {}", (Object)this);
            this.state = State.NEUTRAL;
            this.appClient.enterNeutralMode();
        }
    }

    private void createLockNodeAsync() {
        this.zkClient.create(this.zkLockFilePath, this.appData, this.zkAcl, CreateMode.EPHEMERAL, this, (Object)this.zkClient);
    }

    private void monitorLockNodeAsync() {
        if (this.monitorLockNodePending && this.monitorLockNodeClient == this.zkClient) {
            LOG.info("Ignore duplicate monitor lock-node request.");
            return;
        }
        this.monitorLockNodePending = true;
        this.monitorLockNodeClient = this.zkClient;
        this.zkClient.exists(this.zkLockFilePath, this.watcher, (AsyncCallback.StatCallback)this, (Object)this.zkClient);
    }

    private String createWithRetries(final String path, final byte[] data, final List<ACL> acl, final CreateMode mode) throws InterruptedException, KeeperException {
        return this.zkDoWithRetries(new ZKAction<String>(){

            @Override
            public String run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.create(path, data, acl, mode);
            }
        });
    }

    private byte[] getDataWithRetries(final String path, final boolean watch, final Stat stat) throws InterruptedException, KeeperException {
        return this.zkDoWithRetries(new ZKAction<byte[]>(){

            @Override
            public byte[] run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.getData(path, watch, stat);
            }
        });
    }

    private Stat setDataWithRetries(final String path, final byte[] data, final int version) throws InterruptedException, KeeperException {
        return this.zkDoWithRetries(new ZKAction<Stat>(){

            @Override
            public Stat run() throws KeeperException, InterruptedException {
                return ActiveStandbyElector.this.zkClient.setData(path, data, version);
            }
        });
    }

    private void deleteWithRetries(final String path, final int version) throws KeeperException, InterruptedException {
        this.zkDoWithRetries(new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                ActiveStandbyElector.this.zkClient.delete(path, version);
                return null;
            }
        });
    }

    private void setAclsWithRetries(final String path) throws KeeperException, InterruptedException {
        final Stat stat = new Stat();
        this.zkDoWithRetries(new ZKAction<Void>(){

            @Override
            public Void run() throws KeeperException, InterruptedException {
                List<ACL> acl = ActiveStandbyElector.this.zkClient.getACL(path, stat);
                if (acl == null || !acl.containsAll(ActiveStandbyElector.this.zkAcl) || !ActiveStandbyElector.this.zkAcl.containsAll(acl)) {
                    ActiveStandbyElector.this.zkClient.setACL(path, ActiveStandbyElector.this.zkAcl, stat.getAversion());
                }
                return null;
            }
        }, KeeperException.Code.BADVERSION);
    }

    private <T> T zkDoWithRetries(ZKAction<T> action) throws KeeperException, InterruptedException {
        return this.zkDoWithRetries(action, null);
    }

    private <T> T zkDoWithRetries(ZKAction<T> action, KeeperException.Code retryCode) throws KeeperException, InterruptedException {
        int retry = 0;
        while (true) {
            try {
                return action.run();
            }
            catch (KeeperException ke) {
                if ((ActiveStandbyElector.shouldRetry(ke.code()) || ActiveStandbyElector.shouldRetry(ke.code(), retryCode)) && ++retry < this.maxRetryNum) continue;
                throw ke;
            }
            break;
        }
    }

    private synchronized boolean isStaleClient(Object ctx) {
        Preconditions.checkNotNull(ctx);
        if (this.zkClient != (ZooKeeper)ctx) {
            LOG.warn("Ignoring stale result from old client with sessionId {}", (Object)String.format("0x%08x", ((ZooKeeper)ctx).getSessionId()));
            return true;
        }
        return false;
    }

    private static boolean isSuccess(KeeperException.Code code) {
        return code == KeeperException.Code.OK;
    }

    private static boolean isNodeExists(KeeperException.Code code) {
        return code == KeeperException.Code.NODEEXISTS;
    }

    private static boolean isNodeDoesNotExist(KeeperException.Code code) {
        return code == KeeperException.Code.NONODE;
    }

    private static boolean isSessionExpired(KeeperException.Code code) {
        return code == KeeperException.Code.SESSIONEXPIRED;
    }

    private static boolean shouldRetry(KeeperException.Code code) {
        return code == KeeperException.Code.CONNECTIONLOSS || code == KeeperException.Code.OPERATIONTIMEOUT;
    }

    private static boolean shouldRetry(KeeperException.Code code, KeeperException.Code retryIfCode) {
        return retryIfCode == null ? false : retryIfCode == code;
    }

    public String toString() {
        return "elector id=" + System.identityHashCode(this) + " appData=" + (this.appData == null ? "null" : StringUtils.byteToHexString(this.appData)) + " cb=" + this.appClient;
    }

    public String getHAZookeeperConnectionState() {
        return this.zkConnectionState.name();
    }

    private final class WatcherWithClientRef
    implements Watcher {
        private ZooKeeper zk;
        private CountDownLatch hasReceivedEvent = new CountDownLatch(1);
        private CountDownLatch hasSetZooKeeper = new CountDownLatch(1);

        private WatcherWithClientRef() {
        }

        private void waitForZKConnectionEvent(int connectionTimeoutMs) throws KeeperException, IOException {
            try {
                if (!this.hasReceivedEvent.await(connectionTimeoutMs, TimeUnit.MILLISECONDS)) {
                    LOG.error("Connection timed out: couldn't connect to ZooKeeper in {} milliseconds", (Object)connectionTimeoutMs);
                    this.zk.close();
                    throw KeeperException.create(KeeperException.Code.CONNECTIONLOSS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted when connecting to zookeeper server", e);
            }
        }

        private void setZooKeeperRef(ZooKeeper zk) {
            Preconditions.checkState(this.zk == null, "zk already set -- must be set exactly once");
            this.zk = zk;
            this.hasSetZooKeeper.countDown();
        }

        @Override
        public void process(WatchedEvent event) {
            this.hasReceivedEvent.countDown();
            try {
                if (!this.hasSetZooKeeper.await(ActiveStandbyElector.this.zkSessionTimeout, TimeUnit.MILLISECONDS)) {
                    LOG.debug("Event received with stale zk");
                }
                ActiveStandbyElector.this.processWatchEvent(this.zk, event);
            }
            catch (Throwable t) {
                ActiveStandbyElector.this.fatalError("Failed to process watcher event " + event + ": " + StringUtils.stringifyException(t));
            }
        }
    }

    private static interface ZKAction<T> {
        public T run() throws KeeperException, InterruptedException;
    }

    public static class ActiveNotFoundException
    extends Exception {
        private static final long serialVersionUID = 3505396722342846462L;
    }

    static enum State {
        INIT,
        ACTIVE,
        STANDBY,
        NEUTRAL;

    }

    private static enum ConnectionState {
        DISCONNECTED,
        CONNECTED,
        TERMINATED;

    }

    public static interface ActiveStandbyElectorCallback {
        public void becomeActive() throws ServiceFailedException;

        public void becomeStandby();

        public void enterNeutralMode();

        public void notifyFatalError(String var1);

        public void fenceOldActive(byte[] var1);
    }
}

