/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BlockLocation
implements Serializable {
    private static final long serialVersionUID = 580415341L;
    private String[] hosts;
    private String[] cachedHosts;
    private String[] names;
    private String[] topologyPaths;
    private String[] storageIds;
    private StorageType[] storageTypes;
    private long offset;
    private long length;
    private boolean corrupt;
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final StorageType[] EMPTY_STORAGE_TYPE_ARRAY = new StorageType[0];

    public BlockLocation() {
        this(EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, 0L, 0L);
    }

    public BlockLocation(BlockLocation that) {
        this.hosts = that.hosts;
        this.cachedHosts = that.cachedHosts;
        this.names = that.names;
        this.topologyPaths = that.topologyPaths;
        this.offset = that.offset;
        this.length = that.length;
        this.corrupt = that.corrupt;
        this.storageIds = that.storageIds;
        this.storageTypes = that.storageTypes;
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length) {
        this(names, hosts, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length, boolean corrupt) {
        this(names, hosts, null, offset, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length) {
        this(names, hosts, topologyPaths, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length, boolean corrupt) {
        this(names, hosts, null, topologyPaths, offset, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, long offset, long length, boolean corrupt) {
        this(names, hosts, cachedHosts, topologyPaths, null, null, offset, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, String[] storageIds, StorageType[] storageTypes, long offset, long length, boolean corrupt) {
        this.names = names == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(names);
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(hosts);
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(cachedHosts);
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(topologyPaths);
        this.storageIds = storageIds == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(storageIds);
        this.storageTypes = storageTypes == null ? EMPTY_STORAGE_TYPE_ARRAY : storageTypes;
        this.offset = offset;
        this.length = length;
        this.corrupt = corrupt;
    }

    public String[] getHosts() throws IOException {
        return this.hosts;
    }

    public String[] getCachedHosts() {
        return this.cachedHosts;
    }

    public String[] getNames() throws IOException {
        return this.names;
    }

    public String[] getTopologyPaths() throws IOException {
        return this.topologyPaths;
    }

    public String[] getStorageIds() {
        return this.storageIds;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(hosts);
    }

    public void setCachedHosts(String[] cachedHosts) {
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(cachedHosts);
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(names);
    }

    public void setTopologyPaths(String[] topologyPaths) throws IOException {
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(topologyPaths);
    }

    public void setStorageIds(String[] storageIds) {
        this.storageIds = storageIds == null ? EMPTY_STR_ARRAY : StringInterner.internStringsInArray(storageIds);
    }

    public void setStorageTypes(StorageType[] storageTypes) {
        this.storageTypes = storageTypes == null ? EMPTY_STORAGE_TYPE_ARRAY : storageTypes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.offset);
        result.append(',');
        result.append(this.length);
        if (this.corrupt) {
            result.append("(corrupt)");
        }
        for (String h2 : this.hosts) {
            result.append(',');
            result.append(h2);
        }
        return result.toString();
    }
}

