/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.utilint;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.SortedSet;

public class FormatUtil {
    private static final ThreadLocal<DecimalFormat> DECIMAL_SCALE0 = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            return new DecimalFormat("###,###,###,###,###,###,###");
        }
    };
    private static final ThreadLocal<DecimalFormat> DECIMAL_SCALE2 = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            return new DecimalFormat("###,###,###,###,###,###,###.##");
        }
    };

    public static DecimalFormat decimalScale0() {
        return DECIMAL_SCALE0.get();
    }

    public static DecimalFormat decimalScale2() {
        return DECIMAL_SCALE2.get();
    }

    public static String asHexString(SortedSet<Long> set) {
        long rstart;
        if (set.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = set.iterator();
        long rend = rstart = ((Long)i.next()).longValue();
        while (i.hasNext()) {
            long f = (Long)i.next();
            if (f == rend + 1L) {
                ++rend;
                continue;
            }
            FormatUtil.flushRange(sb, rstart, rend);
            rstart = rend = f;
        }
        FormatUtil.flushRange(sb, rstart, rend);
        sb.deleteCharAt(0);
        return sb.toString();
    }

    private static void flushRange(StringBuilder sb, long rstart, long rend) {
        if (rstart == -1L) {
            return;
        }
        if (rstart == rend) {
            sb.append(" 0x").append(Long.toHexString(rstart));
        } else {
            sb.append(" 0x").append(Long.toHexString(rstart)).append("-").append("0x").append(Long.toHexString(rend));
        }
    }
}

