/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.Pair;
import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public class DbDeleteReservedFiles {
    private static long ONE_MB = 0x100000L;
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbDeleteReservedFiles.class) + "\n       -h <dir> # environment home directory\n       -s <mb>  # desired size to delete in MB\n       [-l]     # list files only, do not delete\n       [-V]     # print JE version number";
    private File envHome;
    private long deleteMb;
    private boolean list;

    public static void main(String[] args) {
        try {
            DbDeleteReservedFiles util = new DbDeleteReservedFiles(args);
            Pair<Long, SortedMap<File, Long>> result = util.execute();
            util.printResult(result.first(), result.second());
            System.exit(0);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    DbDeleteReservedFiles(String[] args) throws UsageException {
        block12: for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            String val = null;
            if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                val = args[++i];
            }
            switch (name) {
                case "-h": {
                    if (val == null) {
                        throw DbDeleteReservedFiles.usage("No value after -h");
                    }
                    this.envHome = new File(val);
                    continue block12;
                }
                case "-s": {
                    if (val == null) {
                        throw DbDeleteReservedFiles.usage("No value after -s");
                    }
                    try {
                        this.deleteMb = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        throw DbDeleteReservedFiles.usage(val + " is not a number");
                    }
                    if (this.deleteMb > 0L) continue block12;
                    throw DbDeleteReservedFiles.usage(val + " is not a positive integer");
                }
                case "-l": {
                    this.list = true;
                }
            }
        }
        if (this.envHome == null) {
            throw DbDeleteReservedFiles.usage("-h is required");
        }
        if (this.deleteMb == 0L) {
            throw DbDeleteReservedFiles.usage("-s is required");
        }
    }

    Pair<Long, SortedMap<File, Long>> execute() {
        Environment env = new Environment(this.envHome, new EnvironmentConfig().setReadOnly(true));
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        FileManager fileManager = envImpl.getFileManager();
        SortedSet reservedFiles = envImpl.getFileProtector().getReservedFileInfo().second();
        TreeMap<File, Long> filesToDelete = new TreeMap<File, Long>();
        long deleteBytes = 0L;
        for (Long fileNum : reservedFiles) {
            File file = new File(fileManager.getFullFileName(fileNum));
            long len = file.length();
            filesToDelete.put(file, len);
            if ((deleteBytes += len) / ONE_MB < this.deleteMb) continue;
            break;
        }
        env.close();
        if (!this.list) {
            for (File file : filesToDelete.keySet()) {
                file.delete();
            }
        }
        return new Pair<Long, SortedMap<File, Long>>(deleteBytes / ONE_MB, filesToDelete);
    }

    private void printResult(long size, SortedMap<File, Long> files) {
        StringBuilder msg = new StringBuilder(String.format("File          Size (MB) %n", new Object[0]));
        for (Map.Entry<File, Long> entry : files.entrySet()) {
            File file = entry.getKey();
            long len = entry.getValue();
            msg.append(String.format("%s  %,d %n", file.getName(), len / ONE_MB));
        }
        msg.append(String.format("Total size (MB): %,d %n", size));
        if (this.list) {
            msg.append("Files were NOT deleted.");
        } else {
            msg.append("Files were deleted.");
        }
        System.out.println(msg);
    }

    private static UsageException usage(String msg) {
        StringBuilder builder = new StringBuilder();
        if (msg != null) {
            builder.append(msg);
            builder.append(String.format("%n", new Object[0]));
        }
        builder.append(USAGE);
        return new UsageException(builder.toString());
    }

    private static class UsageException
    extends Exception {
        UsageException(String msg) {
            super(msg);
        }
    }
}

