/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.TracerFormatter;
import com.sleepycat.je.utilint.VLSN;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSelector {
    private final Map<Long, PendingInfo> pendingInfoMap;
    private final SortedMap<Long, FileInfo> fileInfoMap;
    private final DateFormat dateFormat = TracerFormatter.makeDateFormat();

    FileSelector() {
        this.fileInfoMap = new TreeMap<Long, FileInfo>();
        this.pendingInfoMap = new HashMap<Long, PendingInfo>();
    }

    synchronized Pair<Long, Integer> selectFileForCleaning(UtilizationCalculator calculator, SortedMap<Long, FileSummary> fileSummaryMap, boolean forceCleaning) {
        Set<Long> toBeCleaned = this.getToBeCleanedFiles();
        if (!toBeCleaned.isEmpty()) {
            Long fileNum = toBeCleaned.iterator().next();
            FileInfo info = this.setStatus(fileNum, FileStatus.BEING_CLEANED);
            return new Pair<Long, Integer>(fileNum, info.requiredUtil);
        }
        Pair<Long, Integer> result = calculator.getBestFile(fileSummaryMap, forceCleaning);
        if (result == null) {
            return null;
        }
        Long fileNum = result.first();
        int requiredUtil = result.second();
        assert (!this.fileInfoMap.containsKey(fileNum));
        FileInfo info = this.setStatus(fileNum, FileStatus.BEING_CLEANED);
        info.requiredUtil = requiredUtil;
        return result;
    }

    private synchronized int getNumberOfFiles(FileStatus status) {
        int count = 0;
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != status) continue;
            ++count;
        }
        return count;
    }

    private synchronized NavigableSet<Long> getFiles(FileStatus status) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (Map.Entry<Long, FileInfo> entry : this.fileInfoMap.entrySet()) {
            if (entry.getValue().status != status) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    private FileInfo setStatus(Long fileNum, FileStatus newStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info == null) {
            info = new FileInfo();
            this.fileInfoMap.put(fileNum, info);
        }
        info.status = newStatus;
        return info;
    }

    private void setStatus(Collection<Long> files, FileStatus newStatus) {
        for (Long fileNum : files) {
            this.setStatus(fileNum, newStatus);
        }
    }

    private void setStatus(FileStatus oldStatus, FileStatus newStatus) {
        for (FileInfo info : this.fileInfoMap.values()) {
            if (info.status != oldStatus) continue;
            info.status = newStatus;
        }
    }

    private boolean checkStatus(Long fileNum, FileStatus expectStatus) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        assert (info != null) : "Expected " + (Object)((Object)expectStatus) + " but was missing";
        assert (info.status == expectStatus) : "Expected " + (Object)((Object)expectStatus) + " but was " + (Object)((Object)FileInfo.access$100(info));
        return true;
    }

    private boolean checkStatus(Collection<Long> files, FileStatus expectStatus) {
        for (Long fileNum : files) {
            this.checkStatus(fileNum, expectStatus);
        }
        return true;
    }

    private synchronized boolean isFileCleaningInProgress(Long fileNum) {
        return this.fileInfoMap.containsKey(fileNum);
    }

    synchronized int getRequiredUtil(Long fileNum) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        return info != null ? info.requiredUtil : -1;
    }

    synchronized FileInfo removeFile(Long fileNum, MemoryBudget budget) {
        FileInfo info = (FileInfo)this.fileInfoMap.get(fileNum);
        if (info == null) {
            return null;
        }
        this.adjustMemoryBudget(budget, info.dbIds, null);
        this.fileInfoMap.remove(fileNum);
        return info;
    }

    synchronized void putBackFileForCleaning(Long fileNum) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
    }

    public synchronized void injectFileForCleaning(Long fileNum) {
        if (!this.isFileCleaningInProgress(fileNum)) {
            FileInfo info = this.setStatus(fileNum, FileStatus.TO_BE_CLEANED);
            info.requiredUtil = -1;
        }
    }

    synchronized void addCleanedFile(Long fileNum, Set<DatabaseId> databases, VLSN firstVlsn, VLSN lastVlsn, MemoryBudget budget) {
        assert (this.checkStatus(fileNum, FileStatus.BEING_CLEANED));
        FileInfo info = this.setStatus(fileNum, FileStatus.CLEANED);
        this.adjustMemoryBudget(budget, info.dbIds, databases);
        info.dbIds = databases;
        info.firstVlsn = firstVlsn;
        info.lastVlsn = lastVlsn;
    }

    synchronized Set<Long> getToBeCleanedFiles() {
        return this.getFiles(FileStatus.TO_BE_CLEANED);
    }

    synchronized CheckpointStartCleanerState getFilesAtCheckpointStart(EnvironmentImpl env, Logger logger) {
        TreeSet<Long> set = null;
        for (Map.Entry<Long, FileInfo> entry : this.fileInfoMap.entrySet()) {
            if (entry.getValue().status != FileStatus.CLEANED) continue;
            Long file = entry.getKey();
            PendingInfo pInfo = this.pendingInfoMap.get(file);
            if (pInfo != null) {
                LoggerUtils.logMsg(logger, env, Level.INFO, pInfo.getMessage(file, env, this.dateFormat));
                continue;
            }
            if (set == null) {
                set = new TreeSet<Long>();
            }
            set.add(file);
        }
        return new CheckpointStartCleanerState(set);
    }

    public synchronized boolean isCheckpointNeeded() {
        return this.getNumberOfFiles(FileStatus.CLEANED) > 0;
    }

    synchronized Map<Long, FileInfo> updateFilesAtCheckpointEnd(EnvironmentImpl env, CheckpointStartCleanerState checkpointInfo) {
        if (checkpointInfo.isEmpty()) {
            return Collections.emptyMap();
        }
        FileProtector fileProtector = env.getFileProtector();
        MemoryBudget memoryBudget = env.getMemoryBudget();
        HashMap<Long, FileInfo> reservedFiles = new HashMap<Long, FileInfo>();
        Set<Long> safeToDeleteFiles = checkpointInfo.getCleanedFiles();
        for (Long file : safeToDeleteFiles) {
            FileInfo info = this.removeFile(file, memoryBudget);
            fileProtector.reserveFile(file, info.lastVlsn);
            reservedFiles.put(file, info);
        }
        env.getUtilizationProfile().removeFileSummaries(safeToDeleteFiles);
        return reservedFiles;
    }

    synchronized void addPendingLN(long logLsn, LNInfo lnInfo) {
        Long file = DbLsn.getFileNumber(logLsn);
        assert (this.checkStatus(file, FileStatus.BEING_CLEANED));
        PendingInfo pInfo = this.pendingInfoMap.get(file);
        if (pInfo == null) {
            pInfo = new PendingInfo();
            this.pendingInfoMap.put(file, pInfo);
        }
        if (pInfo.pendingLNs == null) {
            pInfo.pendingLNs = new HashMap<Long, LNInfo>();
        }
        pInfo.pendingLNs.put(logLsn, lnInfo);
    }

    synchronized Map<Long, LNInfo> getPendingLNs() {
        HashMap<Long, LNInfo> map = null;
        for (PendingInfo info : this.pendingInfoMap.values()) {
            if (info.pendingLNs == null) continue;
            if (map == null) {
                map = new HashMap<Long, LNInfo>();
            }
            map.putAll(info.pendingLNs);
        }
        return map;
    }

    synchronized void removePendingLN(long logLsn) {
        Long file = DbLsn.getFileNumber(logLsn);
        PendingInfo info = this.pendingInfoMap.get(file);
        if (info == null || info.pendingLNs == null) {
            return;
        }
        info.pendingLNs.remove(logLsn);
        if (info.pendingLNs.size() == 0) {
            info.pendingLNs = null;
            if (info.pendingDBs == null) {
                this.pendingInfoMap.remove(file);
            }
        }
    }

    synchronized Pair<Integer, Integer> getPendingQueueSizes() {
        int lns = 0;
        int dbs = 0;
        for (PendingInfo info : this.pendingInfoMap.values()) {
            if (info.pendingLNs != null) {
                lns += info.pendingLNs.size();
            }
            if (info.pendingDBs == null) continue;
            dbs += info.pendingDBs.size();
        }
        return new Pair<Integer, Integer>(lns, dbs);
    }

    synchronized boolean addPendingDB(Long file, DatabaseId dbId) {
        assert (dbId != null);
        PendingInfo info = this.pendingInfoMap.get(file);
        if (info == null) {
            info = new PendingInfo();
            this.pendingInfoMap.put(file, info);
        }
        if (info.pendingDBs == null) {
            info.pendingDBs = new HashSet<DatabaseId>();
        }
        return info.pendingDBs.add(dbId);
    }

    synchronized List<DatabaseId> getPendingDBs() {
        ArrayList<DatabaseId> list = null;
        for (PendingInfo info : this.pendingInfoMap.values()) {
            if (info.pendingDBs == null) continue;
            if (list == null) {
                list = new ArrayList<DatabaseId>();
            }
            list.addAll(info.pendingDBs);
        }
        return list;
    }

    synchronized void removePendingDB(DatabaseId dbId) {
        Iterator<PendingInfo> iter = this.pendingInfoMap.values().iterator();
        while (iter.hasNext()) {
            PendingInfo info = iter.next();
            if (info.pendingDBs == null) continue;
            info.pendingDBs.remove(dbId);
            if (info.pendingDBs.size() != 0) continue;
            info.pendingDBs = null;
            if (info.pendingLNs != null) continue;
            iter.remove();
        }
    }

    public synchronized NavigableSet<Long> getInProgressFiles() {
        return new TreeSet<Long>(this.fileInfoMap.keySet());
    }

    synchronized void close(MemoryBudget budget) {
        for (FileInfo info : this.fileInfoMap.values()) {
            this.adjustMemoryBudget(budget, info.dbIds, null);
        }
    }

    private void adjustMemoryBudget(MemoryBudget budget, Set<DatabaseId> oldDatabases, Set<DatabaseId> newDatabases) {
        long adjustMem = 0L;
        if (oldDatabases != null) {
            adjustMem -= this.getCleanedFilesDatabaseEntrySize(oldDatabases);
        }
        if (newDatabases != null) {
            adjustMem += this.getCleanedFilesDatabaseEntrySize(newDatabases);
        }
        budget.updateAdminMemoryUsage(adjustMem);
    }

    private long getCleanedFilesDatabaseEntrySize(Set<DatabaseId> databases) {
        return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.HASHSET_OVERHEAD + databases.size() * MemoryBudget.HASHSET_ENTRY_OVERHEAD;
    }

    public synchronized String toString() {
        return "files = " + this.fileInfoMap;
    }

    public static class CheckpointStartCleanerState {
        private Set<Long> cleanedFiles;

        private CheckpointStartCleanerState(Set<Long> cleanedFiles) {
            this.cleanedFiles = cleanedFiles;
        }

        public boolean isEmpty() {
            return this.cleanedFiles == null;
        }

        Set<Long> getCleanedFiles() {
            return this.cleanedFiles;
        }
    }

    static class FileInfo {
        private FileStatus status;
        private int requiredUtil = -1;
        Set<DatabaseId> dbIds;
        VLSN firstVlsn = VLSN.NULL_VLSN;
        VLSN lastVlsn = VLSN.NULL_VLSN;

        FileInfo() {
        }

        public String toString() {
            return "status = " + (Object)((Object)this.status) + " dbIds = " + this.dbIds + " firstVlsn = " + this.firstVlsn + " lastVlsn = " + this.lastVlsn;
        }
    }

    private static class PendingInfo {
        long cleaningTime = System.currentTimeMillis();
        Map<Long, LNInfo> pendingLNs;
        Set<DatabaseId> pendingDBs;

        private PendingInfo() {
        }

        public String toString() {
            return "pendingLN = " + this.pendingLNs + " pendingDBs = " + this.pendingDBs;
        }

        String getMessage(Long file, EnvironmentImpl env, DateFormat dateFormat) {
            int count;
            StringBuilder s = new StringBuilder();
            s.append("File 0x").append(Long.toHexString(file));
            s.append(" cannot be deleted after checkpoint due to");
            s.append(" pending entries. File cleaned at ");
            s.append(dateFormat.format(new Date(this.cleaningTime)));
            s.append(".");
            if (this.pendingLNs != null) {
                s.append(" Write lock is held on ");
                s.append(this.pendingLNs.size()).append(" records:");
                count = 0;
                for (Map.Entry entry : this.pendingLNs.entrySet()) {
                    if (++count > 3) {
                        s.append(" (only first 3 records shown)");
                        break;
                    }
                    long lsn = (Long)entry.getKey();
                    Locker locker = env.getTxnManager().getLockManager().getWriteOwnerLocker(lsn);
                    s.append(" [lsn=");
                    s.append(DbLsn.getNoFormatString(lsn));
                    s.append(" db=");
                    s.append(PendingInfo.getDbName(((LNInfo)entry.getValue()).getDbId(), env));
                    if (locker != null) {
                        s.append(" locker=").append(locker.toString());
                    }
                    s.append("]");
                }
            }
            if (this.pendingDBs != null) {
                s.append(" Database remove/truncate in progress on ");
                s.append(this.pendingDBs.size()).append(" DBs:");
                count = 0;
                for (DatabaseId databaseId : this.pendingDBs) {
                    if (++count > 3) {
                        s.append(" (only first 3 DBs shown)");
                        break;
                    }
                    s.append(" [db=");
                    s.append(PendingInfo.getDbName(databaseId, env));
                    s.append("]");
                }
            }
            return s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getDbName(DatabaseId dbId, EnvironmentImpl env) {
            DbTree dbTree = env.getDbTree();
            DatabaseImpl db = dbTree.getDb(dbId);
            try {
                String string = db != null ? db.getName() : "id=" + dbId;
                return string;
            }
            finally {
                dbTree.releaseDb(db);
            }
        }
    }

    static enum FileStatus {
        TO_BE_CLEANED,
        BEING_CLEANED,
        CLEANED;

    }
}

