/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.ListFunction;

public final class ConjoinStep<S>
extends ScalarMapStep<S, String>
implements ListFunction {
    private String delimiter;

    public ConjoinStep(Traversal.Admin traversal, String delimiter) {
        super(traversal);
        if (null == delimiter) {
            throw new IllegalArgumentException("Input delimiter to conjoin step can't be null.");
        }
        this.delimiter = delimiter;
    }

    @Override
    public String getStepName() {
        return "conjoin";
    }

    @Override
    protected String map(Traverser.Admin<S> traverser) {
        Collection elements = this.convertTraverserToCollection(traverser);
        if (elements.isEmpty()) {
            return "";
        }
        StringBuilder joinResult = new StringBuilder();
        for (Object elem : elements) {
            if (elem == null) continue;
            joinResult.append(String.valueOf(elem)).append(this.delimiter);
        }
        if (joinResult.length() != 0) {
            joinResult.delete(joinResult.length() - this.delimiter.length(), joinResult.length());
            return joinResult.toString();
        }
        return null;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public ConjoinStep<S> clone() {
        ConjoinStep clone = (ConjoinStep)super.clone();
        clone.delimiter = this.delimiter;
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return Objects.hash(result, this.delimiter);
    }
}

