/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopGraph;
import org.apache.tinkerpop.gremlin.hadoop.structure.HadoopVertex;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopElementIterator;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public final class HadoopVertexIterator
extends HadoopElementIterator<Vertex> {
    private HadoopVertex nextVertex = null;

    public HadoopVertexIterator(HadoopGraph graph) throws IOException {
        super(graph);
    }

    @Override
    public Vertex next() {
        try {
            if (this.nextVertex != null) {
                HadoopVertex temp = this.nextVertex;
                this.nextVertex = null;
                return temp;
            }
            while (!this.readers.isEmpty()) {
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    return new HadoopVertex((Vertex)((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get(), this.graph);
                }
                ((RecordReader)this.readers.remove()).close();
            }
            throw FastNoSuchElementException.instance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (null != this.nextVertex) {
                return true;
            }
            while (!this.readers.isEmpty()) {
                if (((RecordReader)this.readers.peek()).nextKeyValue()) {
                    this.nextVertex = new HadoopVertex((Vertex)((VertexWritable)((RecordReader)this.readers.peek()).getCurrentValue()).get(), this.graph);
                    return true;
                }
                ((RecordReader)this.readers.remove()).close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return false;
    }
}

