/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.io.Serializable;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.collection.BitSet;
import org.apache.spark.util.collection.OpenHashSet;
import org.apache.spark.util.collection.OpenHashSet$;
import org.apache.spark.util.collection.OpenHashSet$Hasher$mcD$sp;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Private
public class OpenHashSet$mcD$sp
extends OpenHashSet<Object> {
    public final OpenHashSet.Hasher<Object> hasher$mcD$sp;
    public double[] _data$mcD$sp;
    private final int initialCapacity;
    private final double loadFactor;
    private final ClassTag<Object> evidence$1;

    @Override
    public OpenHashSet.Hasher<Object> hasher$mcD$sp() {
        return this.hasher$mcD$sp;
    }

    @Override
    public OpenHashSet.Hasher<Object> hasher() {
        return this.hasher$mcD$sp();
    }

    @Override
    public double[] _data$mcD$sp() {
        return this._data$mcD$sp;
    }

    public double[] _data() {
        return this._data$mcD$sp();
    }

    @Override
    public void _data$mcD$sp_$eq(double[] x$1) {
        this._data$mcD$sp = x$1;
    }

    public void _data_$eq(double[] x$1) {
        this._data$mcD$sp_$eq(x$1);
    }

    @Override
    public boolean contains(double k) {
        return this.contains$mcD$sp(k);
    }

    @Override
    public boolean contains$mcD$sp(double k) {
        return this.getPos$mcD$sp(k) != OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public void add(double k) {
        this.add$mcD$sp(k);
    }

    @Override
    public void add$mcD$sp(double k) {
        this.addWithoutResize$mcD$sp(k);
        this.rehashIfNeeded$mcD$sp(k, OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$grow(), OpenHashSet$.MODULE$.org$apache$spark$util$collection$OpenHashSet$$move());
    }

    @Override
    public OpenHashSet<Object> union(OpenHashSet<Object> other) {
        return this.union$mcD$sp(other);
    }

    @Override
    public OpenHashSet<Object> union$mcD$sp(OpenHashSet<Object> other) {
        Iterator<Object> iterator = other.iterator();
        while (iterator.hasNext()) {
            this.add$mcD$sp(BoxesRunTime.unboxToDouble((Object)iterator.next()));
        }
        return this;
    }

    @Override
    public int addWithoutResize(double k) {
        return this.addWithoutResize$mcD$sp(k);
    }

    @Override
    public int addWithoutResize$mcD$sp(double k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (true) {
            if (!this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
                this._data()[pos] = k;
                this.org$apache$spark$util$collection$OpenHashSet$$_bitset().set(pos);
                this.org$apache$spark$util$collection$OpenHashSet$$_size_$eq(this.org$apache$spark$util$collection$OpenHashSet$$_size() + 1);
                return pos | OpenHashSet$.MODULE$.NONEXISTENCE_MASK();
            }
            if (this._data()[pos] == k) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
    }

    @Override
    public void rehashIfNeeded(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehashIfNeeded$mcD$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehashIfNeeded$mcD$sp(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        block0: {
            if (this.org$apache$spark$util$collection$OpenHashSet$$_size() <= this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold()) break block0;
            this.rehash$mcD$sp(k, allocateFunc, moveFunc);
        }
    }

    @Override
    public int getPos(double k) {
        return this.getPos$mcD$sp(k);
    }

    @Override
    public int getPos$mcD$sp(double k) {
        int pos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(k)) & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
        int delta = 1;
        while (this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos)) {
            if (k == this._data()[pos]) {
                return pos;
            }
            pos = pos + delta & this.org$apache$spark$util$collection$OpenHashSet$$_mask();
            ++delta;
        }
        return OpenHashSet$.MODULE$.INVALID_POS();
    }

    @Override
    public double getValue(int pos) {
        return this.getValue$mcD$sp(pos);
    }

    @Override
    public double getValue$mcD$sp(int pos) {
        return this._data()[pos];
    }

    @Override
    public double getValueSafe(int pos) {
        return this.getValueSafe$mcD$sp(pos);
    }

    @Override
    public double getValueSafe$mcD$sp(int pos) {
        Predef$.MODULE$.assert(this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(pos));
        return this._data()[pos];
    }

    @Override
    public void rehash(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        this.rehash$mcD$sp(k, allocateFunc, moveFunc);
    }

    @Override
    public void rehash$mcD$sp(double k, Function1<Object, BoxedUnit> allocateFunc, Function2<Object, Object, BoxedUnit> moveFunc) {
        int newCapacity = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() * 2;
        Predef$.MODULE$.require(newCapacity > 0 && newCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Can't contain more than ").append((int)($this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)OpenHashSet$.MODULE$.MAX_CAPACITY())).append(" elements").toString());
        allocateFunc.apply$mcVI$sp(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        double[] newData = (double[])this.org$apache$spark$util$collection$OpenHashSet$$evidence$1.newArray(newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity(); ++oldPos) {
            if (!this.org$apache$spark$util$collection$OpenHashSet$$_bitset().get(oldPos)) continue;
            double key = this._data()[oldPos];
            int newPos = this.org$apache$spark$util$collection$OpenHashSet$$hashcode(this.hasher().hash$mcD$sp(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (!newBitset.get(newPos)) {
                    newData[newPos] = key;
                    newBitset.set(newPos);
                    moveFunc.apply$mcVII$sp(oldPos, newPos);
                    keepGoing = false;
                    continue;
                }
                int delta = i++;
                newPos = newPos + delta & newMask;
            }
        }
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset_$eq(newBitset);
        this._data_$eq(newData);
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity_$eq(newCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask_$eq(newMask);
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold_$eq((int)(this.org$apache$spark$util$collection$OpenHashSet$$loadFactor * (double)newCapacity));
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public OpenHashSet$mcD$sp(int initialCapacity, double loadFactor, ClassTag<Object> evidence$1) {
        OpenHashSet.Hasher hasher;
        ClassTag mt;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.evidence$1 = evidence$1;
        super(initialCapacity, loadFactor, evidence$1);
        Predef$.MODULE$.require(initialCapacity <= OpenHashSet$.MODULE$.MAX_CAPACITY(), OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$1);
        Predef$.MODULE$.require(initialCapacity >= 0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$2);
        Predef$.MODULE$.require(loadFactor < 1.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$3);
        Predef$.MODULE$.require(loadFactor > 0.0, OpenHashSet::org$apache$spark$util$collection$OpenHashSet$$$anonfun$new$4);
        ClassTag classTag = mt = package$.MODULE$.classTag(evidence$1);
        ClassTag classTag2 = ClassTag$.MODULE$.Long();
        if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
            hasher = new OpenHashSet.LongHasher();
        } else {
            ClassTag classTag3 = mt;
            ClassTag classTag4 = ClassTag$.MODULE$.Int();
            if (!(classTag3 != null ? !classTag3.equals(classTag4) : classTag4 != null)) {
                hasher = new OpenHashSet.IntHasher();
            } else {
                ClassTag classTag5 = mt;
                ClassTag classTag6 = ClassTag$.MODULE$.Double();
                if (!(classTag5 != null ? !classTag5.equals(classTag6) : classTag6 != null)) {
                    hasher = new OpenHashSet.DoubleHasher();
                } else {
                    ClassTag classTag7 = mt;
                    ClassTag classTag8 = ClassTag$.MODULE$.Float();
                    hasher = !(classTag7 != null ? !classTag7.equals(classTag8) : classTag8 != null) ? new OpenHashSet.FloatHasher() : new OpenHashSet$Hasher$mcD$sp();
                }
            }
        }
        this.hasher$mcD$sp = hasher;
        this.org$apache$spark$util$collection$OpenHashSet$$_capacity = this.org$apache$spark$util$collection$OpenHashSet$$nextPowerOf2(initialCapacity);
        this.org$apache$spark$util$collection$OpenHashSet$$_mask = this.org$apache$spark$util$collection$OpenHashSet$$_capacity() - 1;
        this.org$apache$spark$util$collection$OpenHashSet$$_size = 0;
        this.org$apache$spark$util$collection$OpenHashSet$$_growThreshold = (int)(loadFactor * (double)this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this.org$apache$spark$util$collection$OpenHashSet$$_bitset = new BitSet(this.org$apache$spark$util$collection$OpenHashSet$$_capacity());
        this._data_$eq(evidence$1.newArray(this.org$apache$spark$util$collection$OpenHashSet$$_capacity()));
    }

    public OpenHashSet$mcD$sp(int initialCapacity, ClassTag<Object> evidence$2) {
        this(initialCapacity, 0.7, evidence$2);
    }

    public OpenHashSet$mcD$sp(ClassTag<Object> evidence$3) {
        this(64, evidence$3);
    }
}

