/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.janusgraph.core.schema.SchemaStatus;

public enum SchemaAction {
    REGISTER_INDEX(Collections.singleton(SchemaStatus.INSTALLED)),
    REINDEX(Arrays.asList(SchemaStatus.REGISTERED, SchemaStatus.ENABLED, SchemaStatus.DISABLED)),
    ENABLE_INDEX(Arrays.asList(SchemaStatus.REGISTERED, SchemaStatus.DISABLED, SchemaStatus.ENABLED)),
    DISABLE_INDEX(Arrays.asList(SchemaStatus.ENABLED, SchemaStatus.DISABLED, SchemaStatus.REGISTERED)),
    DISCARD_INDEX(Arrays.asList(SchemaStatus.DISABLED, SchemaStatus.REGISTERED, SchemaStatus.DISCARDED)),
    DROP_INDEX(Collections.singleton(SchemaStatus.DISCARDED)),
    MARK_DISCARDED(Arrays.asList(SchemaStatus.DISABLED, SchemaStatus.REGISTERED, SchemaStatus.DISCARDED));

    private final Set<SchemaStatus> applicableStatuses;

    private SchemaAction(Collection<SchemaStatus> applicableStatuses) {
        this.applicableStatuses = Collections.unmodifiableSet(new HashSet<SchemaStatus>(applicableStatuses));
    }

    public Set<SchemaStatus> getApplicableStatus() {
        return this.applicableStatuses;
    }

    public boolean isApplicableStatus(SchemaStatus status) {
        if (!this.applicableStatuses.contains((Object)status)) {
            throw new IllegalArgumentException(String.format("Update action [%s] cannot be invoked for index with status [%s]", new Object[]{this, status}));
        }
        return true;
    }
}

