/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.system;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.query.vertex.VertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.util.datastructures.Retriever;

public class EmptyVertex
implements InternalVertex {
    private static final String errorName = "Empty vertex";

    @Override
    public VertexCentricQueryBuilder query() {
        throw new UnsupportedOperationException("Empty vertex do not support querying");
    }

    @Override
    public Iterable<InternalRelation> getAddedRelations(Predicate<InternalRelation> query) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public Iterable<InternalRelation> findAddedProperty(Predicate<InternalRelation> query) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public Iterable<InternalRelation> findPreviousRelation(long id) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public EntryList loadRelations(SliceQuery query, Retriever<SliceQuery, EntryList> lookup) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public boolean hasLoadedRelations(SliceQuery query) {
        return false;
    }

    @Override
    public boolean hasRemovedRelations() {
        return false;
    }

    @Override
    public boolean hasAddedRelations() {
        return false;
    }

    @Override
    public String label() {
        return this.vertexLabel().name();
    }

    @Override
    public VertexLabel vertexLabel() {
        return BaseVertexLabel.DEFAULT_VERTEXLABEL;
    }

    public <O> O valueOrNull(PropertyKey key) {
        if (key instanceof ImplicitKey) {
            return ((ImplicitKey)key).computeProperty(this);
        }
        return null;
    }

    public <O> O value(String key) {
        if (!this.tx().containsPropertyKey(key)) {
            throw Property.Exceptions.propertyDoesNotExist((Element)this, (String)key);
        }
        O val = this.valueOrNull(this.tx().getPropertyKey(key));
        if (val == null) {
            throw Property.Exceptions.propertyDoesNotExist((Element)this, (String)key);
        }
        return val;
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(String key, V value, Object ... keyValues) {
        throw new UnsupportedOperationException("Empty vertex do not support incident properties");
    }

    @Override
    public <V> JanusGraphVertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        throw new UnsupportedOperationException("Empty vertex do not support incident properties");
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        return Collections.emptyIterator();
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return Collections.emptyIterator();
    }

    @Override
    public boolean addRelation(InternalRelation e) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public void removeRelation(InternalRelation e) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public JanusGraphEdge addEdge(String s, Vertex vertex, Object ... keyValues) {
        throw new UnsupportedOperationException("Empty vertex do not support incident edges");
    }

    @Override
    public Object id() {
        return null;
    }

    @Override
    public boolean hasId() {
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Empty vertex cannot be removed");
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        return Collections.emptyIterator();
    }

    @Override
    public void setId(Object id) {
        throw new UnsupportedOperationException("Empty vertex don't have an id");
    }

    @Override
    public byte getLifeCycle() {
        return 2;
    }

    @Override
    public boolean isInvisible() {
        return false;
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public InternalVertex it() {
        return this;
    }

    @Override
    public StandardJanusGraphTx tx() {
        throw new UnsupportedOperationException("Empty vertex don't have an associated transaction");
    }
}

