/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher;

import java.util.Collection;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.BatchProcessingQueue;
import org.janusgraph.util.datastructures.ExceptionUtil;

public abstract class MultiQueriableStepBatchFetcher<R> {
    private Map<JanusGraphVertex, R> multiQueryResults = null;
    private int batchSize;
    private int currentLoops = 0;
    private BatchProcessingQueue<JanusGraphVertex> firstLoopBatchProcessingQueue;
    private BatchProcessingQueue<JanusGraphVertex> currentLoopBatchProcessingQueue;
    private BatchProcessingQueue<JanusGraphVertex> nextLoopBatchProcessingQueue;

    public MultiQueriableStepBatchFetcher(int batchSize) {
        this.batchSize = batchSize;
        this.currentLoopBatchProcessingQueue = this.generateNewBatchProcessingQueue();
        this.nextLoopBatchProcessingQueue = this.generateNewBatchProcessingQueue();
    }

    public void registerCurrentLoopFutureVertexForPrefetching(Vertex forGeneralVertex, int traverserLoops) {
        this.ensureCorrectLoopQueues(traverserLoops);
        JanusGraphVertex forVertex = JanusGraphTraversalUtil.getJanusGraphVertex((Element)forGeneralVertex);
        if (traverserLoops != 0 || this.firstLoopBatchProcessingQueue == null || !this.firstLoopBatchProcessingQueue.hasElementInAnyBatch(forVertex)) {
            this.currentLoopBatchProcessingQueue.addToBatchToEnd(forVertex);
        } else {
            this.currentLoopBatchProcessingQueue.softRemoveFromAllElementsRegistration(forVertex);
        }
    }

    public void registerNextLoopFutureVertexForPrefetching(Vertex forGeneralVertex, int traverserLoops) {
        this.ensureCorrectLoopQueues(traverserLoops);
        this.nextLoopBatchProcessingQueue.addToBatchToEnd(JanusGraphTraversalUtil.getJanusGraphVertex((Element)forGeneralVertex));
    }

    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex forGeneralVertex) {
        if (this.firstLoopBatchProcessingQueue == null) {
            this.firstLoopBatchProcessingQueue = this.generateNewBatchProcessingQueue();
        }
        this.firstLoopBatchProcessingQueue.addToBatchToEnd(JanusGraphTraversalUtil.getJanusGraphVertex((Element)forGeneralVertex));
    }

    public void refreshIfLoopsAreReset(int traverserLoops, JanusGraphVertex forVertex) {
        if (traverserLoops != 0 || this.currentLoopBatchProcessingQueue.hasElementInAnyBatch(forVertex)) {
            return;
        }
        this.currentLoops = traverserLoops;
        this.nextLoopBatchProcessingQueue = this.generateNewBatchProcessingQueue();
        this.currentLoopBatchProcessingQueue = this.firstLoopBatchProcessingQueue == null ? this.generateNewBatchProcessingQueue() : this.firstLoopBatchProcessingQueue;
        this.firstLoopBatchProcessingQueue = null;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        this.currentLoopBatchProcessingQueue.setBatchSize(batchSize);
        this.nextLoopBatchProcessingQueue.setBatchSize(batchSize);
    }

    public R fetchData(Traversal.Admin<?, ?> traversal, Vertex forGeneralVertex, int traverserLoops) {
        JanusGraphVertex forVertex = JanusGraphTraversalUtil.getJanusGraphVertex((Element)forGeneralVertex);
        if (this.hasNoFetchedData(forVertex)) {
            this.refreshIfLoopsAreReset(traverserLoops, forVertex);
            this.ensureCorrectLoopQueues(traverserLoops);
            this.multiQueryResults = this.prefetchNextBatch(traversal, forVertex);
        } else {
            this.ensureCorrectLoopQueues(traverserLoops);
        }
        return this.multiQueryResults.get(forVertex);
    }

    private boolean hasNoFetchedData(Vertex forVertex) {
        return this.multiQueryResults == null || !this.multiQueryResults.containsKey(forVertex);
    }

    protected Map<JanusGraphVertex, R> prefetchNextBatch(Traversal.Admin<?, ?> traversal, JanusGraphVertex requiredFetchVertex) {
        JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(traversal).multiQuery(this.nextBatch());
        multiQuery.addVertex(requiredFetchVertex);
        try {
            return this.makeQueryAndExecute(multiQuery);
        }
        catch (JanusGraphException janusGraphException) {
            throw ExceptionUtil.convertIfInterrupted(janusGraphException);
        }
    }

    protected Collection<JanusGraphVertex> nextBatch() {
        return this.currentLoopBatchProcessingQueue.removeFirst();
    }

    private void ensureCorrectLoopQueues(int loops) {
        if (loops != this.currentLoops) {
            this.currentLoopBatchProcessingQueue = loops == this.currentLoops + 1 ? this.nextLoopBatchProcessingQueue : this.generateNewBatchProcessingQueue();
            this.nextLoopBatchProcessingQueue = this.generateNewBatchProcessingQueue();
            this.currentLoops = loops;
        }
    }

    private BatchProcessingQueue<JanusGraphVertex> generateNewBatchProcessingQueue() {
        return new BatchProcessingQueue<JanusGraphVertex>(this.batchSize);
    }

    protected abstract Map<JanusGraphVertex, R> makeQueryAndExecute(JanusGraphMultiVertexQuery var1);
}

