/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import java.util.HashSet;
import java.util.Set;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.index.IndexCandidate;

public class IndexCandidateGroup
implements Comparable<IndexCandidateGroup> {
    private Set<IndexCandidate> indexCandidates;
    private Set<Condition> coveredClauses;
    private double score = Double.NEGATIVE_INFINITY;

    public IndexCandidateGroup(Set<IndexCandidate> indexCandidates) {
        this.indexCandidates = indexCandidates;
        this.coveredClauses = new HashSet<Condition>(indexCandidates.size());
        indexCandidates.forEach(c -> this.coveredClauses.addAll(c.getSubCover()));
    }

    public Set<IndexCandidate> getIndexCandidates() {
        return this.indexCandidates;
    }

    public Set<Condition> getCoveredClauses() {
        return this.coveredClauses;
    }

    public double getTotalScore() {
        if (this.score == Double.NEGATIVE_INFINITY) {
            this.score = this.indexCandidates.stream().mapToDouble(IndexCandidate::getScore).sum();
        }
        return this.score;
    }

    @Override
    public int compareTo(IndexCandidateGroup that) {
        if (that == null) {
            return 1;
        }
        if (this.coveredClauses.size() > that.getCoveredClauses().size()) {
            return 1;
        }
        if (this.coveredClauses.size() < that.getCoveredClauses().size()) {
            return -1;
        }
        if (this.indexCandidates.size() < that.getIndexCandidates().size()) {
            return 1;
        }
        if (this.indexCandidates.size() > that.getIndexCandidates().size()) {
            return -1;
        }
        return Double.compare(this.getTotalScore(), that.getTotalScore());
    }
}

