/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.index;

import java.util.Set;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.index.AbstractIndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexCandidate;
import org.janusgraph.graphdb.query.index.IndexSelectionStrategy;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.MixedIndexType;

public class ApproximateIndexSelectionStrategy
extends AbstractIndexSelectionStrategy {
    public static final String NAME = "approximate";
    private static final double ORDER_MATCH = 1.0;
    private static final double ALREADY_MATCHED_ADJUSTOR = -1.1;

    public ApproximateIndexSelectionStrategy(Configuration config) {
        super(config);
    }

    @Override
    public IndexSelectionStrategy.SelectedIndexQuery selectIndices(Set<IndexType> rawCandidates, MultiCondition<JanusGraphElement> conditions, Set<Condition> coveredClauses, OrderList orders, IndexSerializer serializer) {
        JointIndexQuery jointQuery = new JointIndexQuery();
        boolean isSorted = orders.isEmpty();
        while (true) {
            IndexCandidate bestCandidate = null;
            boolean candidateSupportsSort = false;
            for (IndexType index : rawCandidates) {
                IndexCandidate indexCandidate = this.createIndexCandidate(index, conditions, serializer);
                if (indexCandidate == null) continue;
                boolean supportsSort = orders.isEmpty() || coveredClauses.isEmpty() && index.isMixedIndex() && IndexSelectionUtil.indexCoversOrder((MixedIndexType)index, orders);
                indexCandidate.setScore(this.calculateIndexCandidateScore(indexCandidate, coveredClauses, supportsSort));
                if (coveredClauses.containsAll(indexCandidate.getSubCover()) || bestCandidate != null && !(indexCandidate.getScore() > bestCandidate.getScore())) continue;
                bestCandidate = indexCandidate;
                candidateSupportsSort = supportsSort;
            }
            if (bestCandidate == null) break;
            if (coveredClauses.isEmpty()) {
                isSorted = candidateSupportsSort;
            }
            coveredClauses.addAll(bestCandidate.getSubCover());
            this.addToJointQuery(bestCandidate, jointQuery, serializer, orders);
        }
        return new IndexSelectionStrategy.SelectedIndexQuery(jointQuery, isSorted);
    }

    private double calculateIndexCandidateScore(IndexCandidate indexCandidate, Set<Condition> coveredClauses, boolean supportsSort) {
        double score = 0.0;
        for (Condition c : indexCandidate.getSubCover()) {
            double subScore = this.getConditionBasicScore(c);
            if (coveredClauses.contains(c)) {
                subScore *= -1.1;
            }
            score += subScore + this.getIndexTypeScore(indexCandidate.getIndex());
        }
        if (supportsSort) {
            score += 1.0;
        }
        return score;
    }
}

