/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.solr;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.KerberosScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.zookeeper.KeeperException;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.solr.SolrResultIterator;
import org.janusgraph.diskstorage.solr.UncheckedSolrException;
import org.janusgraph.diskstorage.solr.transform.GeoToWktConverter;
import org.janusgraph.diskstorage.util.DefaultTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.Query;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.types.ParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class SolrIndex
implements IndexProvider {
    private static final Logger logger = LoggerFactory.getLogger(SolrIndex.class);
    private static final String DEFAULT_ID_FIELD = "id";
    private static final String TEXT_SUFFIX = "_t";
    private static final String TEXT_SUFFIX_MULTI = "_txt";
    private static final String STRING_SUFFIX = "_s";
    private static final String STRING_SUFFIX_MULTI = "_ss";
    public static final ConfigNamespace SOLR_NS = new ConfigNamespace(GraphDatabaseConfiguration.INDEX_NS, "solr", "Solr index configuration");
    public static final ConfigOption<String> SOLR_MODE = new ConfigOption(SOLR_NS, "mode", "The operation mode for Solr which is either via HTTP (`http`) or using SolrCloud (`cloud`)", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"cloud");
    public static final ConfigOption<Boolean> DYNAMIC_FIELDS = new ConfigOption(SOLR_NS, "dyn-fields", "Whether to use dynamic fields (which appends the data type to the field name). If dynamic fields is disabled, the user must map field names and define them explicitly in the schema.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<String[]> KEY_FIELD_NAMES = new ConfigOption(SOLR_NS, "key-field-names", "Field name that uniquely identifies each document in Solr. Must be specified as a list of `collection=field`.", ConfigOption.Type.GLOBAL, String[].class);
    public static final ConfigOption<String> TTL_FIELD = new ConfigOption(SOLR_NS, "ttl_field", "Name of the TTL field for Solr collections.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"ttl");
    public static final ConfigOption<String[]> ZOOKEEPER_URL = new ConfigOption(SOLR_NS, "zookeeper-url", "URL of the Zookeeper instance coordinating the SolrCloud cluster", ConfigOption.Type.MASKABLE, (Object)new String[]{"localhost:2181"});
    public static final ConfigOption<Integer> NUM_SHARDS = new ConfigOption(SOLR_NS, "num-shards", "Number of shards for a collection. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<Integer> MAX_SHARDS_PER_NODE = new ConfigOption(SOLR_NS, "max-shards-per-node", "Maximum number of shards per node. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<Integer> REPLICATION_FACTOR = new ConfigOption(SOLR_NS, "replication-factor", "Replication factor for a collection. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<String> SOLR_DEFAULT_CONFIG = new ConfigOption(SOLR_NS, "configset", "If specified, the same solr configSet can be reused for each new Collection that is created in SolrCloud.", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<String[]> HTTP_URLS = new ConfigOption(SOLR_NS, "http-urls", "List of URLs to use to connect to Solr Servers (LBHttpSolrClient is used), don't add core or collection name to the URL.", ConfigOption.Type.MASKABLE, (Object)new String[]{"http://localhost:8983/solr"});
    public static final ConfigOption<Integer> HTTP_CONNECTION_TIMEOUT = new ConfigOption(SOLR_NS, "http-connection-timeout", "Solr HTTP connection timeout.", ConfigOption.Type.MASKABLE, (Object)5000);
    public static final ConfigOption<Boolean> HTTP_ALLOW_COMPRESSION = new ConfigOption(SOLR_NS, "http-compression", "Enable/disable compression on the HTTP connections made to Solr.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> HTTP_MAX_CONNECTIONS_PER_HOST = new ConfigOption(SOLR_NS, "http-max-per-host", "Maximum number of HTTP connections per Solr host.", ConfigOption.Type.MASKABLE, (Object)20);
    public static final ConfigOption<Integer> HTTP_GLOBAL_MAX_CONNECTIONS = new ConfigOption(SOLR_NS, "http-max", "Maximum number of HTTP connections in total to all Solr servers.", ConfigOption.Type.MASKABLE, (Object)100);
    public static final ConfigOption<Boolean> WAIT_SEARCHER = new ConfigOption(SOLR_NS, "wait-searcher", "When mutating - wait for the index to reflect new mutations before returning. This can have a negative impact on performance.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> KERBEROS_ENABLED = new ConfigOption(SOLR_NS, "kerberos-enabled", "Whether SOLR instance is Kerberized or not.", ConfigOption.Type.MASKABLE, (Object)false);
    private static final IndexFeatures SOLR_FEATURES = new IndexFeatures.Builder().supportsDocumentTTL().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.STRING, Mapping.TEXTSTRING}).supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsCustomAnalyzer().supportsGeoContains().build();
    private static final Map<Geo, String> SPATIAL_PREDICATES = SolrIndex.spatialPredicates();
    private final SolrClient solrClient;
    private final Configuration configuration;
    private final Mode mode;
    private final boolean dynFields;
    private final Map<String, String> keyFieldIds;
    private final String ttlField;
    private final int batchSize;
    private final boolean waitSearcher;
    private final boolean kerberosEnabled;

    public SolrIndex(Configuration config) throws BackendException {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0);
        this.configuration = config;
        this.mode = Mode.parse((String)config.get(SOLR_MODE, new String[0]));
        this.kerberosEnabled = (Boolean)config.get(KERBEROS_ENABLED, new String[0]);
        this.dynFields = (Boolean)config.get(DYNAMIC_FIELDS, new String[0]);
        this.keyFieldIds = this.parseKeyFieldsForCollections(config);
        this.batchSize = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
        this.ttlField = (String)config.get(TTL_FIELD, new String[0]);
        this.waitSearcher = (Boolean)config.get(WAIT_SEARCHER, new String[0]);
        if (this.kerberosEnabled) {
            logger.debug("Kerberos is enabled. Configuring SOLR for Kerberos.");
            this.configureSolrClientsForKerberos();
        } else {
            logger.debug("Kerberos is NOT enabled.");
            logger.debug("KERBEROS_ENABLED name is " + KERBEROS_ENABLED.getName() + " and it is" + (KERBEROS_ENABLED.isOption() ? " " : " not") + " an option.");
            logger.debug("KERBEROS_ENABLED type is " + KERBEROS_ENABLED.getType().name());
        }
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        switch (this.mode) {
            case CLOUD: {
                String[] zookeeperUrl = (String[])config.get(ZOOKEEPER_URL, new String[0]);
                Optional<Object> chroot = Optional.empty();
                for (int i = zookeeperUrl.length - 1; i >= 0; --i) {
                    int chrootIndex = zookeeperUrl[i].indexOf("/");
                    if (chrootIndex == -1) continue;
                    String hostAndPort = zookeeperUrl[i].substring(0, chrootIndex);
                    if (!chroot.isPresent()) {
                        chroot = Optional.of(zookeeperUrl[i].substring(chrootIndex));
                    }
                    zookeeperUrl[i] = hostAndPort;
                }
                CloudSolrClient.Builder builder = new CloudSolrClient.Builder(Arrays.asList(zookeeperUrl), chroot).withLBHttpSolrClientBuilder(new LBHttpSolrClient.Builder().withHttpSolrClientBuilder(new HttpSolrClient.Builder().withInvariantParams(clientParams)).withBaseSolrUrls((String[])config.get(HTTP_URLS, new String[0]))).sendUpdatesOnlyToShardLeaders();
                CloudSolrClient cloudServer = builder.build();
                cloudServer.connect();
                this.solrClient = cloudServer;
                break;
            }
            case HTTP: {
                clientParams.add("allowCompression", new String[]{((Boolean)config.get(HTTP_ALLOW_COMPRESSION, new String[0])).toString()});
                clientParams.add("connTimeout", new String[]{((Integer)config.get(HTTP_CONNECTION_TIMEOUT, new String[0])).toString()});
                clientParams.add("maxConnectionsPerHost", new String[]{((Integer)config.get(HTTP_MAX_CONNECTIONS_PER_HOST, new String[0])).toString()});
                clientParams.add("maxConnections", new String[]{((Integer)config.get(HTTP_GLOBAL_MAX_CONNECTIONS, new String[0])).toString()});
                CloseableHttpClient client = HttpClientUtil.createClient((SolrParams)clientParams);
                this.solrClient = ((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient((HttpClient)client)).withBaseSolrUrls((String[])config.get(HTTP_URLS, new String[0])).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Solr operation mode: " + (Object)((Object)this.mode));
            }
        }
    }

    private void configureSolrClientsForKerberos() throws PermanentBackendException {
        String kerberosConfig = System.getProperty("java.security.auth.login.config");
        if (kerberosConfig == null) {
            throw new PermanentBackendException("Unable to configure kerberos for solr client. System property 'java.security.auth.login.config' is not set.");
        }
        logger.debug("Using kerberos configuration file located at '{}'.", (Object)kerberosConfig);
        try (Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();){
            SolrHttpClientBuilder kb = krbBuild.getBuilder();
            HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
            HttpRequestInterceptor bufferedEntityInterceptor = (request, context) -> {
                if (request instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
                    HttpEntity requestEntity = enclosingRequest.getEntity();
                    enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
                }
            };
            HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)bufferedEntityInterceptor);
            PreemptiveAuth preemptiveAuth = new PreemptiveAuth((AuthScheme)new KerberosScheme());
            HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)preemptiveAuth);
        }
    }

    private Map<String, String> parseKeyFieldsForCollections(Configuration config) throws BackendException {
        String[] collectionFieldStatements;
        HashMap<String, String> keyFieldNames = new HashMap<String, String>();
        for (String collectionFieldStatement : collectionFieldStatements = config.has(KEY_FIELD_NAMES, new String[0]) ? (String[])config.get(KEY_FIELD_NAMES, new String[0]) : new String[]{}) {
            String[] parts = collectionFieldStatement.trim().split("=");
            if (parts.length != 2) {
                throw new PermanentBackendException("Unable to parse the collection name / key field name pair. It should be of the format collection=field");
            }
            String collectionName = parts[0];
            String keyFieldName = parts[1];
            keyFieldNames.put(collectionName, keyFieldName);
        }
        return keyFieldNames;
    }

    private String getKeyFieldId(String collection) {
        String field = this.keyFieldIds.get(collection);
        if (field == null) {
            field = DEFAULT_ID_FIELD;
        }
        return field;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        String analyzer;
        if (this.mode == Mode.CLOUD) {
            CloudSolrClient client = (CloudSolrClient)this.solrClient;
            try {
                SolrIndex.createCollectionIfNotExists(client, this.configuration, store);
            }
            catch (IOException | InterruptedException | SolrServerException | KeeperException e) {
                throw new PermanentBackendException(e);
            }
        }
        if ((analyzer = (String)ParameterType.STRING_ANALYZER.findParameter(information.getParameters(), null)) != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(analyzer).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PermanentBackendException(e.getMessage(), (Throwable)e);
            }
        }
        if ((analyzer = (String)ParameterType.TEXT_ANALYZER.findParameter(information.getParameters(), null)) != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(analyzer).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PermanentBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        logger.debug("Mutating SOLR");
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String collectionName = stores.getKey();
                String keyIdField = this.getKeyFieldId(collectionName);
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> changes = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docId = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            logger.trace("Deleting entire document {}", (Object)docId);
                            deleteIds.add(docId);
                        } else {
                            ArrayList<IndexEntry> fieldDeletions = new ArrayList<IndexEntry>(mutation.getDeletions());
                            if (mutation.hasAdditions()) {
                                for (IndexEntry indexEntry : mutation.getAdditions()) {
                                    fieldDeletions.remove(indexEntry);
                                }
                            }
                            this.handleRemovalsFromIndex(collectionName, keyIdField, docId, fieldDeletions, information);
                        }
                    }
                    if (!mutation.hasAdditions()) continue;
                    int ttl = mutation.determineTTL();
                    SolrInputDocument doc = new SolrInputDocument(new String[0]);
                    doc.setField(keyIdField, (Object)docId);
                    boolean isNewDoc = mutation.isNew();
                    if (isNewDoc) {
                        logger.trace("Adding new document {}", (Object)docId);
                    }
                    Map<String, Object> adds = this.collectFieldValues(mutation.getAdditions(), collectionName, information);
                    adds.forEach((k, v) -> {
                        KeyInformation keyInformation = information.get(collectionName, k);
                        String solrOp = keyInformation.getCardinality() == Cardinality.SINGLE ? "set" : "add";
                        doc.setField(k, (Object)(isNewDoc ? v : Collections.singletonMap(solrOp, v)));
                        SolrIndex.getDualFieldName(k, keyInformation).ifPresent(dk -> doc.setField(dk, (Object)(isNewDoc ? v : Collections.singletonMap(solrOp, v))));
                    });
                    if (ttl > 0) {
                        Preconditions.checkArgument((boolean)isNewDoc, (String)"Solr only supports TTL on new documents [%s]", (Object)docId);
                        doc.setField(this.ttlField, (Object)String.format("+%dSECONDS", ttl));
                    }
                    changes.add(doc);
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitChanges(collectionName, changes);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PermanentBackendException("Unable to complete query on Solr.", (Throwable)e);
        }
        catch (Exception e) {
            throw this.storageException(e);
        }
    }

    private void handleRemovalsFromIndex(String collectionName, String keyIdField, String docId, List<IndexEntry> fieldDeletions, KeyInformation.IndexRetriever information) throws SolrServerException, IOException, BackendException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField(keyIdField, (Object)docId);
        for (IndexEntry indexEntry : fieldDeletions) {
            KeyInformation keyInformation = information.get(collectionName, indexEntry.field);
            Map<String, Object> deletes = this.collectFieldValues(fieldDeletions, collectionName, information);
            deletes.forEach((k, v) -> {
                if (keyInformation.getCardinality() == Cardinality.SINGLE) {
                    doc.setField(k, Collections.singletonMap("set", null));
                    SolrIndex.getDualFieldName(k, keyInformation).ifPresent(dk -> doc.setField(dk, Collections.singletonMap("set", null)));
                } else {
                    doc.setField(k, Collections.singletonMap("remove", v));
                    SolrIndex.getDualFieldName(k, keyInformation).ifPresent(dk -> doc.setField(dk, Collections.singletonMap("remove", v)));
                }
            });
        }
        UpdateRequest singleDocument = this.newUpdateRequest();
        singleDocument.add(doc);
        this.solrClient.request((SolrRequest)singleDocument, collectionName);
    }

    private Object convertValue(Object value) throws BackendException {
        if (value instanceof Geoshape) {
            return GeoToWktConverter.convertToWktString((Geoshape)value);
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof Instant) {
            if (Math.floorMod(((Instant)value).getNano(), 1000000) != 0) {
                throw new IllegalArgumentException("Solr indexes do not support nanoseconds");
            }
            return new Date(((Instant)value).toEpochMilli());
        }
        return value;
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                String collectionName = stores.getKey();
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> newDocuments = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.isEmpty()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Deleting document [{}]", (Object)docID);
                        }
                        deleteIds.add(docID);
                        continue;
                    }
                    SolrInputDocument doc = new SolrInputDocument(new String[0]);
                    doc.setField(this.getKeyFieldId(collectionName), (Object)docID);
                    Map<String, Object> adds = this.collectFieldValues(content, collectionName, information);
                    adds.forEach((k, v) -> {
                        doc.setField(k, v);
                        SolrIndex.getDualFieldName(k, information.get(collectionName, k)).ifPresent(dk -> doc.setField(dk, v));
                    });
                    newDocuments.add(doc);
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitChanges(collectionName, newDocuments);
            }
        }
        catch (Exception e) {
            throw new TemporaryBackendException("Could not restore Solr index", (Throwable)e);
        }
    }

    private Map<String, Object> collectFieldValues(List<IndexEntry> content, String collectionName, KeyInformation.IndexRetriever information) throws BackendException {
        HashMap<String, Object> docs = new HashMap<String, Object>();
        for (IndexEntry addition : content) {
            KeyInformation keyInformation = information.get(collectionName, addition.field);
            switch (keyInformation.getCardinality()) {
                case SINGLE: {
                    docs.put(addition.field, this.convertValue(addition.value));
                    break;
                }
                case SET: {
                    if (!docs.containsKey(addition.field)) {
                        docs.put(addition.field, new HashSet());
                    }
                    ((Set)docs.get(addition.field)).add(this.convertValue(addition.value));
                    break;
                }
                case LIST: {
                    if (!docs.containsKey(addition.field)) {
                        docs.put(addition.field, new ArrayList());
                    }
                    ((List)docs.get(addition.field)).add(this.convertValue(addition.value));
                }
            }
        }
        return docs;
    }

    private void commitChanges(String collectionName, Collection<SolrInputDocument> documents) throws SolrServerException, IOException {
        if (documents.size() == 0) {
            return;
        }
        try {
            this.solrClient.request((SolrRequest)this.newUpdateRequest().add(documents), collectionName);
        }
        catch (HttpSolrClient.RemoteSolrException rse) {
            logger.error("Unable to save documents to Solr as one of the shape objects stored were not compatible with Solr.", (Throwable)rse);
            logger.error("Details in failed document batch: ");
            for (SolrInputDocument d : documents) {
                Collection fieldNames = d.getFieldNames();
                for (String name : fieldNames) {
                    logger.error(name + ":" + d.getFieldValue(name));
                }
            }
            throw rse;
        }
    }

    private void commitDeletes(String collectionName, List<String> deleteIds) throws SolrServerException, IOException {
        if (deleteIds.size() == 0) {
            return;
        }
        this.solrClient.request((SolrRequest)this.newUpdateRequest().deleteById(deleteIds), collectionName);
    }

    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        SolrQuery solrQuery = new SolrQuery("*:*");
        solrQuery.set("fl", new String[]{keyIdField});
        String queryFilter = this.buildQueryFilter((Condition<JanusGraphElement>)query.getCondition(), information.get(collection));
        solrQuery.addFilterQuery(new String[]{queryFilter});
        if (!query.getOrder().isEmpty()) {
            this.addOrderToQuery(solrQuery, query.getOrder(), information.get(collection));
        }
        solrQuery.setStart(Integer.valueOf(0));
        if (query.hasLimit()) {
            solrQuery.setRows(Integer.valueOf(Math.min(query.getLimit(), this.batchSize)));
        } else {
            solrQuery.setRows(Integer.valueOf(this.batchSize));
        }
        return this.executeQuery(query.hasLimit() ? Integer.valueOf(query.getLimit()) : null, 0, collection, solrQuery, doc -> doc.getFieldValue(keyIdField).toString());
    }

    private void addOrderToQuery(SolrQuery solrQuery, List<IndexQuery.OrderEntry> orders, KeyInformation.StoreRetriever information) {
        for (IndexQuery.OrderEntry order1 : orders) {
            String item = order1.getKey();
            KeyInformation ki = information.get(item);
            if (Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING) {
                item = SolrIndex.getDualFieldName(item, ki).orElse(item);
            }
            SolrQuery.ORDER order = order1.getOrder() == Order.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
            solrQuery.addSort(new SolrQuery.SortClause(item, order));
        }
    }

    private <E> Stream<E> executeQuery(Integer limit, int offset, String collection, SolrQuery solrQuery, Function<SolrDocument, E> function) throws PermanentBackendException {
        try {
            SolrResultIterator<E> resultIterator = new SolrResultIterator<E>(this.solrClient, limit, offset, solrQuery.getRows(), collection, solrQuery, function);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(resultIterator, 16), false);
        }
        catch (IOException | UncheckedIOException e) {
            logger.error("Query did not complete : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException | UncheckedSolrException e) {
            logger.error("Unable to query Solr index.", e);
            throw new PermanentBackendException(e);
        }
    }

    private SolrQuery runCommonQuery(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx, String collection, String keyIdField) throws BackendException {
        SolrQuery solrQuery = new SolrQuery(query.getQuery()).addField(keyIdField).setIncludeScore(true).setStart(Integer.valueOf(query.getOffset()));
        if (query.hasLimit()) {
            solrQuery.setRows(Integer.valueOf(Math.min(query.getLimit(), this.batchSize)));
        } else {
            solrQuery.setRows(Integer.valueOf(this.batchSize));
        }
        if (!query.getOrders().isEmpty()) {
            this.addOrderToQuery(solrQuery, (List<IndexQuery.OrderEntry>)query.getOrders(), information.get(collection));
        }
        for (Parameter parameter : query.getParameters()) {
            if (parameter.value() instanceof String[]) {
                solrQuery.setParam(parameter.key(), (String[])parameter.value());
                continue;
            }
            if (!(parameter.value() instanceof String)) continue;
            solrQuery.setParam(parameter.key(), new String[]{(String)parameter.value()});
        }
        return solrQuery;
    }

    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        return this.executeQuery(query.hasLimit() ? Integer.valueOf(query.getLimit()) : null, query.getOffset(), collection, this.runCommonQuery(query, information, tx, collection, keyIdField), doc -> {
            double score = Double.parseDouble(doc.getFieldValue("score").toString());
            return new RawQuery.Result((Object)doc.getFieldValue(keyIdField).toString(), score);
        });
    }

    public Number queryAggregation(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx, Aggregation aggregation) throws BackendException {
        try {
            String collection = query.getStore();
            SolrQuery solrQuery = new SolrQuery("*:*");
            String queryFilter = this.buildQueryFilter((Condition<JanusGraphElement>)query.getCondition(), information.get(collection));
            solrQuery.addFilterQuery(new String[]{queryFilter});
            switch (aggregation.getType()) {
                case COUNT: {
                    return this.executeCount(query, collection, solrQuery);
                }
                case MIN: {
                    return this.executeMin(query, collection, solrQuery, information, aggregation.getFieldName(), aggregation.getDataType());
                }
                case MAX: {
                    return this.executeMax(query, collection, solrQuery, information, aggregation.getFieldName(), aggregation.getDataType());
                }
                case AVG: {
                    return this.executeAvg(query, collection, solrQuery, information, aggregation.getFieldName());
                }
                case SUM: {
                    return this.executeSum(query, collection, solrQuery, information, aggregation.getFieldName(), aggregation.getDataType());
                }
            }
            throw new IOException();
        }
        catch (IOException e) {
            logger.error("Query did not complete : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error("Unable to query Solr index.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private long executeCount(IndexQuery query, String collection, SolrQuery solrQuery) throws IOException, SolrServerException {
        QueryResponse response = this.solrClient.query(collection, (SolrParams)solrQuery);
        logger.debug("Executed query [{}] in {} ms", (Object)query, (Object)response.getElapsedTime());
        return QueryUtil.applyQueryLimitAfterCount((long)response.getResults().getNumFound(), (Query)query);
    }

    private Number adaptNumberType(Number value, Class<? extends Number> expectedType) {
        if (expectedType == null) {
            return value;
        }
        if (Byte.class.isAssignableFrom(expectedType)) {
            return value.byteValue();
        }
        if (Short.class.isAssignableFrom(expectedType)) {
            return value.shortValue();
        }
        if (Integer.class.isAssignableFrom(expectedType)) {
            return value.intValue();
        }
        if (Long.class.isAssignableFrom(expectedType)) {
            return value.longValue();
        }
        if (Float.class.isAssignableFrom(expectedType)) {
            return Float.valueOf(value.floatValue());
        }
        if (Double.class.isAssignableFrom(expectedType)) {
            return value.doubleValue();
        }
        return value.doubleValue();
    }

    private Number executeMax(IndexQuery query, String collection, SolrQuery solrQuery, KeyInformation.IndexRetriever information, String fieldName, Class fieldType) throws SolrServerException, IOException {
        String key = this.mapKey2Field(fieldName, information.get(collection, fieldName));
        solrQuery.setGetFieldStatistics("{!max=true}" + key);
        QueryResponse response = this.solrClient.query(collection, (SolrParams)solrQuery);
        logger.debug("Executed query [{}] in {} ms", (Object)query, (Object)response.getElapsedTime());
        return this.adaptNumberType((Number)((FieldStatsInfo)response.getFieldStatsInfo().get(key)).getMax(), fieldType);
    }

    private Number executeMin(IndexQuery query, String collection, SolrQuery solrQuery, KeyInformation.IndexRetriever information, String fieldName, Class fieldType) throws SolrServerException, IOException {
        String key = this.mapKey2Field(fieldName, information.get(collection, fieldName));
        solrQuery.setGetFieldStatistics("{!min=true}" + key);
        QueryResponse response = this.solrClient.query(collection, (SolrParams)solrQuery);
        logger.debug("Executed query [{}] in {} ms", (Object)query, (Object)response.getElapsedTime());
        return this.adaptNumberType((Number)((FieldStatsInfo)response.getFieldStatsInfo().get(key)).getMin(), fieldType);
    }

    private Number executeSum(IndexQuery query, String collection, SolrQuery solrQuery, KeyInformation.IndexRetriever information, String fieldName, Class fieldType) throws SolrServerException, IOException {
        String key = this.mapKey2Field(fieldName, information.get(collection, fieldName));
        solrQuery.setGetFieldStatistics("{!sum=true}" + key);
        QueryResponse response = this.solrClient.query(collection, (SolrParams)solrQuery);
        logger.debug("Executed query [{}] in {} ms", (Object)query, (Object)response.getElapsedTime());
        Number sum = (Number)((FieldStatsInfo)response.getFieldStatsInfo().get(key)).getSum();
        if (Float.class.isAssignableFrom(fieldType) || Double.class.isAssignableFrom(fieldType)) {
            return sum.doubleValue();
        }
        return sum.longValue();
    }

    private Number executeAvg(IndexQuery query, String collection, SolrQuery solrQuery, KeyInformation.IndexRetriever information, String fieldName) throws SolrServerException, IOException {
        String key = this.mapKey2Field(fieldName, information.get(collection, fieldName));
        solrQuery.setGetFieldStatistics(key);
        solrQuery.setGetFieldStatistics("{!mean=true}" + key);
        QueryResponse response = this.solrClient.query(collection, (SolrParams)solrQuery);
        logger.debug("Executed query [{}] in {} ms", (Object)query, (Object)response.getElapsedTime());
        return ((Number)((FieldStatsInfo)response.getFieldStatsInfo().get(key)).getMean()).doubleValue();
    }

    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        try {
            String collection = query.getStore();
            String keyIdField = this.getKeyFieldId(collection);
            QueryResponse response = this.solrClient.query(collection, (SolrParams)this.runCommonQuery(query, information, tx, collection, keyIdField));
            logger.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getElapsedTime());
            return QueryUtil.applyOffsetWithQueryLimitAfterCount((long)response.getResults().getNumFound(), (int)query.getOffset(), (Query)query);
        }
        catch (IOException e) {
            logger.error("Query did not complete : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error("Unable to query Solr index.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static String escapeValue(Object value) {
        return ClientUtils.escapeQueryChars((String)value.toString());
    }

    public String buildQueryFilter(Condition<JanusGraphElement> condition, KeyInformation.StoreRetriever information) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            JanusGraphPredicate predicate = atom.getPredicate();
            if (value == null && predicate == Cmp.NOT_EQUAL) {
                return key + ":*";
            }
            if (value instanceof Number) {
                String queryValue = SolrIndex.escapeValue(value);
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (String)"Relation not supported on numeric types: %s", (Object)predicate);
                Cmp numRel = (Cmp)predicate;
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return key + ":* -" + key + ":" + queryValue;
                    }
                    case LESS_THAN: {
                        return key + ":[* TO " + queryValue + "}";
                    }
                    case LESS_THAN_EQUAL: {
                        return key + ":[* TO " + queryValue + "]";
                    }
                    case GREATER_THAN: {
                        return key + ":{" + queryValue + " TO *]";
                    }
                    case GREATER_THAN_EQUAL: {
                        return key + ":[" + queryValue + " TO *]";
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                KeyInformation keyInformation = information.get(key);
                Mapping map = SolrIndex.getStringMapping(keyInformation);
                assert (map == Mapping.TEXT || map == Mapping.STRING || map == Mapping.TEXTSTRING);
                if (map == Mapping.TEXT && !Text.HAS_CONTAINS.contains(predicate) && !(predicate instanceof Cmp)) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS and Compare queries and not: " + predicate);
                }
                if (map == Mapping.STRING && Text.HAS_CONTAINS.contains(predicate)) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + predicate);
                }
                if (predicate == Text.CONTAINS) {
                    return this.tokenize(ParameterType.TEXT_ANALYZER, information, value, key, predicate);
                }
                if (predicate == Text.PREFIX || predicate == Text.CONTAINS_PREFIX || predicate == Text.REGEX || predicate == Text.CONTAINS_REGEX || predicate == Text.FUZZY || predicate == Text.CONTAINS_FUZZY) {
                    return this.buildQueryFilterStringValue(key, (String)value, predicate, information);
                }
                if (predicate == Cmp.LESS_THAN || predicate == Cmp.LESS_THAN_EQUAL || predicate == Cmp.GREATER_THAN || predicate == Cmp.GREATER_THAN_EQUAL) {
                    return this.buildQueryFilterStringValue(key, (String)value, predicate, information);
                }
                if (predicate == Cmp.EQUAL || predicate == Cmp.NOT_EQUAL) {
                    return this.tokenize(ParameterType.STRING_ANALYZER, information, value, key, predicate);
                }
                throw new IllegalArgumentException("Relation is not supported for string value: " + predicate);
            }
            if (value instanceof Geoshape) {
                Mapping map = Mapping.getMapping((KeyInformation)information.get(key));
                Preconditions.checkArgument((predicate instanceof Geo && predicate != Geo.DISJOINT ? 1 : 0) != 0, (String)"Relation not supported on geo types: %s", (Object)predicate);
                Preconditions.checkArgument((map == Mapping.PREFIX_TREE || predicate == Geo.WITHIN || predicate == Geo.INTERSECT ? 1 : 0) != 0, (String)"Relation not supported on geopoint types: %s", (Object)predicate);
                Geoshape geo = (Geoshape)value;
                if (geo.getType() == Geoshape.Type.CIRCLE && (predicate == Geo.INTERSECT || map == Mapping.DEFAULT)) {
                    Geoshape.Point center = geo.getPoint();
                    return "{!geofilt sfield=" + key + " pt=" + center.getLatitude() + "," + center.getLongitude() + " d=" + geo.getRadius() + "} distErrPct=0";
                }
                if (geo.getType() == Geoshape.Type.BOX && (predicate == Geo.INTERSECT || map == Mapping.DEFAULT)) {
                    Geoshape.Point southwest = geo.getPoint(0);
                    Geoshape.Point northeast = geo.getPoint(1);
                    return key + ":[" + southwest.getLatitude() + "," + southwest.getLongitude() + " TO " + northeast.getLatitude() + "," + northeast.getLongitude() + "]";
                }
                if (map == Mapping.PREFIX_TREE) {
                    return key + ":\"" + SPATIAL_PREDICATES.get(predicate) + "(" + geo + ")\" distErrPct=0";
                }
                throw new IllegalArgumentException("Unsupported or invalid search shape type: " + geo.getType());
            }
            if (value instanceof Date || value instanceof Instant) {
                String queryValue = SolrIndex.escapeValue(value instanceof Date ? this.toIsoDate((Date)value) : value.toString());
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (String)"Relation not supported on date types: %s", (Object)predicate);
                Cmp numRel = (Cmp)predicate;
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return key + ":* -" + key + ":" + queryValue;
                    }
                    case LESS_THAN: {
                        return key + ":[* TO " + queryValue + "}";
                    }
                    case LESS_THAN_EQUAL: {
                        return key + ":[* TO " + queryValue + "]";
                    }
                    case GREATER_THAN: {
                        return key + ":{" + queryValue + " TO *]";
                    }
                    case GREATER_THAN_EQUAL: {
                        return key + ":[" + queryValue + " TO *]";
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof Boolean) {
                Cmp numRel = (Cmp)predicate;
                String queryValue = SolrIndex.escapeValue(value);
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return key + ":* -" + key + ":" + queryValue;
                    }
                }
                throw new IllegalArgumentException("Boolean types only support EQUAL or NOT_EQUAL");
            }
            if (value instanceof UUID) {
                if (predicate == Cmp.EQUAL) {
                    return key + ":\"" + SolrIndex.escapeValue(value) + "\"";
                }
                if (predicate == Cmp.NOT_EQUAL) {
                    return key + ":* -" + key + ":\"" + SolrIndex.escapeValue(value) + "\"";
                }
                throw new IllegalArgumentException("Relation is not supported for uuid value: " + predicate);
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            String sub = this.buildQueryFilter((Condition<JanusGraphElement>)((Not)condition).getChild(), information);
            if (StringUtils.isNotBlank((CharSequence)sub)) {
                return "-(" + sub + ")";
            }
            return "";
        }
        if (condition instanceof And) {
            int numChildren = ((And)condition).size();
            StringBuilder sb = new StringBuilder();
            for (Condition c : condition.getChildren()) {
                String sub = this.buildQueryFilter((Condition<JanusGraphElement>)c, information);
                if (StringUtils.isBlank((CharSequence)sub)) continue;
                if (!sub.startsWith("-") && numChildren > 1) {
                    sb.append("+");
                }
                sb.append(sub).append(" ");
            }
            return sb.toString();
        }
        if (condition instanceof Or) {
            StringBuilder sb = new StringBuilder();
            int element = 0;
            for (Condition c : condition.getChildren()) {
                String sub = this.buildQueryFilter((Condition<JanusGraphElement>)c, information);
                if (StringUtils.isBlank((CharSequence)sub)) continue;
                if (element == 0) {
                    sb.append("(");
                } else {
                    sb.append(" OR ");
                }
                sb.append(sub);
                ++element;
            }
            if (element > 0) {
                sb.append(")");
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public String buildQueryFilterStringValue(String key, String value, JanusGraphPredicate predicate, KeyInformation.StoreRetriever information) {
        KeyInformation keyInformation = information.get(key);
        Mapping map = SolrIndex.getStringMapping(keyInformation);
        String stringKey = map == Mapping.TEXTSTRING && !Text.HAS_CONTAINS.contains(predicate) ? SolrIndex.getDualFieldName(key, keyInformation).orElse(key) : key;
        if (predicate == Text.CONTAINS) {
            return key + ":(" + SolrIndex.escapeValue(value) + ")";
        }
        if (predicate == Text.PREFIX) {
            return stringKey + ":" + SolrIndex.escapeValue(value) + "*";
        }
        if (predicate == Text.CONTAINS_PREFIX) {
            return key + ":" + SolrIndex.escapeValue(value) + "*";
        }
        if (predicate == Text.REGEX) {
            return stringKey + ":/" + value + "/";
        }
        if (predicate == Text.CONTAINS_REGEX) {
            return key + ":/" + value + "/";
        }
        if (predicate == Cmp.EQUAL) {
            return stringKey + ":\"" + SolrIndex.escapeValue(value) + "\"";
        }
        if (predicate == Cmp.NOT_EQUAL) {
            return key + ":* -" + key + ":\"" + SolrIndex.escapeValue(value) + "\"";
        }
        if (predicate == Text.FUZZY) {
            return stringKey + ":" + SolrIndex.escapeValue(value) + "~" + Text.getMaxEditDistance((String)value.toString());
        }
        if (predicate == Text.CONTAINS_FUZZY) {
            return key + ":" + SolrIndex.escapeValue(value) + "~" + Text.getMaxEditDistance((String)value.toString());
        }
        if (predicate == Cmp.LESS_THAN) {
            return stringKey + ":[* TO \"" + SolrIndex.escapeValue(value) + "\"}";
        }
        if (predicate == Cmp.LESS_THAN_EQUAL) {
            return stringKey + ":[* TO \"" + SolrIndex.escapeValue(value) + "\"]";
        }
        if (predicate == Cmp.GREATER_THAN) {
            return stringKey + ":{\"" + SolrIndex.escapeValue(value) + "\" TO *}";
        }
        if (predicate == Cmp.GREATER_THAN_EQUAL) {
            return stringKey + ":[\"" + SolrIndex.escapeValue(value) + "\" TO *]";
        }
        throw new IllegalArgumentException("Relation is not supported for string value: " + predicate);
    }

    private String tokenize(ParameterType parameterType, KeyInformation.StoreRetriever information, Object value, String key, JanusGraphPredicate janusgraphPredicate) {
        List terms;
        if (parameterType != ParameterType.TEXT_ANALYZER && parameterType != ParameterType.STRING_ANALYZER) {
            throw new IllegalArgumentException("Invalid parameterType " + parameterType);
        }
        String analyzer = (String)parameterType.findParameter(information.get(key).getParameters(), null);
        if (analyzer != null) {
            terms = this.customTokenize(analyzer, key, (String)value);
        } else if (parameterType == ParameterType.TEXT_ANALYZER) {
            terms = Text.tokenize((String)((String)value));
        } else {
            return this.buildQueryFilterStringValue(key, (String)value, janusgraphPredicate, information);
        }
        if (terms.isEmpty()) {
            return "";
        }
        if (terms.size() == 1) {
            return this.buildQueryFilterStringValue(key, (String)terms.get(0), janusgraphPredicate, information);
        }
        And andTerms = new And();
        for (String term : terms) {
            andTerms.add((Condition)new PredicateCondition((Object)key, janusgraphPredicate, (Object)term));
        }
        return this.buildQueryFilter((Condition<JanusGraphElement>)andTerms, information);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> customTokenize(String analyzerClass, String fieldName, String value) {
        Analyzer analyzer;
        HashMap<Integer, ArrayList<String>> stemsByOffset = new HashMap<Integer, ArrayList<String>>();
        try {
            analyzer = (Analyzer)ClassLoader.getSystemClassLoader().loadClass(analyzerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try (CachingTokenFilter stream = new CachingTokenFilter(analyzer.tokenStream(fieldName, value));){
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                int offset = offsetAtt.startOffset();
                String stem = termAtt.getBytesRef().utf8ToString();
                ArrayList<String> stemList = (ArrayList<String>)stemsByOffset.get(offset);
                if (stemList == null) {
                    stemList = new ArrayList<String>();
                    stemsByOffset.put(offset, stemList);
                }
                stemList.add(stem);
            }
            List terms = stemsByOffset.values().stream().map(l -> (String)l.get(0)).collect(Collectors.toList());
            List<String> list = terms.isEmpty() ? Collections.singletonList(value) : terms;
            return list;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String toIsoDate(Date value) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        return df.format(value);
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        logger.trace("Shutting down connection to Solr {}", (Object)this.solrClient);
        try {
            this.solrClient.close();
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        if (this.mode != Mode.CLOUD) {
            logger.error("Operation only supported for SolrCloud. Cores must be deleted manually through the Solr API when using HTTP mode.");
            throw new UnsupportedOperationException("Operation only supported for SolrCloud");
        }
        try {
            logger.debug("Clearing storage from Solr: {}", (Object)this.solrClient);
            ZkStateReader zkStateReader = ((CloudSolrClient)this.solrClient).getZkStateReader();
            zkStateReader.forciblyRefreshAllClusterStateSlow();
            ClusterState clusterState = zkStateReader.getClusterState();
            for (String collection : clusterState.getCollectionsMap().keySet()) {
                logger.debug("Clearing collection [{}] in Solr", (Object)collection);
                UpdateRequest deleteAll = this.newUpdateRequest();
                deleteAll.deleteByQuery("*:*");
                this.solrClient.request((SolrRequest)deleteAll, collection);
            }
        }
        catch (SolrServerException e) {
            logger.error("Unable to clear storage from index due to server error on Solr.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to clear storage from index due to low-level I/O error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unable to clear storage from index due to general error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public void clearStore(String storeName) throws BackendException {
        throw new PermanentBackendException("Solr index does not yet support deleting single stores.");
    }

    public boolean supports(KeyInformation information, JanusGraphPredicate predicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (!(mapping == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || mapping == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType))) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return predicate instanceof Cmp;
        }
        if (dataType == Geoshape.class) {
            switch (mapping) {
                case DEFAULT: {
                    return predicate == Geo.WITHIN || predicate == Geo.INTERSECT;
                }
                case PREFIX_TREE: {
                    return predicate == Geo.INTERSECT || predicate == Geo.WITHIN || predicate == Geo.CONTAINS;
                }
            }
        } else if (AttributeUtils.isString((Class)dataType)) {
            switch (mapping) {
                case DEFAULT: 
                case TEXT: {
                    return predicate == Text.CONTAINS || predicate == Text.CONTAINS_PREFIX || predicate == Text.CONTAINS_REGEX || predicate == Text.CONTAINS_FUZZY;
                }
                case STRING: {
                    return predicate instanceof Cmp || predicate == Text.REGEX || predicate == Text.PREFIX || predicate == Text.FUZZY;
                }
                case TEXTSTRING: {
                    return predicate instanceof Cmp || predicate == Text.REGEX || predicate == Text.PREFIX || predicate == Text.FUZZY || predicate == Text.CONTAINS || predicate == Text.CONTAINS_PREFIX || predicate == Text.CONTAINS_REGEX || predicate == Text.CONTAINS_FUZZY;
                }
            }
        } else {
            if (dataType == Date.class || dataType == Instant.class) {
                return predicate instanceof Cmp;
            }
            if (dataType == Boolean.class) {
                return predicate == Cmp.EQUAL || predicate == Cmp.NOT_EQUAL;
            }
            if (dataType == UUID.class) {
                return predicate == Cmp.EQUAL || predicate == Cmp.NOT_EQUAL;
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (Number.class.isAssignableFrom(dataType) || dataType == Date.class || dataType == Instant.class || dataType == Boolean.class || dataType == UUID.class) {
            return mapping == Mapping.DEFAULT;
        }
        if (AttributeUtils.isString((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.TEXT || mapping == Mapping.STRING || mapping == Mapping.TEXTSTRING;
        }
        if (AttributeUtils.isGeo((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.PREFIX_TREE;
        }
        return false;
    }

    public String mapKey2Field(String key, KeyInformation keyInfo) {
        String postfix;
        IndexProvider.checkKeyValidity((String)key);
        key = key.replace(' ', '\u2022');
        if (!this.dynFields) {
            return key;
        }
        if (ParameterType.MAPPED_NAME.hasParameter(keyInfo.getParameters())) {
            return key;
        }
        Class dataType = keyInfo.getDataType();
        if (AttributeUtils.isString((Class)dataType)) {
            Mapping map = SolrIndex.getStringMapping(keyInfo);
            if (keyInfo.getCardinality() == Cardinality.SINGLE) {
                switch (map) {
                    case TEXT: 
                    case TEXTSTRING: {
                        return key + TEXT_SUFFIX;
                    }
                    case STRING: {
                        return key + STRING_SUFFIX;
                    }
                }
                throw new IllegalArgumentException("Unsupported string mapping: " + map);
            }
            switch (map) {
                case TEXT: 
                case TEXTSTRING: {
                    return key + TEXT_SUFFIX_MULTI;
                }
                case STRING: {
                    return key + STRING_SUFFIX_MULTI;
                }
            }
            throw new IllegalArgumentException("Unsupported string mapping: " + map);
        }
        if (AttributeUtils.isWholeNumber((Class)dataType)) {
            postfix = dataType.equals(Long.class) ? "_l" : "_i";
        } else if (AttributeUtils.isDecimal((Class)dataType)) {
            postfix = dataType.equals(Float.class) ? "_f" : "_d";
        } else if (dataType.equals(Geoshape.class)) {
            postfix = "_g";
        } else if (dataType.equals(Date.class) || dataType.equals(Instant.class)) {
            postfix = "_dt";
        } else if (dataType.equals(Boolean.class)) {
            postfix = "_b";
        } else if (dataType.equals(UUID.class)) {
            postfix = "_uuid";
        } else {
            throw new IllegalArgumentException("Unsupported data type [" + dataType + "] for field: " + key);
        }
        if (keyInfo.getCardinality() == Cardinality.SINGLE) {
            return key + postfix;
        }
        return key + postfix + "s";
    }

    public IndexFeatures getFeatures() {
        return SOLR_FEATURES;
    }

    public boolean exists() throws BackendException {
        if (this.mode != Mode.CLOUD) {
            throw new UnsupportedOperationException("Operation only supported for SolrCloud");
        }
        CloudSolrClient server = (CloudSolrClient)this.solrClient;
        try {
            ZkStateReader zkStateReader = server.getZkStateReader();
            zkStateReader.forciblyRefreshAllClusterStateSlow();
            ClusterState clusterState = zkStateReader.getClusterState();
            Map collections = clusterState.getCollectionsMap();
            return collections != null && !collections.isEmpty();
        }
        catch (InterruptedException | KeeperException e) {
            throw new PermanentBackendException("Unable to check if index exists", e);
        }
    }

    static Optional<String> getDualFieldName(String fieldKey, KeyInformation ki) {
        if (AttributeUtils.isString((Class)ki.getDataType()) && Mapping.getMapping((KeyInformation)ki) == Mapping.TEXTSTRING) {
            if (fieldKey.endsWith(TEXT_SUFFIX)) {
                String dualFieldName = fieldKey.substring(0, fieldKey.length() - TEXT_SUFFIX.length());
                return Optional.of(dualFieldName + STRING_SUFFIX);
            }
            if (fieldKey.endsWith(TEXT_SUFFIX_MULTI)) {
                String dualFieldName = fieldKey.substring(0, fieldKey.length() - TEXT_SUFFIX_MULTI.length());
                return Optional.of(dualFieldName + STRING_SUFFIX_MULTI);
            }
            return Optional.of(fieldKey + STRING_SUFFIX);
        }
        return Optional.empty();
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtils.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static Map<Geo, String> spatialPredicates() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Geo, String>(Geo.WITHIN, "IsWithin"), new AbstractMap.SimpleEntry<Geo, String>(Geo.CONTAINS, "Contains"), new AbstractMap.SimpleEntry<Geo, String>(Geo.INTERSECT, "Intersects"), new AbstractMap.SimpleEntry<Geo, String>(Geo.DISJOINT, "IsDisjointTo")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    private UpdateRequest newUpdateRequest() {
        UpdateRequest req = new UpdateRequest();
        if (this.waitSearcher) {
            req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return req;
    }

    private BackendException storageException(Exception solrException) {
        return new TemporaryBackendException("Unable to complete query on Solr.", (Throwable)solrException);
    }

    private static void createCollectionIfNotExists(CloudSolrClient client, Configuration config, String collection) throws IOException, SolrServerException, KeeperException, InterruptedException {
        if (!SolrIndex.checkIfCollectionExists(client, collection)) {
            Integer numShards = (Integer)config.get(NUM_SHARDS, new String[0]);
            Integer maxShardsPerNode = (Integer)config.get(MAX_SHARDS_PER_NODE, new String[0]);
            Integer replicationFactor = (Integer)config.get(REPLICATION_FACTOR, new String[0]);
            String genericConfigSet = config.has(SOLR_DEFAULT_CONFIG, new String[0]) ? (String)config.get(SOLR_DEFAULT_CONFIG, new String[0]) : collection;
            CollectionAdminRequest.Create createRequest = CollectionAdminRequest.createCollection((String)collection, (String)genericConfigSet, (int)numShards, (int)replicationFactor);
            createRequest.setMaxShardsPerNode(maxShardsPerNode);
            CollectionAdminResponse createResponse = (CollectionAdminResponse)createRequest.process((SolrClient)client);
            if (createResponse.isSuccess()) {
                logger.trace("Collection {} successfully created.", (Object)collection);
            } else {
                throw new SolrServerException(Joiner.on((String)"\n").join((Iterable)createResponse.getErrorMessages()));
            }
        }
        SolrIndex.waitForRecoveriesToFinish(client, collection);
    }

    private static boolean checkIfCollectionExists(CloudSolrClient server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        zkStateReader.forceUpdateCollection(collection);
        ClusterState clusterState = zkStateReader.getClusterState();
        return clusterState.getCollectionOrNull(collection) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForRecoveriesToFinish(CloudSolrClient server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        try {
            boolean cont = true;
            while (cont) {
                boolean sawLiveRecovering = false;
                zkStateReader.forceUpdateCollection(collection);
                ClusterState clusterState = zkStateReader.getClusterState();
                Map slices = clusterState.getCollection(collection).getSlicesMap();
                Preconditions.checkNotNull((Object)slices, (Object)("Could not find collection:" + collection));
                for (Map.Entry entry : slices.entrySet()) {
                    Map shards = ((Slice)entry.getValue()).getReplicasMap();
                    for (Map.Entry shard : shards.entrySet()) {
                        String state = ((Replica)shard.getValue()).getStr("state").toUpperCase();
                        if (!Replica.State.RECOVERING.name().equals(state) && !Replica.State.DOWN.name().equals(state) || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name"))) continue;
                        sawLiveRecovering = true;
                    }
                }
                if (!sawLiveRecovering) {
                    cont = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            logger.info("Exiting solr wait");
        }
    }

    private static enum Mode {
        HTTP,
        CLOUD;


        public static Mode parse(String mode) {
            for (Mode m : Mode.values()) {
                if (!m.toString().equalsIgnoreCase(mode)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unrecognized mode: " + mode);
        }
    }
}

