/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.util.input.current;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.graphdb.database.RelationReader;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.TypeInspector;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.formats.util.input.JanusGraphHadoopSetup;
import org.janusgraph.hadoop.formats.util.input.SystemTypeInspector;

public class JanusGraphHadoopSetupImpl
implements JanusGraphHadoopSetup {
    private static final StaticBuffer DEFAULT_COLUMN = StaticArrayBuffer.of((byte[])new byte[0]);
    public static final SliceQuery DEFAULT_SLICE_QUERY = new SliceQuery(DEFAULT_COLUMN, DEFAULT_COLUMN);
    private final ModifiableHadoopConfiguration scanConf;
    private final StandardJanusGraph graph;
    private final StandardJanusGraphTx tx;

    public JanusGraphHadoopSetupImpl(Configuration config) {
        this.scanConf = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, config);
        ModifiableConfiguration bc = this.scanConf.getJanusGraphConf();
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((BasicConfiguration)bc);
        this.tx = (StandardJanusGraphTx)this.graph.buildTransaction().readOnly().vertexCacheSize(200).start();
    }

    @Override
    public TypeInspector getTypeInspector() {
        for (JanusGraphSchemaCategory sc : JanusGraphSchemaCategory.values()) {
            for (JanusGraphVertex k : QueryUtil.getVertices((StandardJanusGraphTx)this.tx, (PropertyKey)BaseKey.SchemaCategory, (Object)sc)) {
                assert (k instanceof JanusGraphSchemaVertex);
                JanusGraphSchemaVertex s = (JanusGraphSchemaVertex)k;
                if (sc.hasName()) {
                    String name = s.name();
                    Preconditions.checkNotNull((Object)name);
                }
                TypeDefinitionMap dm = s.getDefinition();
                Preconditions.checkNotNull((Object)dm);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.OUT);
                s.getRelated(TypeDefinitionCategory.TYPE_MODIFIER, Direction.IN);
            }
        }
        return this.tx;
    }

    @Override
    public SystemTypeInspector getSystemTypeInspector() {
        return new SystemTypeInspector(){

            @Override
            public boolean isSystemType(long typeId) {
                return IDManager.isSystemRelationTypeId((Object)typeId);
            }

            @Override
            public boolean isVertexExistsSystemType(long typeId) {
                return typeId == BaseKey.VertexExists.longId();
            }

            @Override
            public boolean isVertexLabelSystemType(long typeId) {
                return typeId == BaseLabel.VertexLabelEdge.longId();
            }

            @Override
            public boolean isTypeSystemType(long typeId) {
                return typeId == BaseKey.SchemaCategory.longId() || typeId == BaseKey.SchemaDefinitionProperty.longId() || typeId == BaseKey.SchemaDefinitionDesc.longId() || typeId == BaseKey.SchemaName.longId() || typeId == BaseLabel.SchemaDefinitionEdge.longId();
            }
        };
    }

    @Override
    public IDManager getIDManager() {
        return this.graph.getIDManager();
    }

    @Override
    public RelationReader getRelationReader() {
        return this.graph.getEdgeSerializer();
    }

    @Override
    public void close() {
        this.tx.rollback();
        this.graph.close();
    }

    @Override
    public boolean getFilterPartitionedVertices() {
        return (Boolean)this.scanConf.get(JanusGraphHadoopConfiguration.FILTER_PARTITIONED_VERTICES, true, new String[0]);
    }
}

