/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.subquerycache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.transaction.subquerycache.SubsetSubqueryCache;

public class CaffeineSubqueryCache
extends SubsetSubqueryCache {
    private final Cache<JointIndexQuery.Subquery, SubsetSubqueryCache.SubqueryResult> caffeineCache;

    public CaffeineSubqueryCache(long maximumWeight) {
        this.caffeineCache = Caffeine.newBuilder().weigher((q, r) -> 2 + r.size()).maximumWeight(maximumWeight).build();
    }

    @Override
    protected SubsetSubqueryCache.SubqueryResult get(JointIndexQuery.Subquery key) {
        return (SubsetSubqueryCache.SubqueryResult)this.caffeineCache.getIfPresent((Object)key);
    }

    @Override
    protected void put(JointIndexQuery.Subquery key, SubsetSubqueryCache.SubqueryResult result) {
        this.caffeineCache.put((Object)key, (Object)result);
    }

    @Override
    public synchronized void close() {
        this.caffeineCache.invalidateAll();
        this.caffeineCache.cleanUp();
    }
}

