/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration.backend.builder;

import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.backend.KCVSConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class KCVSConfigurationBuilder {
    public KCVSConfiguration buildStandaloneGlobalConfiguration(final KeyColumnValueStoreManager manager, final Configuration config) {
        try {
            final StoreFeatures features = manager.getFeatures();
            return this.buildGlobalConfiguration(new BackendOperation.TransactionalProvider(){

                @Override
                public StoreTransaction openTx() throws BackendException {
                    return manager.beginTransaction(StandardBaseTransactionConfig.of(config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]), features.getKeyConsistentTxConfig()));
                }

                @Override
                public void close() throws BackendException {
                    manager.close();
                }
            }, manager.openDatabase("system_properties"), config);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not open global configuration", e);
        }
    }

    public KCVSConfiguration buildConfiguration(BackendOperation.TransactionalProvider txProvider, KeyColumnValueStore store, String identifier, Configuration config) {
        try {
            KCVSConfiguration keyColumnValueStoreConfiguration = new KCVSConfiguration(txProvider, config, store, identifier);
            keyColumnValueStoreConfiguration.setMaxOperationWaitTime(config.get(GraphDatabaseConfiguration.SETUP_WAITTIME, new String[0]));
            return keyColumnValueStoreConfiguration;
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not open global configuration", e);
        }
    }

    public KCVSConfiguration buildGlobalConfiguration(BackendOperation.TransactionalProvider txProvider, KeyColumnValueStore store, Configuration config) {
        return this.buildConfiguration(txProvider, store, "configuration", config);
    }
}

