/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.InstrumentedThreadFactory;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.janusgraph.util.stats.MetricManager;

public class ExecutorServiceInstrumentation {
    private static final String METRICS_NAMESPACE = "threadpools";
    private static final String METRICS_THREAD_FACTORY = "threadFactory";
    private static final String METRICS_EXECUTOR_SERVICE = "executorService";
    private static final String METRICS_QUEUE_SIZE = "queueSize";

    private ExecutorServiceInstrumentation() {
    }

    public static InstrumentedExecutorService instrument(String metricsPrefix, String name, ExecutorService executorService) {
        return ExecutorServiceInstrumentation.instrument(metricsPrefix, name, executorService, MetricManager.INSTANCE.getRegistry());
    }

    @VisibleForTesting
    static InstrumentedExecutorService instrument(String metricsPrefix, String name, ExecutorService executorService, MetricRegistry registry) {
        if (executorService instanceof ThreadPoolExecutor) {
            registry.gauge(ExecutorServiceInstrumentation.fullMetricsName(metricsPrefix, name, METRICS_EXECUTOR_SERVICE, METRICS_QUEUE_SIZE), () -> () -> ((ThreadPoolExecutor)executorService).getQueue().size());
        }
        return new InstrumentedExecutorService(executorService, registry, ExecutorServiceInstrumentation.fullMetricsName(metricsPrefix, name, METRICS_EXECUTOR_SERVICE));
    }

    public static InstrumentedThreadFactory instrument(String metricsPrefix, String name, ThreadFactory threadFactory) {
        return ExecutorServiceInstrumentation.instrument(metricsPrefix, name, threadFactory, MetricManager.INSTANCE.getRegistry());
    }

    @VisibleForTesting
    static InstrumentedThreadFactory instrument(String metricsPrefix, String name, ThreadFactory threadFactory, MetricRegistry registry) {
        return new InstrumentedThreadFactory(threadFactory, registry, ExecutorServiceInstrumentation.fullMetricsName(metricsPrefix, name, METRICS_THREAD_FACTORY));
    }

    private static String fullMetricsName(String prefix, String ... parts) {
        return prefix + "." + METRICS_NAMESPACE + "." + String.join((CharSequence)".", parts);
    }
}

