/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.AtomicLongComponent;
import com.sleepycat.je.utilint.MapStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class AtomicLongMapStat
extends MapStat<Long, AtomicLongComponent> {
    private static final long serialVersionUID = 1L;

    public AtomicLongMapStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    private AtomicLongMapStat(AtomicLongMapStat other) {
        super(other);
    }

    public synchronized AtomicLongComponent createStat(String key) {
        assert (key != null);
        AtomicLongComponent stat = new AtomicLongComponent();
        this.statMap.put(key, stat);
        return stat;
    }

    @Override
    public AtomicLongMapStat copy() {
        return new AtomicLongMapStat(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicLongMapStat computeInterval(Stat<String> base) {
        assert (base instanceof AtomicLongMapStat);
        AtomicLongMapStat copy = this.copy();
        if (this.definition.getType() != StatDefinition.StatType.INCREMENTAL) {
            return copy;
        }
        AtomicLongMapStat baseMapStat = (AtomicLongMapStat)base;
        AtomicLongMapStat atomicLongMapStat = copy;
        synchronized (atomicLongMapStat) {
            for (Map.Entry entry : copy.statMap.entrySet()) {
                AtomicLongComponent baseValue;
                AtomicLongMapStat atomicLongMapStat2 = baseMapStat;
                synchronized (atomicLongMapStat2) {
                    baseValue = (AtomicLongComponent)baseMapStat.statMap.get(entry.getKey());
                }
                if (baseValue == null) continue;
                AtomicLongComponent entryValue = (AtomicLongComponent)entry.getValue();
                entryValue.val.getAndAdd(-baseValue.get().longValue());
            }
        }
        return copy;
    }

    @Override
    public synchronized void negate() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            for (AtomicLongComponent stat : this.statMap.values()) {
                long val;
                AtomicLong atomicVal = stat.val;
                while (!atomicVal.compareAndSet(val = atomicVal.get(), -val)) {
                }
            }
        }
    }
}

