/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer.traversal.strategy;

import org.apache.tinkerpop.gremlin.hadoop.process.computer.traversal.step.sideEffect.HadoopIoStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.ReadWriting;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IoStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class HadoopIoStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final HadoopIoStrategy INSTANCE = new HadoopIoStrategy();

    private HadoopIoStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getStartStep() instanceof IoStep) {
            throw new VerificationException("HadoopGraph requires a GraphComputer for io() step", traversal);
        }
        if (traversal.getStartStep() instanceof TraversalVertexProgramStep) {
            TraversalVertexProgramStep tvp = (TraversalVertexProgramStep)traversal.getStartStep();
            if (tvp.computerTraversal.get().getStartStep() instanceof ReadWriting) {
                ReadWriting readWriting = (ReadWriting)tvp.computerTraversal.get().getStartStep();
                HadoopIoStep hadoopIoStep = new HadoopIoStep(traversal, readWriting.getFile());
                hadoopIoStep.setMode(readWriting.getMode());
                hadoopIoStep.setComputer(tvp.getComputer());
                readWriting.getParameters().getRaw(new Object[0]).forEach((key, value) -> value.forEach(v -> hadoopIoStep.configure(key, v)));
                TraversalHelper.replaceStep((Step)tvp, (Step)hadoopIoStep, traversal);
            }
        }
    }

    public static HadoopIoStrategy instance() {
        return INSTANCE;
    }
}

