/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.tools.util.WorkReport;
import org.apache.hadoop.tools.util.WorkRequest;
import org.apache.hadoop.tools.util.WorkRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerConsumer<T, R> {
    private Logger LOG = LoggerFactory.getLogger(ProducerConsumer.class);
    private LinkedBlockingQueue<WorkRequest<T>> inputQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<WorkReport<R>> outputQueue = new LinkedBlockingQueue();
    private ExecutorService executor;
    private AtomicInteger workCnt;

    public ProducerConsumer(int numThreads) {
        this.executor = Executors.newFixedThreadPool(numThreads);
        this.workCnt = new AtomicInteger(0);
    }

    public void addWorker(WorkRequestProcessor<T, R> processor) {
        this.executor.execute(new Worker(processor));
    }

    public void shutdown() {
        if (this.hasWork()) {
            this.LOG.warn("Shutdown() is called but there are still unprocessed work!");
        }
        this.executor.shutdownNow();
    }

    public int getWorkCnt() {
        return this.workCnt.get();
    }

    public boolean hasWork() {
        return this.workCnt.get() > 0;
    }

    public void put(WorkRequest<T> workRequest) {
        boolean isDone = false;
        while (!isDone) {
            try {
                this.inputQueue.put(workRequest);
                this.workCnt.incrementAndGet();
                isDone = true;
            }
            catch (InterruptedException ie) {
                this.LOG.error("Could not put workRequest into inputQueue. Retrying...");
            }
        }
    }

    public WorkReport<R> take() throws InterruptedException {
        WorkReport<R> report = this.outputQueue.take();
        this.workCnt.decrementAndGet();
        return report;
    }

    public WorkReport<R> blockingTake() {
        while (true) {
            try {
                WorkReport<R> report = this.outputQueue.take();
                this.workCnt.decrementAndGet();
                return report;
            }
            catch (InterruptedException ie) {
                this.LOG.debug("Retrying in blockingTake...");
                continue;
            }
            break;
        }
    }

    private class Worker
    implements Runnable {
        private WorkRequestProcessor<T, R> processor;

        public Worker(WorkRequestProcessor<T, R> processor) {
            this.processor = processor;
        }

        @Override
        public void run() {
            block4: while (true) {
                WorkRequest work;
                try {
                    work = (WorkRequest)ProducerConsumer.this.inputQueue.take();
                }
                catch (InterruptedException e) {
                    ProducerConsumer.this.LOG.debug("Interrupted while waiting for requests from inputQueue.");
                    return;
                }
                boolean isDone = false;
                while (true) {
                    if (isDone) continue block4;
                    try {
                        WorkReport result = this.processor.processItem(work);
                        ProducerConsumer.this.outputQueue.put(result);
                        isDone = true;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        ProducerConsumer.this.LOG.debug("Worker thread was interrupted while processing an item, or putting into outputQueue. Retrying...");
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }
}

