/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Collections;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Failure;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;

public class FailStep<S>
extends SideEffectStep<S> {
    protected String message;
    protected Map<String, Object> metadata;

    public FailStep(Traversal.Admin traversal) {
        this(traversal, "fail() step triggered");
    }

    public FailStep(Traversal.Admin traversal, String message) {
        this(traversal, message, Collections.emptyMap());
    }

    public FailStep(Traversal.Admin traversal, String message, Map<String, Object> metadata) {
        super(traversal);
        this.message = message;
        this.metadata = metadata;
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        throw new FailException(this.traversal, traverser, this.message, this.metadata);
    }

    public static class FailException
    extends RuntimeException
    implements Failure {
        private final Map<String, Object> metadata;
        private final Traversal.Admin traversal;
        private final Traverser.Admin traverser;

        public FailException(Traversal.Admin traversal, Traverser.Admin traverser, String message, Map<String, Object> metadata) {
            super(message);
            this.metadata = metadata;
            this.traversal = traversal;
            this.traverser = traverser;
        }

        @Override
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        @Override
        public Traverser.Admin getTraverser() {
            return this.traverser;
        }

        @Override
        public Traversal.Admin getTraversal() {
            return this.traversal;
        }
    }
}

