/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ConcatStep<S>
extends ScalarMapStep<S, String>
implements TraversalParent {
    private String stringArgsResult;
    private Traversal.Admin<S, String> concatTraversal;
    private boolean isNullTraverser = true;
    private boolean isNullTraversal = true;
    private boolean isNullString = true;

    public ConcatStep(Traversal.Admin traversal, String ... concatStrings) {
        super(traversal);
        this.stringArgsResult = this.processStrings(concatStrings);
    }

    public ConcatStep(Traversal.Admin traversal, Traversal<S, String> concatTraversal) {
        super(traversal);
        this.concatTraversal = this.integrateChild(concatTraversal.asAdmin());
    }

    @Override
    protected String map(Traverser.Admin<S> traverser) {
        if (null != traverser.get() && !(traverser.get() instanceof String)) {
            throw new IllegalArgumentException(String.format("String concat() can only take string as argument, encountered %s", traverser.get().getClass()));
        }
        StringBuilder sb = new StringBuilder();
        if (null != traverser.get()) {
            this.isNullTraverser = false;
            sb.append(traverser.get());
        }
        if (null != this.concatTraversal) {
            if (this.concatTraversal.getStartStep() instanceof InjectStep) {
                String result;
                if (this.concatTraversal.hasNext() && null != (result = (String)this.concatTraversal.next())) {
                    this.isNullTraversal = false;
                    sb.append(result);
                }
            } else {
                sb.append(TraversalUtil.apply(traverser, this.concatTraversal));
            }
        }
        if (!this.isNullString) {
            sb.append(this.stringArgsResult);
        }
        if (this.isNullTraverser && this.isNullTraversal && this.isNullString) {
            return null;
        }
        this.isNullTraverser = true;
        this.isNullTraversal = true;
        return sb.toString();
    }

    private String processStrings(String[] concatStrings) {
        StringBuilder sb = new StringBuilder();
        if (null != concatStrings && concatStrings.length != 0) {
            for (String s : concatStrings) {
                if (null == s) continue;
                this.isNullString = false;
                sb.append(s);
            }
        }
        return this.isNullString ? null : sb.toString();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.concatTraversal);
    }

    @Override
    public ConcatStep<S> clone() {
        ConcatStep clone = (ConcatStep)super.clone();
        if (null != this.concatTraversal) {
            clone.concatTraversal = this.concatTraversal.clone();
        }
        return clone;
    }

    public List<Traversal.Admin<S, String>> getLocalChildren() {
        return null == this.concatTraversal ? Collections.emptyList() : Collections.singletonList(this.concatTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.concatTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (null != this.concatTraversal) {
            result = super.hashCode() ^ this.concatTraversal.hashCode();
        }
        if (null != this.stringArgsResult) {
            result = super.hashCode() ^ this.stringArgsResult.hashCode();
        }
        return result;
    }
}

