/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.LabelStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.DirectPropertiesFetchingService;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.CopyStepUtil;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class JanusGraphElementMapStep<K, E>
extends ElementMapStep<K, E>
implements Profiling,
MultiQueriable<Element, Map<K, E>> {
    private boolean useMultiQuery = false;
    private LabelStepBatchFetcher labelStepBatchFetcher;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int batchSize = Integer.MAX_VALUE;
    private final boolean prefetchAllPropertiesRequired;
    private final boolean prefetchingAllowed;
    private DirectPropertiesFetchingService directPropertiesFetchingService;

    public JanusGraphElementMapStep(ElementMapStep<K, E> originalStep, boolean prefetchAllPropertiesRequired, boolean prefetchingAllowed) {
        super(originalStep.getTraversal(), originalStep.getPropertyKeys());
        CopyStepUtil.copyAbstractStepModifiableFields(originalStep, this);
        this.prefetchAllPropertiesRequired = prefetchAllPropertiesRequired;
        this.prefetchingAllowed = prefetchingAllowed;
        if (originalStep.isOnGraphComputer()) {
            this.onGraphComputer();
        }
        if (originalStep instanceof JanusGraphElementMapStep) {
            JanusGraphElementMapStep originalJanusGraphElementMapStep = (JanusGraphElementMapStep)originalStep;
            this.setBatchSize(originalJanusGraphElementMapStep.batchSize);
            this.setUseMultiQuery(originalJanusGraphElementMapStep.useMultiQuery);
        }
    }

    protected Map<K, E> map(Traverser.Admin<Element> traverser) {
        if (this.useMultiQuery && traverser.get() instanceof Vertex) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Vertex vertexToFetch = (Vertex)traverser.get();
            int loops = JanusGraphTraverserUtil.getLoops(traverser);
            this.addElementProperties(map, vertexToFetch, loops);
            this.addIncludedOptions(map, vertexToFetch, loops);
            return map;
        }
        return super.map(traverser);
    }

    private void addElementProperties(Map<Object, Object> map, Vertex vertexToFetch, int loops) {
        Iterator<? extends Property> properties = this.directPropertiesFetchingService.fetchProperties(this.getTraversal(), vertexToFetch, loops);
        while (properties.hasNext()) {
            Property property = properties.next();
            map.put(property.key(), property.value());
        }
    }

    private void addIncludedOptions(Map<Object, Object> map, Vertex vertexToFetch, int loops) {
        map.put(T.id, vertexToFetch.id());
        map.put(T.label, this.labelStepBatchFetcher.fetchData(this.getTraversal(), vertexToFetch, loops));
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
        if (this.directPropertiesFetchingService != null) {
            this.directPropertiesFetchingService.setQueryProfiler(this.queryProfiler);
        }
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        boolean bl = this.useMultiQuery = this.prefetchingAllowed && useMultiQuery;
        if (this.useMultiQuery) {
            if (this.directPropertiesFetchingService == null) {
                this.directPropertiesFetchingService = new DirectPropertiesFetchingService(this.getPropertyKeys(), this.batchSize, this.prefetchAllPropertiesRequired, this.queryProfiler);
            }
            if (this.labelStepBatchFetcher == null) {
                this.labelStepBatchFetcher = new LabelStepBatchFetcher(this::makeLabelsQuery, this.batchSize);
            }
        }
    }

    private <Q extends BaseVertexQuery> Q makeLabelsQuery(Q query) {
        return BasicVertexCentricQueryUtil.withLabelVertices((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.directPropertiesFetchingService != null) {
            this.directPropertiesFetchingService.setBatchSize(batchSize);
        }
        if (this.labelStepBatchFetcher != null) {
            this.labelStepBatchFetcher.setBatchSize(batchSize);
        }
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.labelStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
            this.directPropertiesFetchingService.registerFirstNewLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.labelStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            this.directPropertiesFetchingService.registerSameLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.labelStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            this.directPropertiesFetchingService.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
        }
    }
}

